/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.alt;

import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.entity.TransformerAnimatable;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractTransformerTankModel<T extends LivingEntity, A extends TransformerAnimatable>
extends AbstractTransformerModel<T, A>
implements HeadedModel {
    protected final ArrayList<ModelPart> wheels;
    public final HumanoidModel<T> humanoidModel = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_));

    public AbstractTransformerTankModel(ModelPart root) {
        super(root);
        this.wheels = new ArrayList();
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.wheels.forEach(wheel -> this.animateWheel((ModelPart)wheel, limbSwing));
        ModelPart head = this.m_5585_();
        float yRot = netHeadYaw * (float)Math.PI / 180.0f;
        float xRot = headPitch * (float)Math.PI / 180.0f;
        float xRotFinal = Mth.m_14036_((float)xRot, (float)this.getMinClamp(), (float)this.getMaxClamp());
        float headRot = this.states.getTransformAnimState().m_216984_() ? 1.0f - this.transformationProgress() : this.transformationProgress();
        head.f_104203_ = Mth.m_14189_((float)headRot, (float)xRotFinal, (float)head.f_104203_);
        head.f_104204_ = Mth.m_14189_((float)headRot, (float)yRot, (float)head.f_104204_);
    }

    protected void animateWheel(ModelPart wheel, float limbSwing) {
        wheel.f_104203_ = limbSwing / this.getWheelSpeed();
    }

    public abstract ModelPart m_5585_();

    public abstract float getMinClamp();

    public abstract float getMaxClamp();

    public abstract float getWheelSpeed();
}

