/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.AnimPair;
import bnb.tfp.client.animation.TransformerAnimations;
import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.entity.TransformerAnimatable;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractTransformerBotModel<T extends LivingEntity, A extends TransformerAnimatable>
extends AbstractTransformerModel<T, A>
implements ArmedModel,
HeadedModel {
    protected TransformerAnimations animations;
    public final HumanoidModel<T> humanoidModel = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_));
    public static int x;
    public static int y;
    public static int z;
    public static int xRot;
    public static int yRot;
    public static int zRot;

    public AbstractTransformerBotModel(ModelPart root, TransformerAnimations animations, Function<ResourceLocation, RenderType> renderType) {
        super(root, renderType);
        this.humanoidModel.f_102610_ = false;
        this.animations = animations;
    }

    public AbstractTransformerBotModel(ModelPart root, TransformerAnimations animations) {
        this(root, animations, RenderType::m_110458_);
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack, float xOffset, float yOffset, float zOffset) {
        this.m_142109_().m_104299_(poseStack);
        this.getHandDirectory(arm).forEach(modelPart -> modelPart.m_104299_(poseStack));
        poseStack.m_252880_((arm == HumanoidArm.LEFT ? xOffset : -xOffset) / 16.0f, -yOffset / 16.0f, -zOffset / 16.0f);
    }

    public abstract void m_6002_(HumanoidArm var1, PoseStack var2);

    public static void copyOffsetAndRot(ModelPart part, ModelPart part1) {
        PartPose initial = part1.m_233566_();
        part.m_252854_(new Vector3f(part1.f_104200_ - initial.f_171405_, part1.f_104201_ - initial.f_171406_, part1.f_104202_ - initial.f_171407_));
        part.m_252899_(new Vector3f(part1.f_104203_ - initial.f_171408_, part1.f_104204_ - initial.f_171409_, part1.f_104205_ - initial.f_171410_));
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        this.humanoidModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ModelPart head = this.m_5585_();
        ModelPart leftArm = this.getArm(HumanoidArm.LEFT);
        ModelPart rightArm = this.getArm(HumanoidArm.RIGHT);
        ModelPart rightLeg = this.getRightLeg();
        ModelPart leftLeg = this.getLeftLeg();
        if (this.humanoidModel.f_102818_ > 0.0f) {
            this.humanoidModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            this.humanoidModel.m_6973_(entity, 0.0f, 0.0f, ageInTicks, netHeadYaw, headPitch);
        }
        float yHeadRot = head.f_104204_;
        float xHeadRot = head.f_104203_;
        AbstractTransformerBotModel.copyOffsetAndRot(head, this.humanoidModel.f_102808_);
        float headRot = this.states.getTransformAnimState().m_216984_() ? 1.0f - this.transformationProgress() : this.transformationProgress();
        head.f_104204_ = Mth.m_14189_((float)headRot, (float)yHeadRot, (float)head.f_104204_);
        head.f_104203_ = Mth.m_14189_((float)headRot, (float)xHeadRot, (float)head.f_104203_);
        if (this.states.getTransformAnimState().m_216984_()) {
            return;
        }
        AbstractTransformerBotModel.copyOffsetAndRot(rightArm, this.humanoidModel.f_102811_);
        AbstractTransformerBotModel.copyOffsetAndRot(leftArm, this.humanoidModel.f_102812_);
        if (this.humanoidModel.f_102818_ > 0.0f) {
            AbstractTransformerBotModel.copyOffsetAndRot(rightLeg, this.humanoidModel.f_102813_);
            AbstractTransformerBotModel.copyOffsetAndRot(leftLeg, this.humanoidModel.f_102814_);
        } else {
            if (this.humanoidModel.f_102816_ == HumanoidModel.ArmPose.EMPTY && !this.humanoidModel.f_102815_.m_102897_()) {
                AnimationUtils.m_170341_((ModelPart)rightArm, (float)ageInTicks, (float)-1.0f);
            }
            if (this.humanoidModel.f_102815_ == HumanoidModel.ArmPose.EMPTY && !this.humanoidModel.f_102816_.m_102897_()) {
                AnimationUtils.m_170341_((ModelPart)leftArm, (float)ageInTicks, (float)1.0f);
            }
        }
        this.m_233381_(this.states.getIdleAnimState(), this.animations.idleAnimation(), ageInTicks);
        this.m_233381_(this.states.getSettleAnimState(), this.animations.settle(), ageInTicks);
        if (this.states.getRevertAnimState().m_216984_()) {
            return;
        }
        if (this.states.getFallAnimState().m_216984_()) {
            this.m_233385_(this.states.getFallAnimState(), this.animations.fallingAnimations().mainAnimation(), ageInTicks, this.fallingAnimSpeed());
        } else if (!entity.m_6069_()) {
            if (entity.m_20142_()) {
                this.animateRunning(entity, limbSwing, limbSwingAmount);
            } else {
                this.animateWalk(entity, limbSwing, limbSwingAmount);
            }
        }
        this.states.getLandAnimState().m_216979_(state -> {
            if ((double)state.m_216981_() / 1000.0 <= (double)this.animations.fallingAnimations().oppositeAnimation().f_232255_()) {
                this.m_233381_((AnimationState)state, this.animations.fallingAnimations().oppositeAnimation(), ageInTicks);
            } else {
                state.m_216973_();
            }
        });
        this.m_233385_(this.states.getCrouchAnimState(), this.animations.crouchingAnimations().mainAnimation(), ageInTicks, this.crouchingAnimSpeed());
        this.states.getUncrouchAnimState().m_216979_(state -> {
            if ((double)state.m_216981_() / 1000.0 <= (double)this.animations.crouchingAnimations().oppositeAnimation().f_232255_()) {
                this.m_233385_((AnimationState)state, this.animations.crouchingAnimations().oppositeAnimation(), ageInTicks, this.crouchingAnimSpeed());
            } else {
                state.m_216973_();
            }
        });
        if (!this.isGunLoaded()) {
            this.states.getAttackAnimState().m_216979_(state -> {
                AnimationDefinition attackAnim = this.getAttackingAnimation(entity);
                if ((double)state.m_216981_() / 1000.0 < (double)attackAnim.f_232255_()) {
                    this.m_233381_((AnimationState)state, attackAnim, ageInTicks);
                } else {
                    state.m_216973_();
                }
            });
        }
        if (!this.states.getAttackAnimState().m_216984_()) {
            this.m_233381_(this.states.getLoadWeaponAnimState(), this.animations.weaponAnimations().mainAnimation(), ageInTicks);
        }
        this.m_233381_(this.states.getHideWeaponAnimState(), this.animations.weaponAnimations().oppositeAnimation(), ageInTicks);
        boolean gunLoaded = this.isGunLoaded();
        float gunProcess = this.getGunProcess();
        if (gunLoaded || gunProcess < 1.0f) {
            ArrayList<ModelPart> list = new ArrayList<ModelPart>();
            if (this.animations.rightGun()) {
                List<ModelPart> right = this.getHandDirectory(HumanoidArm.RIGHT);
                list.addAll(right.subList(right.indexOf(rightArm), right.size()));
            }
            if (this.animations.leftGun()) {
                List<ModelPart> left = this.getHandDirectory(HumanoidArm.LEFT);
                list.addAll(left.subList(left.indexOf(leftArm), left.size()));
            }
            float gunLoading = gunLoaded ? 1.0f - gunProcess : gunProcess;
            for (ModelPart modelPart : list) {
                PartPose pose = modelPart.m_233566_();
                modelPart.f_104203_ = pose.f_171408_ + gunLoading * (modelPart.f_104203_ - pose.f_171408_);
                modelPart.f_104204_ = pose.f_171409_ + gunLoading * (modelPart.f_104204_ - pose.f_171409_);
                modelPart.f_104205_ = pose.f_171410_ + gunLoading * (modelPart.f_104205_ - pose.f_171410_);
            }
            gunLoading = 1.0f - gunLoading;
            this.positionGun(entity, ageInTicks, netHeadYaw, headPitch, gunLoading);
            gunLoading *= (float)Math.PI / 180;
            if (this.animations.rightGun()) {
                rightArm.f_104205_ *= 1.0f - Math.abs(Mth.m_14177_((float)headPitch) / 90.0f);
                rightArm.f_104203_ += gunLoading * (Mth.m_14177_((float)headPitch) * Mth.m_14089_((float)rightArm.f_104205_) + Mth.m_14177_((float)netHeadYaw) * Mth.m_14031_((float)rightArm.f_104205_));
                rightArm.f_104204_ += gunLoading * (Mth.m_14177_((float)netHeadYaw) * Mth.m_14089_((float)rightArm.f_104205_) - Mth.m_14177_((float)headPitch) * Mth.m_14031_((float)rightArm.f_104205_));
            }
            if (this.animations.leftGun()) {
                leftArm.f_104205_ *= 1.0f - Math.abs(Mth.m_14177_((float)headPitch) / 90.0f);
                leftArm.f_104203_ += gunLoading * (Mth.m_14177_((float)headPitch) * Mth.m_14089_((float)leftArm.f_104205_) + Mth.m_14177_((float)netHeadYaw) * Mth.m_14031_((float)leftArm.f_104205_));
                leftArm.f_104204_ += gunLoading * (Mth.m_14177_((float)netHeadYaw) * Mth.m_14089_((float)leftArm.f_104205_) - Mth.m_14177_((float)headPitch) * Mth.m_14031_((float)leftArm.f_104205_));
            }
        } else {
            this.positionGun(entity, ageInTicks, netHeadYaw, headPitch, 0.0f);
        }
    }

    public void animateHeadOnLaptop(PlayableTransformer transformer) {
        ModelPart head = this.m_5585_();
        head.m_171331_().forEach(ModelPart::m_233569_);
        head.m_104227_(0.0f, 0.0f, 0.0f);
    }

    public void positionGun(T entity, float ageInTicks, float netHeadYaw, float headPitch, float gunLoading) {
        AnimationDefinition anim = this.getAttackingAnimation(entity);
        if (this.isGunLoaded()) {
            if (this.states.getAttackAnimState().m_216984_() && (double)this.states.getAttackAnimState().m_216981_() / 1000.0 < (double)anim.f_232255_()) {
                this.m_233381_(this.states.getAttackAnimState(), anim, ageInTicks);
            } else {
                this.states.getAttackAnimState().m_216973_();
                this.m_233381_(this.states.getLoadGunAnimState(), this.animations.gunAnimations().mainAnimation(), ageInTicks);
            }
        }
        this.m_233381_(this.states.getHideGunAnimState(), this.animations.gunAnimations().oppositeAnimation(), ageInTicks);
    }

    public boolean isGunLoaded() {
        return this.states.getLoadGunAnimState().m_216984_();
    }

    public boolean isWeaponLoaded() {
        return this.states.getLoadWeaponAnimState().m_216984_();
    }

    public float getGunProcess() {
        return Mth.m_14036_((float)(this.states.getLoadGunAnimState().m_216984_() ? (float)this.states.getLoadGunAnimState().m_216981_() / 1000.0f / this.animations.gunAnimations().mainAnimation().f_232255_() : (float)this.states.getHideGunAnimState().m_216981_() / 1000.0f / this.animations.gunAnimations().oppositeAnimation().f_232255_()), (float)0.0f, (float)1.0f);
    }

    public boolean shouldCancelArmSwinging() {
        return this.isGunLoaded();
    }

    public void setupHandAnim(T entity, float ageInTicks, HumanoidArm arm) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(this.states.getIdleAnimState(), this.animations.idleAnimation(), ageInTicks);
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>(this.getHandDirectory(arm));
        parts.remove(parts.size() - 1);
        ArrayDeque deque = new ArrayDeque();
        parts.forEach(modelPart -> deque.addLast(modelPart.m_171308_()));
        this.setupHandAnimWithoutChangingPosition(entity, ageInTicks, arm);
        parts.forEach(modelPart -> modelPart.m_171322_(Objects.requireNonNull((PartPose)deque.pollFirst())));
        boolean gunLoaded = this.isGunLoaded();
        float gunLoading = this.getGunProcess();
        if (!gunLoaded) {
            gunLoading = 1.0f - gunLoading;
        }
        if (gunLoading > 0.0f) {
            this.positionGunFirstPerson(this.getArm(arm), arm == HumanoidArm.RIGHT ? 1 : -1, gunLoading);
        }
    }

    public void setupHandAnimWithoutChangingPosition(T entity, float ageInTicks, HumanoidArm arm) {
        AnimationDefinition anim = this.getAttackingAnimation(entity);
        if (this.states.getAttackAnimState().m_216984_() && (double)this.states.getAttackAnimState().m_216981_() / 1000.0 <= (double)anim.f_232255_()) {
            this.m_233381_(this.states.getAttackAnimState(), anim, ageInTicks);
        } else {
            this.states.getAttackAnimState().m_216973_();
            this.m_233381_(this.states.getLoadGunAnimState(), this.animations.gunAnimations().mainAnimation(), ageInTicks);
            this.m_233381_(this.states.getLoadWeaponAnimState(), this.animations.weaponAnimations().mainAnimation(), ageInTicks);
        }
        this.m_233381_(this.states.getHideGunAnimState(), this.animations.gunAnimations().oppositeAnimation(), ageInTicks);
        this.m_233381_(this.states.getHideWeaponAnimState(), this.animations.weaponAnimations().oppositeAnimation(), ageInTicks);
    }

    public void positionGunFirstPerson(ModelPart armModel, int handSign, float gunLoadProcess) {
        armModel.m_252854_(new Vector3f((float)(handSign * x), (float)y, (float)z).mul(gunLoadProcess));
        armModel.m_252899_(new Vector3f((float)xRot, (float)(handSign * yRot), (float)(handSign * zRot)).mul(gunLoadProcess * (float)Math.PI / 180.0f));
    }

    public void renderHand(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, HumanoidArm arm) {
        this.getArm(arm).m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected float fallingAnimSpeed() {
        return 3.0f;
    }

    protected float crouchingAnimSpeed() {
        return 2.0f;
    }

    public abstract ModelPart m_5585_();

    public abstract ModelPart getArm(HumanoidArm var1);

    public abstract List<ModelPart> getHandDirectory(HumanoidArm var1);

    public abstract ModelPart getRightLeg();

    public abstract ModelPart getLeftLeg();

    @Override
    protected AnimationDefinition transformAnimation() {
        return this.animations.transformingAnimations().mainAnimation();
    }

    @Override
    protected AnimationDefinition revertAnimation() {
        return this.states.doAFlip() ? this.animations.doAFlip() : this.animations.transformingAnimations().oppositeAnimation();
    }

    protected AnimationDefinition getAttackingAnimation(T player) {
        List<AnimPair> pairs = this.isGunLoaded() ? this.animations.shootingAnimations() : (this.isWeaponLoaded() ? this.animations.weaponAttackingAnimations() : this.animations.attackingAnimations());
        int size = pairs.size();
        AnimPair pair = pairs.get(Mth.m_14045_((int)((int)(this.states.attackAnimIndex() * (float)size)), (int)0, (int)(size - 1)));
        return ((LivingEntity)player).f_20912_ == InteractionHand.MAIN_HAND == (player.m_5737_() == HumanoidArm.RIGHT) ? pair.mainAnimation() : pair.oppositeAnimation();
    }

    protected void animateWalk(T entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(this.animations.walkingAnimation(), limbSwing, limbSwingAmount, 1.5f, 1.0f);
    }

    protected void animateRunning(T entity, float limbSwing, float limbSwingAmount) {
        this.animateWalk(entity, limbSwing, limbSwingAmount);
    }
}

