/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.BreakdownAnimation;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.entity.TransformerAnimatable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BreakdownModel<T extends LivingEntity, A extends TransformerAnimatable>
extends AbstractTransformerBotModel<T, A> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "breakdown"), "main");
    private final ModelPart breakdown;
    private final ModelPart upperBody;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightShoulder;
    private final ModelPart rightArm;
    private final ModelPart lowerRightArm;
    private final ModelPart rightHand;
    private final ModelPart leftShoulder;
    private final ModelPart leftArm;
    private final ModelPart lowerLeftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart turret;

    public BreakdownModel(ModelPart root) {
        super(root, BreakdownAnimation.ANIMATIONS);
        this.breakdown = root.m_171324_("Breakdown");
        this.upperBody = this.breakdown.m_171324_("UpperBody");
        this.body = this.upperBody.m_171324_("Body");
        this.head = this.body.m_171324_("Head");
        this.rightShoulder = this.body.m_171324_("RightShoulder");
        this.rightArm = this.rightShoulder.m_171324_("RightArm");
        this.lowerRightArm = this.rightArm.m_171324_("LowerRightArm");
        this.rightHand = this.lowerRightArm.m_171324_("RightHand");
        this.leftShoulder = this.body.m_171324_("LeftShoulder");
        this.leftArm = this.leftShoulder.m_171324_("LeftArm");
        this.lowerLeftArm = this.leftArm.m_171324_("LowerLeftArm");
        this.leftHand = this.lowerLeftArm.m_171324_("LeftHand");
        ModelPart lowerBody = this.breakdown.m_171324_("LowerBody");
        this.rightLeg = lowerBody.m_171324_("RightLeg");
        this.leftLeg = lowerBody.m_171324_("LeftLeg");
        this.turret = this.body.m_171324_("BodyArmor").m_171324_("MiniTurret");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Breakdown = partdefinition.m_171599_("Breakdown", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition UpperBody = Breakdown.m_171599_("UpperBody", CubeListBuilder.m_171558_().m_171514_(1, 37).m_171488_(-6.0f, -7.0f, -2.5f, 12.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)0.0f));
        PartDefinition SideLeft = UpperBody.m_171599_("SideLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)32.5f, (float)0.0f));
        PartDefinition Body_r1 = SideLeft.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(14, 40).m_171488_(-1.5f, -40.0f, -1.0f, 2.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition SideRight = UpperBody.m_171599_("SideRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)32.5f, (float)0.0f));
        PartDefinition Body_r2 = SideRight.m_171599_("Body_r2", CubeListBuilder.m_171558_().m_171514_(14, 40).m_171480_().m_171488_(-0.5f, -40.0f, -1.0f, 2.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition Armor = UpperBody.m_171599_("Armor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)5.0f));
        PartDefinition Body_r3 = Armor.m_171599_("Body_r3", CubeListBuilder.m_171558_().m_171514_(86, 112).m_171488_(-6.0f, -35.5f, -3.5f, 14.0f, 8.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)-1.0f, (float)28.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Body_r4 = Armor.m_171599_("Body_r4", CubeListBuilder.m_171558_().m_171514_(133, 69).m_171488_(-5.0f, -39.0f, 2.0f, 10.0f, 4.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)33.0f, (float)-7.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Body_r5 = Armor.m_171599_("Body_r5", CubeListBuilder.m_171558_().m_171514_(28, 109).m_171488_(-7.0f, -5.5f, 4.5f, 14.0f, 8.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-4.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Body = UpperBody.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-9.0f, -9.0f, -4.0f, 18.0f, 9.0f, 9.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)1.0f));
        PartDefinition Body_r6 = Body.m_171599_("Body_r6", CubeListBuilder.m_171558_().m_171514_(44, 50).m_171488_(-9.0f, 0.5f, -3.0f, 18.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)-4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Body_r7 = Body.m_171599_("Body_r7", CubeListBuilder.m_171558_().m_171514_(148, 92).m_171488_(-2.5f, -3.0f, -4.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.5f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(148, 0).m_171488_(-3.0f, -4.0f, -1.5f, 6.0f, 4.0f, 4.0f, new CubeDeformation(-0.01f)).m_171514_(30, 75).m_171488_(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)).m_171514_(74, 32).m_171488_(-2.5f, -3.5f, -3.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(148, 8).m_171488_(-3.0f, -5.5f, -3.0f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(110, 156).m_171488_(-1.0f, -6.5f, -3.5f, 2.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(112, 156).m_171488_(-0.5f, -6.0f, -3.6f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(35, 52).m_171488_(-1.5f, -7.5f, -3.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(44, 154).m_171488_(-3.0f, -5.5f, 1.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.01f)).m_171514_(74, 36).m_171488_(-1.5f, -2.0f, -2.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)-10.5f, (float)-0.5f));
        PartDefinition Head_r1 = Head.m_171599_("Head_r1", CubeListBuilder.m_171558_().m_171514_(152, 141).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)1.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition Head_r2 = Head.m_171599_("Head_r2", CubeListBuilder.m_171558_().m_171514_(126, 143).m_171488_(-8.5f, -54.5f, -8.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)53.0f, (float)-1.5f, (float)0.0f, (float)0.6981f, (float)0.1745f));
        PartDefinition Head_r3 = Head.m_171599_("Head_r3", CubeListBuilder.m_171558_().m_171514_(116, 15).m_171488_(6.5f, -54.5f, -8.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)53.0f, (float)-1.5f, (float)0.0f, (float)-0.6981f, (float)-0.1745f));
        PartDefinition Head_r4 = Head.m_171599_("Head_r4", CubeListBuilder.m_171558_().m_171514_(126, 139).m_171488_(-12.0f, -55.5f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)53.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition Head_r5 = Head.m_171599_("Head_r5", CubeListBuilder.m_171558_().m_171514_(110, 15).m_171488_(11.0f, -55.5f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)53.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition Head_r6 = Head.m_171599_("Head_r6", CubeListBuilder.m_171558_().m_171514_(100, 15).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)-3.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw = Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(62, 77).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-1.0f));
        PartDefinition Eyes = Head.m_171599_("Eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-3.0f));
        PartDefinition LeftEye = Eyes.m_171599_("LeftEye", CubeListBuilder.m_171558_().m_171514_(36, 75).m_171488_(-1.0f, -1.0f, -0.01f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)0.5f, (float)0.0f));
        PartDefinition RightEye = Eyes.m_171599_("RightEye", CubeListBuilder.m_171558_().m_171514_(36, 76).m_171488_(-1.0f, -1.0f, -0.01f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)0.5f, (float)0.0f));
        PartDefinition LeftEyeBrow = Head.m_171599_("LeftEyeBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-4.0f, (float)-3.0f));
        PartDefinition cube_r1 = LeftEyeBrow.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(72, 77).m_171488_(-2.5f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightEyeBrow = Head.m_171599_("RightEyeBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-4.0f, (float)-3.0f));
        PartDefinition cube_r2 = RightEyeBrow.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(72, 78).m_171488_(0.5f, -0.5f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftShoulder = Body.m_171599_("LeftShoulder", CubeListBuilder.m_171558_().m_171514_(122, 92).m_171488_(0.0f, -2.0f, -3.0f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(90, 32).m_171488_(1.0f, -5.0f, -2.0f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(118, 112).m_171488_(1.5f, -6.5f, 1.5f, 10.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(114, 81).m_171488_(10.5f, -0.5f, 4.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-5.5f, (float)0.0f));
        PartDefinition Armor5 = LeftShoulder.m_171599_("Armor5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-7.0f, (float)0.0f));
        PartDefinition LeftArm_r1 = Armor5.m_171599_("LeftArm_r1", CubeListBuilder.m_171558_().m_171514_(54, 19).m_171488_(-1.0f, -4.5f, -2.5f, 12.0f, 6.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition LeftArm_r2 = Armor5.m_171599_("LeftArm_r2", CubeListBuilder.m_171558_().m_171514_(86, 98).m_171488_(-3.0f, -9.0f, -4.0f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.5f, (float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition LeftArm = LeftShoulder.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(94, 97).m_171488_(-2.0f, -1.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 126).m_171488_(-2.0f, 7.0f, -2.5f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)0.5f));
        PartDefinition LeftArm_r3 = LeftArm.m_171599_("LeftArm_r3", CubeListBuilder.m_171558_().m_171514_(46, 132).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)9.0f, (float)-4.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition LowerLeftArm = LeftArm.m_171599_("LowerLeftArm", CubeListBuilder.m_171558_().m_171514_(60, 98).m_171488_(-3.0f, 2.0f, -3.5f, 7.0f, 11.0f, 6.0f, new CubeDeformation(-0.01f)).m_171514_(152, 123).m_171488_(2.0f, 13.0f, -3.5f, 1.0f, 2.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)1.5f, (float)9.0f, (float)0.5f));
        PartDefinition Armor6 = LowerLeftArm.m_171599_("Armor6", CubeListBuilder.m_171558_().m_171514_(116, 76).m_171488_(5.0f, -8.0f, -0.5f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(60, 115).m_171488_(-4.0f, -7.5f, -4.0f, 6.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(24, 132).m_171488_(-3.0f, 0.0f, -4.0f, 4.0f, 5.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-1.0f, (float)8.0f, (float)0.0f));
        PartDefinition LowerLeftArm_r1 = Armor6.m_171599_("LowerLeftArm_r1", CubeListBuilder.m_171558_().m_171514_(122, 76).m_171488_(9.0f, -52.0f, -2.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-10.0f, (float)48.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition LeftHand = LowerLeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_().m_171514_(154, 153).m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)13.0f, (float)-0.5f));
        PartDefinition LeftFingers = LeftHand.m_171599_("LeftFingers", CubeListBuilder.m_171558_().m_171514_(148, 99).m_171488_(-3.5f, -0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)3.5f, (float)0.0f));
        PartDefinition LeftFingers2 = LeftFingers.m_171599_("LeftFingers2", CubeListBuilder.m_171558_().m_171514_(66, 61).m_171488_(-1.0f, -2.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)-2.5f, (float)0.5f, (float)0.0f));
        PartDefinition LeftThumb = LeftHand.m_171599_("LeftThumb", CubeListBuilder.m_171558_().m_171514_(106, 76).m_171488_(-2.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)-2.0f));
        PartDefinition RightShoulder = Body.m_171599_("RightShoulder", CubeListBuilder.m_171558_().m_171514_(122, 102).m_171488_(-7.0f, -2.0f, -3.0f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(30, 94).m_171488_(-11.0f, -5.0f, -2.0f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(120, 31).m_171488_(-11.5f, -6.5f, 1.5f, 10.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(114, 81).m_171480_().m_171488_(-13.5f, -0.5f, 4.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-5.5f, (float)0.0f));
        PartDefinition Armor4 = RightShoulder.m_171599_("Armor4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-7.0f, (float)0.0f));
        PartDefinition RightArm_r1 = Armor4.m_171599_("RightArm_r1", CubeListBuilder.m_171558_().m_171514_(158, 66).m_171488_(0.0f, -9.0f, -4.0f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.5f, (float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition RightArm_r2 = Armor4.m_171599_("RightArm_r2", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171488_(-11.0f, -4.5f, -2.5f, 12.0f, 6.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        PartDefinition RightArm = RightShoulder.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(100, 0).m_171488_(-5.0f, -1.0f, -3.5f, 7.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 136).m_171488_(-5.0f, 7.0f, -2.5f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.5f));
        PartDefinition RightArm_r3 = RightArm.m_171599_("RightArm_r3", CubeListBuilder.m_171558_().m_171514_(70, 157).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-9.0f, (float)-4.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition LowerRightArm = RightArm.m_171599_("LowerRightArm", CubeListBuilder.m_171558_().m_171514_(106, 59).m_171488_(-4.0f, 2.0f, -3.5f, 7.0f, 11.0f, 6.0f, new CubeDeformation(-0.01f)).m_171514_(152, 123).m_171480_().m_171488_(-3.0f, 13.0f, -3.5f, 1.0f, 2.0f, 6.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)9.0f, (float)0.5f));
        PartDefinition Armor7 = LowerRightArm.m_171599_("Armor7", CubeListBuilder.m_171558_().m_171514_(122, 44).m_171488_(-2.0f, -7.5f, -4.0f, 6.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(80, 138).m_171488_(-1.0f, 0.0f, -4.0f, 4.0f, 5.0f, 7.0f, new CubeDeformation(-0.01f)).m_171514_(80, 130).m_171488_(-8.0f, -8.0f, -0.5f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)0.0f));
        PartDefinition LowerRightArm_r1 = Armor7.m_171599_("LowerRightArm_r1", CubeListBuilder.m_171558_().m_171514_(86, 122).m_171488_(-14.0f, -52.0f, -2.0f, 5.0f, 9.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)10.0f, (float)48.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition RightHand = LowerRightArm.m_171599_("RightHand", CubeListBuilder.m_171558_().m_171514_(0, 156).m_171488_(-1.0f, 0.5f, -2.5f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)12.5f, (float)-0.5f));
        PartDefinition RightFingers = RightHand.m_171599_("RightFingers", CubeListBuilder.m_171558_().m_171514_(102, 149).m_171488_(-0.5f, -0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)4.0f, (float)0.0f));
        PartDefinition RightFingers2 = RightFingers.m_171599_("RightFingers2", CubeListBuilder.m_171558_().m_171514_(-3, -3).m_171488_(-1.0f, -2.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)2.5f, (float)0.5f, (float)0.0f));
        PartDefinition RightThumb = RightHand.m_171599_("RightThumb", CubeListBuilder.m_171558_().m_171514_(80, 158).m_171488_(0.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)1.5f, (float)-2.0f));
        PartDefinition Hammer = LowerRightArm.m_171599_("Hammer", CubeListBuilder.m_171558_().m_171514_(166, 109).m_171488_(-0.5f, 3.0f, -1.5f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(52, 163).m_171488_(-6.5f, 9.0f, -2.5f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(27, 169).m_171488_(1.5f, 9.0f, -3.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(59, 166).m_171488_(-4.5f, 9.0f, -3.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(44, 161).m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(19, 117).m_171488_(-1.0f, 7.0f, -2.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition BodyArmor = Body.m_171599_("BodyArmor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition Armor_r1 = BodyArmor.m_171599_("Armor_r1", CubeListBuilder.m_171558_().m_171514_(61, 13).m_171488_(-7.5f, 6.5f, -11.0f, 15.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(2, 2).m_171488_(-9.5f, -0.5f, -11.5f, 19.0f, 7.0f, 9.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-10.5f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition BackArmor = BodyArmor.m_171599_("BackArmor", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-9.5f, -4.5f, -0.5f, 19.0f, 9.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)4.0f));
        PartDefinition BackWheel = BackArmor.m_171599_("BackWheel", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 165).m_171488_(-5.5f, -4.0f, 0.0f, 11.0f, 4.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition MiniTurret = BodyArmor.m_171599_("MiniTurret", CubeListBuilder.m_171558_().m_171514_(154, 146).m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(86, 107).m_171488_(-0.5f, -1.5f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-10.0f, (float)3.0f));
        PartDefinition LowerBody = Breakdown.m_171599_("LowerBody", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-7.0f, 2.0f, -3.5f, 14.0f, 3.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)1.5f));
        PartDefinition Armor8 = LowerBody.m_171599_("Armor8", CubeListBuilder.m_171558_().m_171514_(42, 61).m_171488_(-3.5f, -3.0f, -2.5f, 7.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)-2.5f));
        PartDefinition HipArmorRight = LowerBody.m_171599_("HipArmorRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)3.5f, (float)-2.5f));
        PartDefinition LowerBody_r1 = HipArmorRight.m_171599_("LowerBody_r1", CubeListBuilder.m_171558_().m_171514_(110, 125).m_171488_(-19.5f, -34.0f, -2.5f, 1.0f, 4.0f, 10.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)4.0f, (float)36.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition LowerBody_r2 = HipArmorRight.m_171599_("LowerBody_r2", CubeListBuilder.m_171558_().m_171514_(0, 113).m_171488_(-4.5f, -37.0f, -2.0f, 5.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)33.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition HipArmorLeft = LowerBody.m_171599_("HipArmorLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)3.5f, (float)-2.5f));
        PartDefinition LowerBody_r3 = HipArmorLeft.m_171599_("LowerBody_r3", CubeListBuilder.m_171558_().m_171514_(124, 15).m_171488_(18.5f, -34.0f, -2.5f, 1.0f, 4.0f, 10.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-4.0f, (float)36.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition LowerBody_r4 = HipArmorLeft.m_171599_("LowerBody_r4", CubeListBuilder.m_171558_().m_171514_(28, 119).m_171488_(-0.5f, -37.0f, -2.0f, 5.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)33.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition LeftLeg = LowerBody.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(94, 81).m_171488_(-3.0f, -0.5f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(146, 22).m_171488_(-2.5f, 7.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)4.5f, (float)0.0f));
        PartDefinition LowerLeftLeg = LeftLeg.m_171599_("LowerLeftLeg", CubeListBuilder.m_171558_().m_171514_(56, 130).m_171488_(-3.0f, 2.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(148, 31).m_171488_(-3.0f, 15.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(30, 62).m_171488_(-1.5f, 3.0f, -5.0f, 3.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition Armor4_r1 = LowerLeftLeg.m_171599_("Armor4_r1", CubeListBuilder.m_171558_().m_171514_(146, 75).m_171488_(-5.0f, -14.5f, 0.0f, 5.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)15.5f, (float)-5.0f, (float)0.0f, (float)0.6981f, (float)0.0f));
        PartDefinition Armor3_r1 = LowerLeftLeg.m_171599_("Armor3_r1", CubeListBuilder.m_171558_().m_171514_(66, 140).m_171488_(0.0f, -14.5f, 0.0f, 5.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)15.5f, (float)-5.0f, (float)0.0f, (float)-0.6981f, (float)0.0f));
        PartDefinition Armor2 = LowerLeftLeg.m_171599_("Armor2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition Armor4_r2 = Armor2.m_171599_("Armor4_r2", CubeListBuilder.m_171558_().m_171514_(132, 133).m_171488_(7.5f, -15.0f, 5.0f, 2.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(128, 0).m_171488_(0.5f, -15.0f, 5.0f, 2.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)22.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Armor3_r2 = Armor2.m_171599_("Armor3_r2", CubeListBuilder.m_171558_().m_171514_(30, 77).m_171488_(-8.0f, -4.5f, 4.0f, 7.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)4.0f, (float)-5.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftKneePad = Armor2.m_171599_("LeftKneePad", CubeListBuilder.m_171558_().m_171514_(156, 59).m_171488_(-2.0f, -4.5f, -2.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = LeftKneePad.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(60, 157).m_171488_(-2.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r4 = LeftKneePad.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(14, 156).m_171488_(0.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition cube_r5 = LeftKneePad.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(80, 150).m_171488_(-5.0f, -5.0f, -1.0f, 5.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition LeftWheel = Armor2.m_171599_("LeftWheel", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-2.5f, -5.0f, -5.0f, 5.0f, 10.0f, 10.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)2.0f));
        PartDefinition LeftFeet = LowerLeftLeg.m_171599_("LeftFeet", CubeListBuilder.m_171558_().m_171514_(132, 59).m_171488_(-4.0f, -2.0f, 3.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(54, 32).m_171488_(-4.0f, -1.5f, 1.0f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(90, 47).m_171488_(-3.5f, 1.0f, -9.0f, 7.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition cube_r6 = LeftFeet.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(148, 47).m_171488_(-4.0f, 0.0f, 6.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-10.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = LeftFeet.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(132, 125).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-9.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = LowerBody.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(0, 97).m_171488_(-3.0f, -0.5f, -4.0f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(146, 112).m_171488_(-2.5f, 7.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)4.5f, (float)0.0f));
        PartDefinition LowerRightLeg = RightLeg.m_171599_("LowerRightLeg", CubeListBuilder.m_171558_().m_171514_(102, 139).m_171488_(-3.0f, 2.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(148, 39).m_171488_(-3.0f, 15.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 62).m_171488_(-1.5f, 3.0f, -5.0f, 3.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition Armor4_r3 = LowerRightLeg.m_171599_("Armor4_r3", CubeListBuilder.m_171558_().m_171514_(126, 147).m_171488_(-5.0f, -14.5f, 0.0f, 5.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)15.5f, (float)-5.0f, (float)0.0f, (float)0.6981f, (float)0.0f));
        PartDefinition Armor5_r1 = LowerRightLeg.m_171599_("Armor5_r1", CubeListBuilder.m_171558_().m_171514_(140, 147).m_171488_(0.0f, -14.5f, 0.0f, 5.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)15.5f, (float)-5.0f, (float)0.0f, (float)-0.6981f, (float)0.0f));
        PartDefinition Armor3 = LowerRightLeg.m_171599_("Armor3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition Armor5_r2 = Armor3.m_171599_("Armor5_r2", CubeListBuilder.m_171558_().m_171514_(24, 144).m_171488_(-9.5f, -15.0f, 5.0f, 2.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(46, 140).m_171488_(-2.5f, -15.0f, 5.0f, 2.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)22.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Armor4_r4 = Armor3.m_171599_("Armor4_r4", CubeListBuilder.m_171558_().m_171514_(62, 81).m_171488_(1.0f, -4.5f, 4.0f, 7.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)4.0f, (float)-5.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightKneePad = Armor3.m_171599_("RightKneePad", CubeListBuilder.m_171558_().m_171514_(96, 156).m_171488_(-2.0f, -4.5f, -2.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)-3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = RightKneePad.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(34, 158).m_171488_(0.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition cube_r9 = RightKneePad.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(24, 158).m_171488_(-2.0f, -4.0f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r10 = RightKneePad.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(152, 133).m_171488_(0.0f, -5.0f, -1.0f, 5.0f, 5.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition RightWheel = Armor3.m_171599_("RightWheel", CubeListBuilder.m_171558_().m_171514_(76, 61).m_171488_(-2.5f, -5.0f, -5.0f, 5.0f, 10.0f, 10.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)2.0f));
        PartDefinition RightFeet = LowerRightLeg.m_171599_("RightFeet", CubeListBuilder.m_171558_().m_171514_(0, 146).m_171488_(-4.0f, -2.0f, 3.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(148, 106).m_171488_(-4.0f, -1.5f, 1.0f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(92, 19).m_171488_(-3.5f, 1.0f, -9.0f, 7.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition cube_r11 = RightFeet.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(148, 53).m_171488_(-4.0f, 0.0f, 6.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-10.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = RightFeet.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(146, 14).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-9.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)500, (int)500);
    }

    @Override
    public void positionGun(T entity, float ageInTicks, float netHeadYaw, float headPitch, float gunLoading) {
        if (gunLoading > 0.0f) {
            this.turret.m_252899_(new Vector3f(headPitch * (float)Math.PI / 180.0f - this.turret.f_104203_, netHeadYaw * (float)Math.PI / 180.0f - this.turret.f_104204_, -this.turret.f_104205_).mul(gunLoading));
        }
        super.positionGun(entity, ageInTicks, netHeadYaw, headPitch, gunLoading);
    }

    @Override
    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.translateToHand(arm, poseStack, -2.0f, 6.0f, -1.0f);
    }

    @Override
    public void setupHandAnim(T entity, float ageInTicks, HumanoidArm arm) {
        super.setupHandAnim(entity, ageInTicks, arm);
        this.getArm(arm).m_252854_(new Vector3f(arm == HumanoidArm.RIGHT ? 10.0f : -10.0f, -3.0f, -4.0f));
    }

    @Override
    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftShoulder : this.rightShoulder;
    }

    @Override
    public List<ModelPart> getHandDirectory(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return List.of(this.breakdown, this.upperBody, this.body, this.leftShoulder, this.leftArm, this.lowerLeftArm, this.leftHand);
        }
        return List.of(this.breakdown, this.upperBody, this.body, this.rightShoulder, this.rightArm, this.lowerRightArm, this.rightHand);
    }

    @Override
    public ModelPart getRightLeg() {
        return this.rightLeg;
    }

    @Override
    public ModelPart getLeftLeg() {
        return this.leftLeg;
    }

    @Override
    protected void animateWalk(T entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(this.animations.walkingAnimation(), limbSwing, limbSwingAmount, 1.8f, 1.0f);
    }

    @Override
    protected void animateRunning(T entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(BreakdownAnimation.RUNNING, limbSwing, limbSwingAmount, 1.0f, 1.0f);
    }
}

