/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.BumblebeeAnimation;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.entity.TransformerAnimatable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BumblebeeModel<T extends LivingEntity, A extends TransformerAnimatable>
extends AbstractTransformerBotModel<T, A> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "bumblebee"), "main");
    private final ModelPart bumblebee;
    private final ModelPart upperBody;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightShoulder;
    private final ModelPart rightArm;
    private final ModelPart lowerRightArm;
    private final ModelPart rightHand;
    private final ModelPart leftShoulder;
    private final ModelPart leftArm;
    private final ModelPart lowerLeftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public BumblebeeModel(ModelPart root) {
        super(root, BumblebeeAnimation.ANIMATIONS);
        this.bumblebee = root.m_171324_("Bumblebee");
        this.upperBody = this.bumblebee.m_171324_("UpperBody");
        this.body = this.upperBody.m_171324_("Body");
        this.head = this.body.m_171324_("Head");
        this.rightShoulder = this.body.m_171324_("RightShoulder");
        this.rightArm = this.rightShoulder.m_171324_("RightArm");
        this.lowerRightArm = this.rightArm.m_171324_("LowerRightArm");
        this.rightHand = this.lowerRightArm.m_171324_("RightHand");
        this.leftShoulder = this.body.m_171324_("LeftShoulder");
        this.leftArm = this.leftShoulder.m_171324_("LeftArm");
        this.lowerLeftArm = this.leftArm.m_171324_("LowerLeftArm");
        this.leftHand = this.lowerLeftArm.m_171324_("LeftHand");
        ModelPart lowerBody = this.bumblebee.m_171324_("LowerBody");
        this.rightLeg = lowerBody.m_171324_("RightLeg");
        this.leftLeg = lowerBody.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Bumblebee = partdefinition.m_171599_("Bumblebee", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition UpperBody = Bumblebee.m_171599_("UpperBody", CubeListBuilder.m_171558_().m_171514_(37, 32).m_171488_(-3.5f, -6.0f, -4.5f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition Body_r1 = UpperBody.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(0.0f, 2.0f, 0.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition Body_r2 = UpperBody.m_171599_("Body_r2", CubeListBuilder.m_171558_().m_171514_(18, 58).m_171488_(-5.0f, 2.0f, 0.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)-7.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r1 = UpperBody.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(98, 35).m_171488_(-0.5f, 3.0f, -4.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition cube_r2 = UpperBody.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(99, 23).m_171488_(-1.5f, 3.0f, -4.0f, 2.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition Body = UpperBody.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(58, 34).m_171488_(-2.0f, -10.0f, -1.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.5f, -8.0f, -3.5f, 15.0f, 8.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(96, 53).m_171488_(-2.5f, -4.5f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(-0.001f)).m_171514_(44, 10).m_171488_(-2.5f, -5.0f, 1.0f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)).m_171514_(19, 117).m_171488_(2.0f, -4.5f, -2.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(75, 116).m_171488_(-3.0f, -4.5f, -2.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(106, 114).m_171488_(-1.0f, -7.0f, -3.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, -6.0f, -3.01f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.5f));
        PartDefinition Head_r1 = Head.m_171599_("Head_r1", CubeListBuilder.m_171558_().m_171514_(48, 26).m_171488_(-2.5f, 0.0f, -2.0f, 5.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)3.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Head_r2 = Head.m_171599_("Head_r2", CubeListBuilder.m_171558_().m_171514_(115, 12).m_171488_(0.0f, -1.5f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.5f, (float)-5.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition Head_r3 = Head.m_171599_("Head_r3", CubeListBuilder.m_171558_().m_171514_(116, 55).m_171488_(-2.0f, -1.5f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)2.5f, (float)-5.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition Mouth = Head.m_171599_("Mouth", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.5f, -0.5f, -1.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(3, 5).m_171488_(-1.0f, -1.5f, -0.51f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition RightEyebrow = Head.m_171599_("RightEyebrow", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.5f, (float)-4.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition RightEyebrow_r1 = RightEyebrow.m_171599_("RightEyebrow_r1", CubeListBuilder.m_171558_().m_171514_(18, 18).m_171488_(-0.5f, 0.0f, 0.1f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-0.5f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEyebrow = Head.m_171599_("LeftEyebrow", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.5f, (float)-4.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition LeftEyebrow_r1 = LeftEyebrow.m_171599_("LeftEyebrow_r1", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(-1.5f, 0.0f, 0.1f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.5f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEye = Head.m_171599_("LeftEye", CubeListBuilder.m_171558_().m_171514_(4, 1).m_171488_(-0.25f, -0.5f, -0.01f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-3.5f, (float)-2.5f));
        PartDefinition RightEye = Head.m_171599_("RightEye", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171488_(-0.75f, -0.5f, -0.01f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-3.5f, (float)-2.5f));
        PartDefinition LeftShoulder = Body.m_171599_("LeftShoulder", CubeListBuilder.m_171558_().m_171514_(0, 92).m_171488_(-0.5f, -4.0f, -1.5f, 7.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(77, 86).m_171488_(-1.0f, -4.5f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(109, 18).m_171488_(-1.0f, -1.5f, -2.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)8.0f, (float)-5.0f, (float)0.5f));
        PartDefinition cube_r3 = LeftShoulder.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(59, 10).m_171488_(-1.5f, -4.5f, -2.0f, 9.0f, 3.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)1.0f, (float)2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition LeftArm = LeftShoulder.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(95, 106).m_171488_(-2.0f, -1.5f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(114, 37).m_171488_(-1.5f, 5.5f, -2.5f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LowerLeftArm = LeftArm.m_171599_("LowerLeftArm", CubeListBuilder.m_171558_().m_171514_(22, 69).m_171488_(-2.5f, 1.0f, -3.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(60, 108).m_171488_(-2.0f, 8.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(65, 98).m_171488_(-1.0f, -3.0f, 2.5f, 2.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-0.5f));
        PartDefinition LowerLeftArm_r1 = LowerLeftArm.m_171599_("LowerLeftArm_r1", CubeListBuilder.m_171558_().m_171514_(20, 95).m_171488_(11.0f, -46.0f, 1.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-13.0f, (float)42.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition LowerLeftArm_r2 = LowerLeftArm.m_171599_("LowerLeftArm_r2", CubeListBuilder.m_171558_().m_171514_(51, 98).m_171488_(9.0f, -45.0f, 1.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.0f, (float)43.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition LowerLeftArm_r3 = LowerLeftArm.m_171599_("LowerLeftArm_r3", CubeListBuilder.m_171558_().m_171514_(86, 31).m_171488_(0.0f, -3.0f, -0.5f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)10.0f, (float)2.5f, (float)-0.3491f, (float)-0.2618f, (float)0.1745f));
        PartDefinition LeftArmBlaster = LowerLeftArm.m_171599_("LeftArmBlaster", CubeListBuilder.m_171558_().m_171514_(25, 120).m_171488_(-1.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(37, 122).m_171488_(-0.5f, 1.0f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)7.0f, (float)0.0f));
        PartDefinition LeftHand = LowerLeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_().m_171514_(63, 115).m_171488_(0.0f, 0.0f, -2.5f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)10.0f, (float)0.0f));
        PartDefinition LeftFingers = LeftHand.m_171599_("LeftFingers", CubeListBuilder.m_171558_().m_171514_(66, 44).m_171488_(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition LeftFingers2 = LeftFingers.m_171599_("LeftFingers2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -3.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftThumb = LeftHand.m_171599_("LeftThumb", CubeListBuilder.m_171558_().m_171514_(16, 61).m_171488_(-1.5f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-2.5f));
        PartDefinition RightShoulder = Body.m_171599_("RightShoulder", CubeListBuilder.m_171558_().m_171514_(0, 92).m_171480_().m_171488_(-6.5f, -4.0f, -1.5f, 7.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(77, 86).m_171480_().m_171488_(-7.0f, -4.5f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(109, 18).m_171480_().m_171488_(-4.0f, -1.5f, -2.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-5.0f, (float)0.5f));
        PartDefinition cube_r4 = RightShoulder.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(59, 10).m_171480_().m_171488_(-7.5f, -4.5f, -2.0f, 9.0f, 3.0f, 5.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition RightArm = RightShoulder.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(95, 106).m_171480_().m_171488_(-2.0f, -1.5f, -2.5f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(114, 37).m_171480_().m_171488_(-1.5f, 5.5f, -2.5f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LowerRightArm = RightArm.m_171599_("LowerRightArm", CubeListBuilder.m_171558_().m_171514_(22, 69).m_171480_().m_171488_(-2.5f, 1.0f, -3.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 108).m_171480_().m_171488_(-2.0f, 8.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(65, 98).m_171480_().m_171488_(-1.0f, -3.0f, 2.5f, 2.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-0.5f));
        PartDefinition LowerRightArm_r1 = LowerRightArm.m_171599_("LowerRightArm_r1", CubeListBuilder.m_171558_().m_171514_(20, 95).m_171480_().m_171488_(-13.0f, -46.0f, 1.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)13.0f, (float)42.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition LowerRightArm_r2 = LowerRightArm.m_171599_("LowerRightArm_r2", CubeListBuilder.m_171558_().m_171514_(51, 98).m_171480_().m_171488_(-11.0f, -45.0f, 1.0f, 2.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)9.0f, (float)43.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition LowerRightArm_r3 = LowerRightArm.m_171599_("LowerRightArm_r3", CubeListBuilder.m_171558_().m_171514_(86, 31).m_171480_().m_171488_(-2.0f, -3.0f, -0.5f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)10.0f, (float)2.5f, (float)-0.3491f, (float)0.2618f, (float)-0.1745f));
        PartDefinition RightArmBlaster = LowerRightArm.m_171599_("RightArmBlaster", CubeListBuilder.m_171558_().m_171514_(25, 120).m_171480_().m_171488_(-1.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(37, 122).m_171480_().m_171488_(-0.5f, 1.0f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)7.0f, (float)0.0f));
        PartDefinition RightHand = LowerRightArm.m_171599_("RightHand", CubeListBuilder.m_171558_().m_171514_(63, 115).m_171480_().m_171488_(-1.0f, 0.0f, -2.5f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)10.0f, (float)0.0f));
        PartDefinition RightFingers = RightHand.m_171599_("RightFingers", CubeListBuilder.m_171558_().m_171514_(66, 44).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition RightFingers2 = RightFingers.m_171599_("RightFingers2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171480_().m_171488_(-2.0f, -1.0f, -3.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightThumb = RightHand.m_171599_("RightThumb", CubeListBuilder.m_171558_().m_171514_(16, 61).m_171480_().m_171488_(-0.5f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-2.5f));
        PartDefinition Armor = Body.m_171599_("Armor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)1.0f));
        PartDefinition cube_r5 = Armor.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(112, 69).m_171488_(-6.5f, -8.5f, 5.0f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-2.0f, (float)0.0f, (float)-0.1745f, (float)-0.0873f));
        PartDefinition cube_r6 = Armor.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(111, 106).m_171488_(0.5f, -8.5f, 5.0f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-2.0f, (float)0.0f, (float)0.1745f, (float)0.0873f));
        PartDefinition Body_r3 = Armor.m_171599_("Body_r3", CubeListBuilder.m_171558_().m_171514_(110, 92).m_171488_(0.5f, -3.5f, 0.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)1.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Front = Armor.m_171599_("Front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition Left = Front.m_171599_("Left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)10.0f, (float)-5.0f, (float)-2.0f));
        PartDefinition Up = Left.m_171599_("Up", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)-3.5f, (float)0.0f));
        PartDefinition Body_r4 = Up.m_171599_("Body_r4", CubeListBuilder.m_171558_().m_171514_(98, 0).m_171488_(0.5f, -5.0f, 0.0f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)5.5f, (float)-2.5f, (float)0.0f, (float)-0.0873f, (float)-0.0873f));
        PartDefinition Down = Left.m_171599_("Down", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)5.25f, (float)0.0f));
        PartDefinition Body_r5 = Down.m_171599_("Body_r5", CubeListBuilder.m_171558_().m_171514_(103, 86).m_171488_(0.0f, -3.0f, -2.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-1.25f, (float)-0.5f, (float)-0.0038f, (float)-0.0872f, (float)0.0438f));
        PartDefinition Right = Front.m_171599_("Right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-10.0f, (float)-5.0f, (float)-2.0f));
        PartDefinition Up2 = Right.m_171599_("Up2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)-3.5f, (float)0.0f));
        PartDefinition Body_r6 = Up2.m_171599_("Body_r6", CubeListBuilder.m_171558_().m_171514_(99, 98).m_171488_(-8.5f, -5.0f, 0.0f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)5.5f, (float)-2.5f, (float)0.0f, (float)0.0873f, (float)0.0873f));
        PartDefinition Down2 = Right.m_171599_("Down2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)5.25f, (float)0.0f));
        PartDefinition Body_r7 = Down2.m_171599_("Body_r7", CubeListBuilder.m_171558_().m_171514_(101, 47).m_171488_(-8.0f, -3.0f, -2.0f, 8.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-1.25f, (float)-0.5f, (float)-0.0038f, (float)0.0872f, (float)-0.0438f));
        PartDefinition LeftDoor = Body.m_171599_("LeftDoor", CubeListBuilder.m_171558_().m_171514_(96, 65).m_171488_(0.0f, -2.0f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(116, 48).m_171488_(0.0f, -2.0f, 7.0f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(18, 15).m_171488_(0.0f, 0.0f, 7.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-5.0f, (float)5.0f, (float)0.4363f, (float)1.1345f, (float)-0.0873f));
        PartDefinition cube_r7 = LeftDoor.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(86, 111).m_171488_(0.0f, -2.0f, -6.0f, 1.0f, 2.0f, 6.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)12.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = LeftDoor.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-0.5f, -3.0f, 0.5f, 0.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-2.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightDoor = Body.m_171599_("RightDoor", CubeListBuilder.m_171558_().m_171514_(94, 86).m_171488_(-1.0f, -2.0f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(7, 116).m_171488_(-1.0f, -2.0f, 7.0f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 5).m_171488_(-1.0f, 0.0f, 7.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-5.0f, (float)5.0f, (float)0.4363f, (float)-1.1345f, (float)0.0873f));
        PartDefinition cube_r9 = RightDoor.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(109, 29).m_171488_(-1.0f, -2.0f, -6.0f, 1.0f, 2.0f, 6.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)12.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = RightDoor.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(0.5f, -3.0f, 0.5f, 0.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-2.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Plate = Body.m_171599_("Plate", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-3.0f));
        PartDefinition Body_r8 = Plate.m_171599_("Body_r8", CubeListBuilder.m_171558_().m_171514_(95, 9).m_171488_(-4.5f, -50.0f, 4.0f, 9.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)50.0f, (float)-3.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition LowerBody = Bumblebee.m_171599_("LowerBody", CubeListBuilder.m_171558_().m_171514_(36, 15).m_171488_(-4.0f, 0.0f, -4.5f, 8.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(20, 44).m_171488_(-1.5f, -1.5f, -4.51f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition LowerBody_r1 = LowerBody.m_171599_("LowerBody_r1", CubeListBuilder.m_171558_().m_171514_(0, 77).m_171488_(-4.5f, -1.5f, -5.0f, 4.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition LowerBody_r2 = LowerBody.m_171599_("LowerBody_r2", CubeListBuilder.m_171558_().m_171514_(79, 10).m_171488_(0.5f, -1.5f, -5.0f, 4.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition LeftLeg = LowerBody.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(38, 85).m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(60, 66).m_171488_(-2.5f, -0.5f, -3.5f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)4.0f, (float)-0.5f));
        PartDefinition LeftLeg_r1 = LeftLeg.m_171599_("LeftLeg_r1", CubeListBuilder.m_171558_().m_171514_(38, 69).m_171488_(1.5f, -19.5f, -2.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 77).m_171488_(-0.5f, -19.5f, -2.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)28.0f, (float)4.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg_r2 = LeftLeg.m_171599_("LeftLeg_r2", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171488_(2.5f, -19.0f, -1.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)28.0f, (float)-2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg_r3 = LeftLeg.m_171599_("LeftLeg_r3", CubeListBuilder.m_171558_().m_171514_(60, 59).m_171488_(2.5f, -19.0f, -1.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)28.0f, (float)-2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LowerLeftLeg = LeftLeg.m_171599_("LowerLeftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)12.0f, (float)-0.5f));
        PartDefinition LowerLeftLeg_r1 = LowerLeftLeg.m_171599_("LowerLeftLeg_r1", CubeListBuilder.m_171558_().m_171514_(20, 39).m_171488_(1.0f, -15.5f, 1.5f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)15.0f, (float)-2.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LowerLeftLeg_r2 = LowerLeftLeg.m_171599_("LowerLeftLeg_r2", CubeListBuilder.m_171558_().m_171514_(18, 23).m_171488_(1.5f, -15.5f, -0.5f, 5.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)16.0f, (float)-2.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Armor4 = LowerLeftLeg.m_171599_("Armor4", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-3.5f, 9.0f, -2.0f, 6.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-1.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = Armor4.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(65, 34).m_171488_(-3.5f, 12.0f, -10.5f, 6.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)7.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = Armor4.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(47, 45).m_171488_(-3.0f, 1.0f, -4.5f, 7.0f, 8.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-1.0f, (float)2.0f, (float)2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftKneePad = Armor4.m_171599_("LeftKneePad", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.5f, (float)3.0f, (float)-2.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = LeftKneePad.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(51, 113).m_171488_(-1.5f, -7.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition LeftFeet = LowerLeftLeg.m_171599_("LeftFeet", CubeListBuilder.m_171558_().m_171514_(84, 29).m_171488_(-2.5f, -1.0f, -2.5f, 4.0f, 6.0f, 6.0f, new CubeDeformation(-0.01f)).m_171514_(33, 110).m_171488_(-3.5f, 1.0f, 1.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(81, 21).m_171488_(-3.5f, 3.0f, -11.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 102).m_171488_(-3.5f, -1.0f, -5.0f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        PartDefinition cube_r14 = LeftFeet.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(77, 75).m_171488_(-6.0f, -0.5f, -1.0f, 7.0f, 6.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)2.0f, (float)0.0f, (float)-7.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = LeftFeet.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(66, 61).m_171488_(-2.0f, -0.5f, -0.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-7.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = LeftFeet.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(37, 76).m_171488_(-3.5f, 0.0f, 0.0f, 6.0f, 2.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-11.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = LowerBody.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(38, 85).m_171480_().m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(60, 66).m_171480_().m_171488_(-2.5f, -0.5f, -3.5f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)4.0f, (float)-0.5f));
        PartDefinition RightLeg_r1 = RightLeg.m_171599_("RightLeg_r1", CubeListBuilder.m_171558_().m_171514_(38, 69).m_171480_().m_171488_(-2.5f, -19.5f, -2.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 77).m_171480_().m_171488_(-0.5f, -19.5f, -2.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)28.0f, (float)4.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg_r2 = RightLeg.m_171599_("RightLeg_r2", CubeListBuilder.m_171558_().m_171514_(58, 10).m_171480_().m_171488_(-3.5f, -19.0f, -1.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)28.0f, (float)-2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg_r3 = RightLeg.m_171599_("RightLeg_r3", CubeListBuilder.m_171558_().m_171514_(60, 59).m_171480_().m_171488_(-3.5f, -19.0f, -1.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.0f, (float)28.0f, (float)-2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LowerRightLeg = RightLeg.m_171599_("LowerRightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)12.0f, (float)-0.5f));
        PartDefinition LowerRightLeg_r1 = LowerRightLeg.m_171599_("LowerRightLeg_r1", CubeListBuilder.m_171558_().m_171514_(20, 39).m_171480_().m_171488_(-5.0f, -15.5f, 1.5f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)15.0f, (float)-2.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LowerRightLeg_r2 = LowerRightLeg.m_171599_("LowerRightLeg_r2", CubeListBuilder.m_171558_().m_171514_(18, 23).m_171480_().m_171488_(-6.5f, -15.5f, -0.5f, 5.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.5f, (float)16.0f, (float)-2.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Armor2 = LowerRightLeg.m_171599_("Armor2", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171480_().m_171488_(-2.5f, 9.0f, -2.0f, 6.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-1.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = Armor2.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(65, 34).m_171480_().m_171488_(-2.5f, 12.0f, -10.5f, 6.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)7.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r18 = Armor2.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(47, 45).m_171480_().m_171488_(-4.0f, 1.0f, -4.5f, 7.0f, 8.0f, 5.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)2.0f, (float)2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightKneePad = Armor2.m_171599_("RightKneePad", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.5f, (float)3.0f, (float)-2.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = RightKneePad.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(51, 113).m_171480_().m_171488_(-1.5f, -7.0f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition RightFeet = LowerRightLeg.m_171599_("RightFeet", CubeListBuilder.m_171558_().m_171514_(84, 29).m_171480_().m_171488_(-1.5f, -1.0f, -2.5f, 4.0f, 6.0f, 6.0f, new CubeDeformation(-0.01f)).m_171555_(false).m_171514_(33, 110).m_171480_().m_171488_(-2.5f, 1.0f, 1.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(81, 21).m_171480_().m_171488_(-2.5f, 3.0f, -11.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 102).m_171480_().m_171488_(-2.5f, -1.0f, -5.0f, 6.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        PartDefinition cube_r20 = RightFeet.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(77, 75).m_171480_().m_171488_(-1.0f, -0.5f, -1.0f, 7.0f, 6.0f, 5.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)-7.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r21 = RightFeet.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(66, 61).m_171480_().m_171488_(-1.0f, -0.5f, -0.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-7.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = RightFeet.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(37, 76).m_171480_().m_171488_(-2.5f, 0.0f, 0.0f, 6.0f, 2.0f, 7.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-11.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)500, (int)500);
    }

    @Override
    public void setupHandAnim(T entity, float ageInTicks, HumanoidArm arm) {
        super.setupHandAnim(entity, ageInTicks, arm);
        this.getArm((HumanoidArm)arm).f_104200_ = this.getArm((HumanoidArm)arm).f_104200_ + (arm == HumanoidArm.RIGHT ? 6.0f : -6.0f);
    }

    @Override
    public void positionGunFirstPerson(ModelPart armModel, int handSign, float gunLoadProcess) {
        armModel.m_252854_(new Vector3f((float)(handSign * 10), 5.0f, 8.0f).mul(-gunLoadProcess));
        armModel.m_252899_(new Vector3f(0.0f, -36.0f, -30.0f).mul((float)handSign * gunLoadProcess * (float)Math.PI / 180.0f));
    }

    @Override
    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.translateToHand(arm, poseStack, -2.0f, 6.0f, -1.0f);
    }

    @Override
    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftShoulder : this.rightShoulder;
    }

    @Override
    public List<ModelPart> getHandDirectory(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return List.of(this.bumblebee, this.upperBody, this.body, this.leftShoulder, this.leftArm, this.lowerLeftArm, this.leftHand);
        }
        return List.of(this.bumblebee, this.upperBody, this.body, this.rightShoulder, this.rightArm, this.lowerRightArm, this.rightHand);
    }

    @Override
    public ModelPart getRightLeg() {
        return this.rightLeg;
    }

    @Override
    public ModelPart getLeftLeg() {
        return this.leftLeg;
    }

    @Override
    protected void animateRunning(T entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(BumblebeeAnimation.RUNNING_NO_BLASTERS, limbSwing, limbSwingAmount, 0.8f, 0.8f);
    }
}

