/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.NemesisPrimeAnimation;
import bnb.tfp.client.animation.OptimusPrimeAnimation;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.entity.TransformerAnimatable;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NemesisPrimeModel<T extends LivingEntity, A extends TransformerAnimatable>
extends AbstractTransformerBotModel<T, A> {
    private final ModelPart optimusPrime;
    private final ModelPart upperBody;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart lowerRightArm;
    private final ModelPart rightHand;
    private final ModelPart leftArm;
    private final ModelPart lowerLeftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final AnimationState laptopMaskAnimState;

    public NemesisPrimeModel(ModelPart root) {
        super(root, NemesisPrimeAnimation.ANIMATIONS);
        this.optimusPrime = root.m_171324_("OptimusPrime");
        this.upperBody = this.optimusPrime.m_171324_("UpperBody");
        this.body = this.upperBody.m_171324_("Body");
        this.head = this.body.m_171324_("Head");
        this.rightArm = this.body.m_171324_("RightArm");
        this.lowerRightArm = this.rightArm.m_171324_("LowerRightArm");
        this.rightHand = this.lowerRightArm.m_171324_("RightHand");
        this.leftArm = this.body.m_171324_("LeftArm");
        this.lowerLeftArm = this.leftArm.m_171324_("LowerLeftArm");
        this.leftHand = this.lowerLeftArm.m_171324_("LeftHand");
        ModelPart lowerBody = this.optimusPrime.m_171324_("LowerBody");
        this.rightLeg = lowerBody.m_171324_("RightLeg");
        this.leftLeg = lowerBody.m_171324_("LeftLeg");
        this.laptopMaskAnimState = new AnimationState();
        this.laptopMaskAnimState.m_216977_(Integer.MIN_VALUE);
    }

    @Override
    public void animateHeadOnLaptop(PlayableTransformer transformer) {
        super.animateHeadOnLaptop(transformer);
        this.m_233381_(this.laptopMaskAnimState, NemesisPrimeAnimation.SETTLE, 2.1474836E9f);
    }

    @Override
    public void setupHandAnim(T entity, float ageInTicks, HumanoidArm arm) {
        super.setupHandAnim(entity, ageInTicks, arm);
        ModelPart armModel = this.getArm(arm);
        armModel.m_253072_(new Vector3f(-0.2f, -0.2f, -0.2f));
        armModel.f_104200_ = armModel.f_104200_ + (arm == HumanoidArm.RIGHT ? 8.0f : -8.0f);
        armModel.f_104201_ += 4.0f;
    }

    @Override
    public void positionGunFirstPerson(ModelPart armModel, int handSign, float gunLoadProcess) {
        armModel.m_252854_(new Vector3f((float)(handSign * 10), 10.0f, 8.0f).mul(-gunLoadProcess));
        armModel.m_252899_(new Vector3f(0.0f, 24.0f, 30.0f).mul((float)(-handSign) * gunLoadProcess * (float)Math.PI / 180.0f));
    }

    @Override
    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.translateToHand(arm, poseStack, -1.0f, 6.0f, 0.0f);
    }

    @Override
    public ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @Override
    public List<ModelPart> getHandDirectory(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return List.of(this.optimusPrime, this.upperBody, this.body, this.leftArm, this.lowerLeftArm, this.leftHand);
        }
        return List.of(this.optimusPrime, this.upperBody, this.body, this.rightArm, this.lowerRightArm, this.rightHand);
    }

    @Override
    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public ModelPart getRightLeg() {
        return this.rightLeg;
    }

    @Override
    public ModelPart getLeftLeg() {
        return this.leftLeg;
    }

    @Override
    protected void animateRunning(T entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(OptimusPrimeAnimation.RUNNING, limbSwing, limbSwingAmount, 1.5f, 1.0f);
    }
}

