/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.RatchetAnimation;
import bnb.tfp.client.model.transformer.bot.AbstractHealingTransformerModel;
import bnb.tfp.transformer.HealingPlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RatchetModel<T extends HealingPlayableTransformer>
extends AbstractHealingTransformerModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "ratchet"), "main");
    private final ModelPart ratchet;
    private final ModelPart upperBody;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart lowerRightArm;
    private final ModelPart rightHand;
    private final ModelPart leftArm;
    private final ModelPart lowerLeftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public RatchetModel(ModelPart root) {
        super(root, RatchetAnimation.ANIMATIONS);
        this.ratchet = root.m_171324_("Ratchet");
        this.upperBody = this.ratchet.m_171324_("UpperBody");
        this.body = this.upperBody.m_171324_("Body");
        this.head = this.body.m_171324_("Head");
        this.rightArm = this.body.m_171324_("RightArm");
        this.lowerRightArm = this.rightArm.m_171324_("LowerRightArm");
        this.rightHand = this.lowerRightArm.m_171324_("RightHand");
        this.leftArm = this.body.m_171324_("LeftArm");
        this.lowerLeftArm = this.leftArm.m_171324_("LowerLeftArm");
        this.leftHand = this.lowerLeftArm.m_171324_("LeftHand");
        ModelPart lowerBody = this.ratchet.m_171324_("LowerBody");
        this.rightLeg = lowerBody.m_171324_("RightLeg");
        this.leftLeg = lowerBody.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Ratchet = partdefinition.m_171599_("Ratchet", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)2.0f));
        PartDefinition UpperBody = Ratchet.m_171599_("UpperBody", CubeListBuilder.m_171558_().m_171514_(25, 62).m_171488_(-4.5f, -5.5f, -3.0f, 9.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition HipLeft = UpperBody.m_171599_("HipLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.079f, (float)-2.343f, (float)0.5f));
        PartDefinition UpperBody_r1 = HipLeft.m_171599_("UpperBody_r1", CubeListBuilder.m_171558_().m_171514_(53, 115).m_171488_(-7.0f, -49.0f, -1.5f, 2.0f, 6.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)-2.079f, (float)46.343f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition HipRight = UpperBody.m_171599_("HipRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.079f, (float)-2.343f, (float)0.5f));
        PartDefinition UpperBody_r2 = HipRight.m_171599_("UpperBody_r2", CubeListBuilder.m_171558_().m_171514_(86, 115).m_171488_(5.0f, -49.0f, -1.5f, 2.0f, 6.0f, 6.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)2.079f, (float)46.343f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition Body = UpperBody.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(31, 119).m_171488_(-2.5f, -9.0f, -1.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.5f, -7.5f, -3.0f, 15.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition Body_r1 = Body.m_171599_("Body_r1", CubeListBuilder.m_171558_().m_171514_(69, 121).m_171488_(-12.0f, -52.5f, 0.5f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)46.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition Body_r2 = Body.m_171599_("Body_r2", CubeListBuilder.m_171558_().m_171514_(12, 123).m_171488_(9.0f, -52.5f, 0.5f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)46.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.01f)).m_171514_(115, 92).m_171488_(-3.0f, -4.0f, -0.5f, 6.0f, 4.0f, 4.0f, new CubeDeformation(-0.01f)).m_171514_(16, 47).m_171488_(-2.5f, -4.5f, -2.0f, 5.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)).m_171514_(99, 113).m_171488_(-3.0f, -6.0f, -2.5f, 6.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(37, 0).m_171488_(-0.5f, -6.0f, -2.5f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)).m_171514_(68, 28).m_171488_(-3.0f, -3.5f, 2.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(30, 30).m_171488_(-1.5f, -2.0f, -1.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-0.5f));
        PartDefinition Head_r1 = Head.m_171599_("Head_r1", CubeListBuilder.m_171558_().m_171514_(0, 106).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)2.5f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition Head_r2 = Head.m_171599_("Head_r2", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-4.0f, (float)0.5f, (float)0.0f, (float)-0.3054f, (float)-0.0873f));
        PartDefinition Head_r3 = Head.m_171599_("Head_r3", CubeListBuilder.m_171558_().m_171514_(72, 49).m_171488_(-0.5f, 0.0f, -3.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)0.5f, (float)0.0f, (float)0.3054f, (float)0.0873f));
        PartDefinition Head_r4 = Head.m_171599_("Head_r4", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-3.0f, (float)0.0f, (float)0.4363f, (float)-0.1745f, (float)0.0f));
        PartDefinition Head_r5 = Head.m_171599_("Head_r5", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-3.0f, (float)0.0f, (float)0.4363f, (float)0.1745f, (float)0.0f));
        PartDefinition Jaw = Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(87, 14).m_171488_(-1.5f, -0.5f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Eyes = Head.m_171599_("Eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-2.0f));
        PartDefinition LeftEye = Eyes.m_171599_("LeftEye", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.25f, (float)0.0f, (float)0.0f));
        PartDefinition RightEye = Eyes.m_171599_("RightEye", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.25f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEyeBrow = Head.m_171599_("LeftEyeBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-4.0f, (float)-2.0f));
        PartDefinition cube_r1 = LeftEyeBrow.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(30, 29).m_171488_(-2.5f, -1.0f, -0.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(43, 0).m_171488_(-2.5f, -2.5f, -0.51f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition RightEyeBrow = Head.m_171599_("RightEyeBrow", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-4.0f, (float)-2.0f));
        PartDefinition cube_r2 = RightEyeBrow.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(30, 28).m_171488_(-0.5f, -1.0f, -0.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(35, 20).m_171488_(-1.5f, -2.5f, -0.51f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(96, 69).m_171488_(0.0f, -2.0f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(118, 37).m_171488_(0.5f, 6.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-5.0f, (float)1.0f));
        PartDefinition Armor4 = LeftArm.m_171599_("Armor4", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-3.0f, -4.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(78, 107).m_171488_(4.9f, -3.0f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(76, 14).m_171488_(-3.0f, -1.0f, -5.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(60, 49).m_171488_(-3.0f, -1.0f, 4.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition LowerLeftArm = LeftArm.m_171599_("LowerLeftArm", CubeListBuilder.m_171558_().m_171514_(72, 76).m_171488_(-3.0f, 4.5f, -2.5f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(19, 103).m_171488_(-2.0f, 2.0f, -2.0f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)8.0f, (float)0.0f));
        PartDefinition Armor7 = LowerLeftArm.m_171599_("Armor7", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(3.5f, -5.0f, 5.5f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)-2.5f));
        PartDefinition LowerLeftArm_r1 = Armor7.m_171599_("LowerLeftArm_r1", CubeListBuilder.m_171558_().m_171514_(72, 61).m_171488_(-3.0f, -4.0f, 0.0f, 7.0f, 6.0f, 8.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArmWheel = LowerLeftArm.m_171599_("LeftArmWheel", CubeListBuilder.m_171558_().m_171514_(65, 89).m_171488_(-2.5f, -3.5f, -3.5f, 5.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)3.4f, (float)2.3974f));
        PartDefinition LeftHand = LowerLeftArm.m_171599_("LeftHand", CubeListBuilder.m_171558_().m_171514_(123, 108).m_171488_(-1.0f, 0.5f, -2.5f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)9.5f, (float)1.0f));
        PartDefinition LeftFingers = LeftHand.m_171599_("LeftFingers", CubeListBuilder.m_171558_().m_171514_(116, 19).m_171488_(-3.5f, -0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)4.0f, (float)0.0f));
        PartDefinition LeftThumb = LeftHand.m_171599_("LeftThumb", CubeListBuilder.m_171558_().m_171514_(68, 0).m_171488_(-2.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)2.5f, (float)-2.0f));
        PartDefinition LeftBlade = LowerLeftArm.m_171599_("LeftBlade", CubeListBuilder.m_171558_().m_171514_(126, 52).m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(132, 55).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(132, 55).m_171480_().m_171488_(-0.001f, 0.0f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)10.0f, (float)1.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(94, 14).m_171488_(-5.0f, -2.0f, -3.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 118).m_171488_(-4.5f, 6.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-5.0f, (float)1.0f));
        PartDefinition Armor3 = RightArm.m_171599_("Armor3", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-5.0f, -4.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(55, 17).m_171488_(-1.0f, -1.0f, -5.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(45, 17).m_171488_(-1.0f, -1.0f, 4.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(82, 82).m_171488_(-4.9f, -3.0f, -3.5f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition LowerRightArm = RightArm.m_171599_("LowerRightArm", CubeListBuilder.m_171558_().m_171514_(23, 76).m_171488_(-4.0f, 4.5f, -2.5f, 7.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(84, 101).m_171488_(-3.0f, 2.0f, -2.0f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)8.0f, (float)0.0f));
        PartDefinition Armor6 = LowerRightArm.m_171599_("Armor6", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -5.0f, 5.5f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.5f, (float)-2.5f));
        PartDefinition LowerRightArm_r1 = Armor6.m_171599_("LowerRightArm_r1", CubeListBuilder.m_171558_().m_171514_(49, 69).m_171488_(-4.0f, -4.0f, 0.0f, 7.0f, 6.0f, 8.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightArmWheel = LowerRightArm.m_171599_("RightArmWheel", CubeListBuilder.m_171558_().m_171514_(26, 89).m_171488_(-2.5f, -3.5f, -3.5f, 5.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)3.4f, (float)2.4f));
        PartDefinition RightHand = LowerRightArm.m_171599_("RightHand", CubeListBuilder.m_171558_().m_171514_(44, 122).m_171488_(-1.0f, 0.5f, -2.5f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)9.5f, (float)1.0f));
        PartDefinition RightFingers = RightHand.m_171599_("RightFingers", CubeListBuilder.m_171558_().m_171514_(17, 116).m_171488_(-0.5f, -0.5f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)4.0f, (float)0.0f));
        PartDefinition RightThumb = RightHand.m_171599_("RightThumb", CubeListBuilder.m_171558_().m_171514_(35, 15).m_171488_(0.0f, -1.0f, -0.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)2.5f, (float)-2.0f));
        PartDefinition RightBlade = LowerRightArm.m_171599_("RightBlade", CubeListBuilder.m_171558_().m_171514_(126, 52).m_171480_().m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(132, 55).m_171488_(0.001f, 0.0f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(132, 55).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)10.0f, (float)1.0f));
        PartDefinition Armor = Body.m_171599_("Armor", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition DoorLeft = Armor.m_171599_("DoorLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.3116f, (float)-3.5f, (float)-3.3871f));
        PartDefinition Armor_r1 = DoorLeft.m_171599_("Armor_r1", CubeListBuilder.m_171558_().m_171514_(52, 40).m_171488_(4.0f, -9.0f, -4.0f, 3.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(118, 123).m_171488_(0.5f, -9.0f, -4.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-7.0833f, (float)5.5f, (float)3.5352f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition DoorRight = Armor.m_171599_("DoorRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.3116f, (float)-3.5f, (float)-3.3871f));
        PartDefinition Armor_r2 = DoorRight.m_171599_("Armor_r2", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-7.0f, -9.0f, -4.0f, 3.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(52, 94).m_171488_(-4.5f, -9.0f, -4.0f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)7.3116f, (float)5.5f, (float)3.3871f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition PartLeft = Armor.m_171599_("PartLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)2.0f, (float)0.0f));
        PartDefinition Armor_r3 = PartLeft.m_171599_("Armor_r3", CubeListBuilder.m_171558_().m_171514_(102, 120).m_171488_(2.0f, -2.0f, -3.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition PartRight = Armor.m_171599_("PartRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)2.0f, (float)0.0f));
        PartDefinition Armor_r4 = PartRight.m_171599_("Armor_r4", CubeListBuilder.m_171558_().m_171514_(120, 45).m_171488_(-6.0f, -2.0f, -3.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition Chest = Armor.m_171599_("Chest", CubeListBuilder.m_171558_().m_171514_(118, 73).m_171488_(-3.0f, -0.5f, -0.5f, 6.0f, 9.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)-3.0f));
        PartDefinition SholderRight = Armor.m_171599_("SholderRight", CubeListBuilder.m_171558_().m_171514_(3, 0).m_171488_(-5.5f, -7.5f, -4.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(72, 49).m_171488_(-4.5f, -10.5f, -4.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition SholderLeft = Armor.m_171599_("SholderLeft", CubeListBuilder.m_171558_().m_171514_(114, 113).m_171488_(3.5f, -10.5f, -4.0f, 1.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(3, 1).m_171488_(4.5f, -7.5f, -4.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Pack = Armor.m_171599_("Pack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.4205f, (float)3.2824f));
        PartDefinition Armor_r5 = Pack.m_171599_("Armor_r5", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-6.0f, -10.5f, 3.5f, 12.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(34, 31).m_171488_(-3.0f, -13.5f, 7.5f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 15).m_171488_(2.0f, -16.5f, 7.5f, 1.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.4205f, (float)-3.2824f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LowerBody = Ratchet.m_171599_("LowerBody", CubeListBuilder.m_171558_().m_171514_(89, 89).m_171488_(-2.0f, 4.5f, -4.5f, 4.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-6.5f, 0.5f, -4.5f, 13.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(0, 30).m_171488_(-1.5f, -0.5f, -4.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(60, 17).m_171488_(-5.0f, 1.0f, -3.5f, 10.0f, 4.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-0.5f));
        PartDefinition LowerBody_r1 = LowerBody.m_171599_("LowerBody_r1", CubeListBuilder.m_171558_().m_171514_(40, 94).m_171488_(-0.5f, -3.0f, -2.5f, 1.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)2.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        PartDefinition LowerBody_r2 = LowerBody.m_171599_("LowerBody_r2", CubeListBuilder.m_171558_().m_171514_(94, 56).m_171488_(-0.5f, -3.0f, -2.5f, 1.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)2.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition LeftLeg = LowerBody.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(60, 32).m_171488_(-3.0f, 0.5f, -4.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(4, 31).m_171488_(-0.5f, 2.0f, -4.01f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(112, 64).m_171488_(-2.5f, 9.5f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)4.5f, (float)0.0f));
        PartDefinition LowerLeftLeg = LeftLeg.m_171599_("LowerLeftLeg", CubeListBuilder.m_171558_().m_171514_(100, 39).m_171488_(-3.0f, 1.0f, -2.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-0.5f));
        PartDefinition Armor2_r1 = LowerLeftLeg.m_171599_("Armor2_r1", CubeListBuilder.m_171558_().m_171514_(28, 40).m_171488_(0.0f, -21.0f, -6.5f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)23.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWheel = LowerLeftLeg.m_171599_("LeftWheel", CubeListBuilder.m_171558_().m_171514_(0, 83).m_171488_(-2.5f, -3.5f, -3.5f, 6.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)15.5f, (float)0.5f));
        PartDefinition Armor2 = LowerLeftLeg.m_171599_("Armor2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.1024f, (float)1.0252f));
        PartDefinition Armor2_r2 = Armor2.m_171599_("Armor2_r2", CubeListBuilder.m_171558_().m_171514_(106, 52).m_171488_(0.0f, -17.0f, 8.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)17.911f, (float)-4.6675f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Armor3_r1 = Armor2.m_171599_("Armor3_r1", CubeListBuilder.m_171558_().m_171514_(106, 0).m_171488_(1.0f, -24.5f, 6.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)17.911f, (float)-4.6675f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFeet = LowerLeftLeg.m_171599_("LeftFeet", CubeListBuilder.m_171558_().m_171514_(76, 0).m_171488_(-3.0f, -0.5f, -1.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(108, 28).m_171488_(-2.0f, 2.5f, -5.5f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(84, 56).m_171488_(-2.0f, 5.5f, -9.5f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)14.5f, (float)0.0f));
        PartDefinition LeftFeet_r1 = LeftFeet.m_171599_("LeftFeet_r1", CubeListBuilder.m_171558_().m_171514_(44, 83).m_171488_(-3.5f, -2.0f, 6.9f, 7.0f, 4.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)1.0f, (float)8.5f, (float)-12.4f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFeet_r2 = LeftFeet.m_171599_("LeftFeet_r2", CubeListBuilder.m_171558_().m_171514_(0, 111).m_171488_(-3.0f, 0.0f, -0.1f, 6.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)1.0f, (float)5.5f, (float)-9.4f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = LowerBody.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(52, 52).m_171488_(-3.0f, 0.5f, -4.0f, 6.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(39, 110).m_171488_(-2.5f, 9.5f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(6, 21).m_171488_(-0.5f, 2.0f, -4.01f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)4.5f, (float)0.0f));
        PartDefinition LowerRightLeg = RightLeg.m_171599_("LowerRightLeg", CubeListBuilder.m_171558_().m_171514_(0, 97).m_171488_(-3.0f, 1.0f, -2.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)-0.5f));
        PartDefinition Armor3_r2 = LowerRightLeg.m_171599_("Armor3_r2", CubeListBuilder.m_171558_().m_171514_(36, 20).m_171488_(-8.0f, -21.0f, -6.5f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)23.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightWheel = LowerRightLeg.m_171599_("RightWheel", CubeListBuilder.m_171558_().m_171514_(81, 42).m_171488_(-3.5f, -3.5f, -3.5f, 6.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)15.5f, (float)0.5f));
        PartDefinition Armor5 = LowerRightLeg.m_171599_("Armor5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.1024f, (float)1.0252f));
        PartDefinition Armor3_r3 = Armor5.m_171599_("Armor3_r3", CubeListBuilder.m_171558_().m_171514_(58, 103).m_171488_(-6.0f, -17.0f, 8.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)17.911f, (float)-4.6675f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Armor4_r1 = Armor5.m_171599_("Armor4_r1", CubeListBuilder.m_171558_().m_171514_(104, 101).m_171488_(-7.0f, -24.5f, 6.0f, 6.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)17.911f, (float)-4.6675f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightFeet = LowerRightLeg.m_171599_("RightFeet", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-5.0f, -0.5f, -1.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(106, 83).m_171488_(-4.0f, 2.5f, -5.5f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 47).m_171488_(-4.0f, 5.5f, -9.5f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)14.5f, (float)0.0f));
        PartDefinition RightFeet_r1 = RightFeet.m_171599_("RightFeet_r1", CubeListBuilder.m_171558_().m_171514_(80, 28).m_171488_(-3.5f, -2.0f, 6.9f, 7.0f, 4.0f, 7.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)-1.0f, (float)8.5f, (float)-12.4f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition RightFeet_r2 = RightFeet.m_171599_("RightFeet_r2", CubeListBuilder.m_171558_().m_171514_(110, 12).m_171488_(-3.0f, 0.0f, -0.1f, 6.0f, 2.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)-1.0f, (float)5.5f, (float)-9.4f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)500, (int)500);
    }

    @Override
    public void setupHandAnim(AbstractClientPlayer entity, float ageInTicks, HumanoidArm arm) {
        super.setupHandAnim(entity, ageInTicks, arm);
        this.getArm((HumanoidArm)arm).f_104200_ = this.getArm((HumanoidArm)arm).f_104200_ + (arm == HumanoidArm.RIGHT ? 8.0f : -8.0f);
    }

    @Override
    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.translateToHand(arm, poseStack, -3.0f, 5.0f, 0.0f);
    }

    @Override
    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @Override
    public List<ModelPart> getHandDirectory(HumanoidArm arm) {
        if (arm == HumanoidArm.LEFT) {
            return List.of(this.ratchet, this.upperBody, this.body, this.leftArm, this.lowerLeftArm, this.leftHand);
        }
        return List.of(this.ratchet, this.upperBody, this.body, this.rightArm, this.lowerRightArm, this.rightHand);
    }

    @Override
    public ModelPart getRightLeg() {
        return this.rightLeg;
    }

    @Override
    public ModelPart getLeftLeg() {
        return this.leftLeg;
    }

    @Override
    protected AnimationDefinition healingAnimation() {
        return RatchetAnimation.HEALSELF;
    }

    @Override
    protected void animateRunning(AbstractClientPlayer entity, float limbSwing, float limbSwingAmount) {
        this.m_267799_(RatchetAnimation.RUNNING, limbSwing, limbSwingAmount, 0.85f, 1.0f);
    }
}

