/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.blockentity;

import bnb.tfp.block.EnergonConverterBlock;
import bnb.tfp.blockentity.EnergonConverterBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class EnergonConverterRenderer
implements BlockEntityRenderer<EnergonConverterBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "energon_converter"), "main");
    public static final RenderType RENDER_TYPE;
    public static final RenderType FLUID_RENDER_TYPE;
    private final ModelPart root;
    private final ModelPart energonConverter;
    private final ModelPart topMixer;
    private final ModelPart fluid;

    public EnergonConverterRenderer(BlockEntityRendererProvider.Context ctx) {
        this.root = ctx.m_173582_(LAYER_LOCATION);
        this.energonConverter = this.root.m_171324_("energonConverter");
        this.topMixer = this.energonConverter.m_171324_("topMixer");
        this.fluid = this.energonConverter.m_171324_("fluid");
    }

    public void render(EnergonConverterBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight, int packedOverlay) {
        float fluidProcess;
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(-0.5f, 0.0f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(((Direction)blockEntity.m_58900_().m_61143_((Property)EnergonConverterBlock.FACING)).m_122424_().m_122435_()));
        float mixerRot = blockEntity.mixerRot + partialTick * blockEntity.rotSpeed;
        poseStack.m_252781_(Axis.f_252403_.m_252977_(blockEntity.rotSpeed * Mth.m_14089_((float)(mixerRot * 4.0f)) * 0.25f));
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        this.topMixer.f_104204_ = mixerRot;
        this.fluid.f_104207_ = false;
        this.root.m_104301_(poseStack, src.m_6299_(RENDER_TYPE), packedLight, packedOverlay);
        float f = fluidProcess = blockEntity.m_8020_(0).m_41619_() ? blockEntity.getConvertingProcess() : 1.0f;
        if (fluidProcess > 0.0f) {
            this.root.m_104299_(poseStack);
            this.energonConverter.m_104299_(poseStack);
            this.fluid.f_104207_ = true;
            this.fluid.f_233554_ = fluidProcess;
            this.fluid.m_104301_(poseStack, src.m_6299_(FLUID_RENDER_TYPE), packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition energonConverter = partdefinition.m_171599_("energonConverter", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-9.0f, -8.0f, -9.0f, 18.0f, 0.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(0, 45).m_171488_(-6.0f, -12.999f, -6.0f, 12.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -3.0f, -8.0f, 16.0f, 11.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(8.01f, 2.5f, 0.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(64, 10).m_171488_(0.0f, -23.0f, -7.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition cube_r1 = energonConverter.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-23.0f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r2 = energonConverter.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -7.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-23.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition cube_r3 = energonConverter.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-23.0f, (float)4.0f, (float)0.0f, (float)2.3562f, (float)0.0f));
        PartDefinition cube_r4 = energonConverter.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -7.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-23.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition cube_r5 = energonConverter.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-23.0f, (float)4.0f, (float)0.0f, (float)-2.3562f, (float)0.0f));
        PartDefinition cube_r6 = energonConverter.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -7.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-23.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r7 = energonConverter.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(64, 10).m_171488_(0.0f, 0.0f, -3.0f, 0.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-23.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition topMixer = energonConverter.m_171599_("topMixer", CubeListBuilder.m_171558_().m_171514_(48, 45).m_171488_(-4.0f, -23.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(48, 63).m_171488_(-3.5f, -24.0f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fluid = energonConverter.m_171599_("fluid", CubeListBuilder.m_171558_().m_171514_(54, 27).m_171488_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    static {
        ResourceLocation texture = new ResourceLocation("tfp", "textures/entity/energon_converter.png");
        RENDER_TYPE = RenderType.m_110458_((ResourceLocation)texture);
        FLUID_RENDER_TYPE = RenderType.m_234338_((ResourceLocation)texture);
    }
}

