/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.blockentity;

import bnb.tfp.TFPData;
import bnb.tfp.block.LaptopBlock;
import bnb.tfp.blockentity.LaptopBlockEntity;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderers;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LaptopScreenRenderer
implements BlockEntityRenderer<LaptopBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "laptopscreen"), "main");
    public static final ResourceLocation TEXTURE = new ResourceLocation("tfp", "textures/entity/laptop_screen.png");
    private static final int TEXT_COLOR = 30464;
    private final ModelPart screen;
    private final Font font;

    public LaptopScreenRenderer(BlockEntityRendererProvider.Context ctx) {
        this.screen = ctx.m_173582_(LAYER_LOCATION).m_171324_("Screen");
        this.font = ctx.m_173586_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Screen", CubeListBuilder.m_171558_().m_171514_(0, 0).m_271786_(-6.5f, -10.5f, 0.1f, 13.0f, 10.0f, 0.0f, Set.of(Direction.NORTH)), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)4.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)13, (int)10);
    }

    public void render(LaptopBlockEntity block, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight, int packedOverlay) {
        BlockState state = block.m_58900_();
        if (!((Boolean)state.m_61143_((Property)LaptopBlock.OPEN)).booleanValue() || !((Boolean)state.m_61143_((Property)LaptopBlock.POWERED)).booleanValue()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(-0.5f, -1.501f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(((Direction)state.m_61143_((Property)LaptopBlock.f_54117_)).m_122424_().m_122435_()));
        this.screen.m_104301_(poseStack, src.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE)), 0xF00000, packedOverlay);
        this.screen.m_104299_(poseStack);
        block.getTracked().ifPresent(uuid -> {
            poseStack.m_85836_();
            poseStack.m_85837_(0.21875, -0.3125, 0.00625);
            poseStack.m_85841_(0.33f, 0.33f, 0.01f);
            PlayableTransformer transformer = TFPData.clientInstance().getTransformer((UUID)uuid);
            if (transformer == null) {
                return;
            }
            TransformerRenderer<?, ?, ?> renderer = TransformerRenderers.get(transformer.getType());
            AbstractTransformerBotModel model = (AbstractTransformerBotModel)renderer.m_7200_();
            model.animateHeadOnLaptop(transformer);
            AbstractClientPlayer player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46003_(uuid);
            if (player == null) {
                player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
            }
            model.m_5585_().m_104301_(poseStack, src.m_6299_(model.m_103119_(renderer.getTextureLocation(player))), 0xF00000, packedOverlay);
            poseStack.m_85849_();
        });
        float scale = 0.0078125f;
        poseStack.m_85837_(-0.34375, -0.53125, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        block.getTracked().ifPresentOrElse(uuid -> {
            PlayerInfo info = Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104949_(uuid);
            if (info != null) {
                this.renderLine((Component)Component.m_237113_((String)info.m_105312_().getName()), 0, 48.0f, poseStack, src);
            }
            this.renderLine(this.getCoordComponent(block, Direction.Axis.X), 16, 48.0f, poseStack, src);
            this.renderLine(this.getCoordComponent(block, Direction.Axis.Y), 32, 48.0f, poseStack, src);
            this.renderLine(this.getCoordComponent(block, Direction.Axis.Z), 48, 88.0f, poseStack, src);
        }, () -> {
            this.renderLine((Component)Component.m_237113_((String)"Target not"), 0, 48.0f, poseStack, src);
            this.renderLine((Component)Component.m_237113_((String)"found."), 16, 48.0f, poseStack, src);
            this.renderLine((Component)Component.m_237113_((String)"Try using"), 32, 48.0f, poseStack, src);
            this.renderLine((Component)Component.m_237113_((String)"signal navigator"), 48, 88.0f, poseStack, src);
        });
        poseStack.m_85849_();
    }

    private void renderLine(Component component, int margin, float pxLimit, PoseStack poseStack, MultiBufferSource src) {
        poseStack.m_85836_();
        int length = this.font.m_92852_((FormattedText)component);
        if ((float)length > pxLimit) {
            poseStack.m_85841_(pxLimit / (float)length, 1.0f, pxLimit / (float)length);
        }
        this.font.m_272077_(component, 0.0f, (float)margin, 30464, false, poseStack.m_85850_().m_252922_(), src, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    private Component getCoordComponent(LaptopBlockEntity block, Direction.Axis axis) {
        String string = String.valueOf(block.getTrackedPos().m_123304_(axis));
        int index = Math.min(block.axisTicks.get(axis) / 3, string.length());
        return Component.m_237113_((String)"\"%s\":%s".formatted(axis.m_122477_(), string.substring(0, index))).m_7220_((Component)Component.m_237113_((String)string.substring(index)).m_130940_(ChatFormatting.OBFUSCATED));
    }
}

