/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity;

import bnb.tfp.TFPUtils;
import bnb.tfp.client.model.WheeljackGrenadeModel;
import bnb.tfp.entity.WheeljackGrenade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WheeljackGrenadeRenderer
extends EntityRenderer<WheeljackGrenade> {
    private final ResourceLocation texture;
    private final RenderType glowing;
    private final WheeljackGrenadeModel model;

    public WheeljackGrenadeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new WheeljackGrenadeModel(WheeljackGrenadeModel.getLayer(context.m_174027_()));
        if (TFPUtils.isHalloween()) {
            this.texture = new ResourceLocation("tfp", "textures/entity/pumpkin_bomb.png");
            this.glowing = RenderType.m_110488_((ResourceLocation)this.texture.m_247266_(path -> path.replace(".png", "_glowmask.png")));
        } else {
            this.texture = new ResourceLocation("tfp", "textures/entity/transformer/wheeljack/original.png");
            this.glowing = RenderType.m_110488_((ResourceLocation)this.texture.m_247266_(path -> path.replace("original", "headlights")));
        }
    }

    public void render(WheeljackGrenade entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.09375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f - entityYaw));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())));
        if (TFPUtils.isHalloween()) {
            poseStack.m_252880_(0.0f, 0.65725f, 0.0f);
            poseStack.m_85841_(-0.5f, -0.5f, 0.5f);
        } else {
            poseStack.m_252880_(0.0f, 1.40725f, 0.0f);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        }
        this.model.m_7695_(poseStack, buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (WheeljackGrenade.shouldBeep(entity.getDetonationTime())) {
            this.model.m_7695_(poseStack, buffer.m_6299_(this.glowing), 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(WheeljackGrenade wheeljackGrenade) {
        return this.texture;
    }
}

