/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.layers;

import bnb.tfp.TFPData;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransformerColorLayers<T extends EntityModel<AbstractClientPlayer>>
extends RenderLayer<AbstractClientPlayer, T> {
    public static final boolean optimization = true;
    protected final boolean altModel;

    public TransformerColorLayers(LivingEntityRenderer<AbstractClientPlayer, T> renderer, boolean altModel) {
        super(renderer);
        this.altModel = altModel;
    }

    public void render(PoseStack poseStack, MultiBufferSource src, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)entity);
        ArrayDeque<float[]> defaultColors = new ArrayDeque<float[]>(transformer.getType().getDefaultVariant().stream().map(layer -> layer.getColor().rgbFloats()).toList());
        for (TransformerColorLayer layer2 : transformer.getVariant()) {
            ResourceLocation texture = layer2.getTextureLocation((Player)entity, transformer, partialTick);
            float[] color = layer2.getColor((Player)entity, transformer);
            if (layer2.shouldRender((Player)entity, transformer, this.altModel, partialTick) && !Arrays.equals(color, defaultColors.getFirst())) {
                this.m_117386_().m_7695_(poseStack, src.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
            }
            if (layer2.shouldRenderGlow((Player)entity, transformer, this.altModel, partialTick)) {
                this.m_117386_().m_7695_(poseStack, src.m_6299_(RenderType.m_110488_((ResourceLocation)texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
            }
            defaultColors.poll();
        }
    }
}

