/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.layers;

import bnb.tfp.TFPData;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransofrmerPupilsLayer<T extends AbstractTransformerBotModel<AbstractClientPlayer, ?>>
extends RenderLayer<AbstractClientPlayer, T> {
    private final float saturation;
    private final ResourceLocation texture;

    public TransofrmerPupilsLayer(TransformerRenderer<?, T, ?> renderer, float saturation) {
        super(renderer);
        this.saturation = saturation;
        this.texture = new ResourceLocation("tfp", "textures/entity/transformer/" + renderer.type.getName() + "/pupils.png");
    }

    public void render(PoseStack poseStack, MultiBufferSource src, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        float[] color = new float[]{1.0f, 1.0f, 1.0f};
        PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)entity);
        if (this.saturation > 0.0f) {
            color = transformer.getVariant().get(transformer.getVariant().size() - 1).getColor().rgbFloats();
            color[0] = 1.0f - this.saturation + this.saturation * color[0];
            color[1] = 1.0f - this.saturation + this.saturation * color[1];
            color[2] = 1.0f - this.saturation + this.saturation * color[2];
        }
        ((AbstractTransformerBotModel)this.m_117386_()).m_7695_(poseStack, src.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
        ((AbstractTransformerBotModel)this.m_117386_()).m_7695_(poseStack, src.m_6299_(RenderType.m_110488_((ResourceLocation)this.texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f);
    }
}

