/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.transformer;

import bnb.tfp.client.model.transformer.alt.AbstractHologramTransformerCarModel;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.client.renderer.entity.transformer.TransformerVehicleRenderer;
import bnb.tfp.transformer.HologramPlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HologramCarRenderer<T extends HologramPlayableTransformer, M extends AbstractHologramTransformerCarModel<T>>
extends TransformerVehicleRenderer<T, M> {
    private final RiderRenderer riderRenderer;
    private final RiderRenderer slimRiderRenderer;

    public HologramCarRenderer(EntityRendererProvider.Context ctx, M model, TransformerRenderer<T, ?, M> transformerRenderer, float shadowRadius, boolean headlights) {
        super(ctx, model, transformerRenderer, shadowRadius, headlights);
        this.riderRenderer = new RiderRenderer(ctx, false);
        this.slimRiderRenderer = new RiderRenderer(ctx, true);
    }

    public void render(AbstractClientPlayer entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight) {
        super.m_7392_((LivingEntity)entity, entityYaw, partialTick, poseStack, src, packedLight);
        Minecraft mc = Minecraft.m_91087_();
        Entity entity2 = entity.m_146895_();
        if (entity2 instanceof AbstractClientPlayer) {
            AbstractClientPlayer passenger = (AbstractClientPlayer)entity2;
            if (mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON || mc.f_91074_ != passenger) {
                if (passenger.m_108564_().equals("slim")) {
                    this.slimRiderRenderer.m_7392_((LivingEntity)passenger, entityYaw, partialTick, poseStack, src, packedLight);
                } else {
                    this.riderRenderer.m_7392_((LivingEntity)passenger, entityYaw, partialTick, poseStack, src, packedLight);
                }
            }
        }
    }

    class RiderRenderer
    extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
        public RiderRenderer(EntityRendererProvider.Context ctx, boolean slim) {
            super(ctx, (EntityModel)new PlayerModel<AbstractClientPlayer>(ctx.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim){

                public void setupAnim(AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                    ((AbstractHologramTransformerCarModel)HologramCarRenderer.this.f_115290_).copyPropertiesToRiderModel(this);
                }
            }, 0.5f);
            this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(ctx.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(ctx.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), ctx.m_266367_()));
            this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, ctx.m_234598_()));
            this.m_115326_((RenderLayer)new ArrowLayer(ctx, (LivingEntityRenderer)this));
            this.m_115326_((RenderLayer)new Deadmau5EarsLayer((RenderLayerParent)this));
            this.m_115326_((RenderLayer)new CapeLayer((RenderLayerParent)this){

                public void m_6494_(PoseStack poseStack, MultiBufferSource src, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                    poseStack.m_85836_();
                    ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                    super.m_6494_(poseStack, src, packedLight, entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                    poseStack.m_85849_();
                }
            });
            this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.m_174027_(), ctx.m_234598_()));
            this.m_115326_((RenderLayer)new ElytraLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>((RenderLayerParent)this, ctx.m_174027_()){

                public void render(PoseStack poseStack, MultiBufferSource src, int packedLight, AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
                    poseStack.m_85836_();
                    ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                    super.m_6494_(poseStack, src, packedLight, (LivingEntity)entity, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                    poseStack.m_85849_();
                }
            });
            this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        }

        protected void setupRotations(AbstractClientPlayer entity, PoseStack poseStack, float ageInTicks, float yRot, float partialTick) {
            Entity entity2 = entity.m_20202_();
            if (!(entity2 instanceof AbstractClientPlayer)) {
                return;
            }
            AbstractClientPlayer vehicle = (AbstractClientPlayer)entity2;
            super.m_7523_((LivingEntity)vehicle, poseStack, ageInTicks, Mth.m_14179_((float)partialTick, (float)vehicle.f_20884_, (float)vehicle.f_20883_), partialTick);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_252880_(0.0f, -1.501f, 0.0f);
            ((AbstractHologramTransformerCarModel)HologramCarRenderer.this.f_115290_).translateToSeat(poseStack);
            poseStack.m_252880_(0.0f, 1.501f, 0.0f);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        }

        public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
            return entity.m_108560_();
        }
    }
}

