/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.client.renderer.entity.layers.TransformerColorLayers;
import bnb.tfp.client.renderer.entity.layers.TransofrmerPupilsLayer;
import bnb.tfp.client.renderer.entity.transformer.TransformerVehicleRenderer;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransformerRenderer<T extends PlayableTransformer, B extends AbstractTransformerBotModel<AbstractClientPlayer, T>, V extends AbstractTransformerModel<AbstractClientPlayer, T>>
extends LivingEntityRenderer<AbstractClientPlayer, B> {
    public final TransformerType type;
    @Nullable
    public final TransformerVehicleRenderer<T, V> vehicleRenderer;

    public TransformerRenderer(EntityRendererProvider.Context ctx, TransformerType type, B model, Function<TransformerRenderer<T, B, V>, TransformerVehicleRenderer<T, V>> vehicleRenderer, float shadowRadius, float pupilSaturation) {
        super(ctx, model, shadowRadius);
        this.type = type;
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, ctx.m_234598_()));
        this.m_115326_(new TransformerColorLayers(this, false));
        if (pupilSaturation != 1.0f) {
            this.m_115326_(new TransofrmerPupilsLayer(this, pupilSaturation));
        }
        this.vehicleRenderer = vehicleRenderer.apply(this);
    }

    public TransformerRenderer(EntityRendererProvider.Context ctx, TransformerType type, B model, V vehicleModel, float shadowRadius, float vehicleShadowRadius, boolean headlights, float pupilSaturation) {
        this(ctx, type, model, renderer -> new TransformerVehicleRenderer(ctx, (AbstractTransformerModel)((Object)vehicleModel), renderer, vehicleShadowRadius, headlights), shadowRadius, pupilSaturation);
    }

    public TransformerRenderer(EntityRendererProvider.Context ctx, TransformerType type, B model, float shadowRadius, float pupilSaturation) {
        this(ctx, type, model, renderer -> null, shadowRadius, pupilSaturation);
    }

    public boolean setStates(PlayableTransformer transformer) {
        try {
            PlayableTransformer states = transformer;
            ((AbstractTransformerBotModel)this.m_7200_()).setStates(states);
            if (this.vehicleRenderer != null) {
                ((AbstractTransformerModel)this.vehicleRenderer.m_7200_()).setStates(states);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void render(AbstractClientPlayer entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight) {
        PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)entity);
        if (transformer != null && this.setStates(transformer)) {
            if (this.shouldRenderBotModel(entity, transformer, partialTick)) {
                super.m_7392_((LivingEntity)entity, entityYaw, partialTick, poseStack, src, packedLight);
            }
            if (this.vehicleRenderer != null && this.shouldRenderAltModel(entity, transformer, partialTick)) {
                this.vehicleRenderer.m_7392_((LivingEntity)entity, entityYaw, partialTick, poseStack, src, packedLight);
            }
        }
    }

    protected void setupRotations(AbstractClientPlayer entity, PoseStack poseStack, float ageInTicks, float yRot, float partialTick) {
        super.m_7523_((LivingEntity)entity, poseStack, ageInTicks, yRot, partialTick);
        PlayableTransformer transformer = TFPData.getTransformerStatic((Player)entity);
        poseStack.m_252781_(transformer.getVehicleType().getRenderRot((Player)entity, transformer, Mth.m_14177_((float)(Mth.m_14179_((float)partialTick, (float)entity.f_20886_, (float)entity.m_6080_()) - yRot)), Mth.m_14177_((float)Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())), partialTick, ((AbstractTransformerBotModel)this.m_7200_()).transformationProgress()));
        if (entity.m_6067_()) {
            poseStack.m_252880_(0.0f, -1.0f, 0.3f);
        }
    }

    public boolean shouldRenderBotModel(AbstractClientPlayer player, PlayableTransformer transformer, float partialTick) {
        return this.vehicleRenderer == null || !transformer.isTransformed() || !((AbstractTransformerBotModel)this.m_7200_()).transformationFinished();
    }

    public boolean shouldRenderAltModel(AbstractClientPlayer player, PlayableTransformer transformer, float partialTick) {
        return this.vehicleRenderer != null && (transformer.isTransformed() || !((AbstractTransformerModel)this.vehicleRenderer.m_7200_()).transformationFinished());
    }

    public void copyModelProperties(PlayerModel<AbstractClientPlayer> model) {
        HumanoidModel humanoidModel = ((AbstractTransformerBotModel)this.m_7200_()).humanoidModel;
        humanoidModel.f_102816_ = model.f_102816_;
        humanoidModel.f_102815_ = model.f_102815_;
    }

    public boolean shouldCancelArmRendering(AbstractClientPlayer entity, PlayableTransformer transformer, HumanoidArm arm, float partialTick) {
        return transformer.isTransformed();
    }

    public void setupModelAndRenderArm(AbstractClientPlayer entity, PlayableTransformer transformer, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight, HumanoidArm arm) {
        if (!this.setStates(transformer)) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
        ((AbstractTransformerBotModel)this.f_115290_).prepareMobModel(entity, 0.0f, 0.0f, partialTick);
        ((AbstractTransformerBotModel)this.f_115290_).setupHandAnim(entity, (float)entity.f_19797_ + partialTick, arm);
        ((AbstractTransformerBotModel)this.f_115290_).renderHand(poseStack, src.m_6299_(((AbstractTransformerBotModel)this.f_115290_).m_103119_(this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f, arm);
        ArrayDeque<TransformerColorLayer> defaultColors = new ArrayDeque<TransformerColorLayer>(transformer.getType().getDefaultVariant());
        for (TransformerColorLayer layer : transformer.getVariant()) {
            ResourceLocation texture = layer.getTextureLocation((Player)entity, transformer, partialTick);
            float[] color = layer.getColor((Player)entity, transformer);
            if (layer.shouldRender((Player)entity, transformer, false, partialTick) && !Arrays.equals(color, defaultColors.getFirst().getColor((Player)entity, transformer))) {
                ((AbstractTransformerBotModel)this.f_115290_).renderHand(poseStack, src.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f, arm);
            }
            if (layer.shouldRenderGlow((Player)entity, transformer, false, partialTick)) {
                ((AbstractTransformerBotModel)this.f_115290_).renderHand(poseStack, src.m_6299_(RenderType.m_110488_((ResourceLocation)texture)), packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], 1.0f, arm);
            }
            defaultColors.poll();
        }
    }

    public void renderArmNoSwing(AbstractClientPlayer player, PlayableTransformer transformer, float partialTick, PoseStack poseStack, MultiBufferSource src, int packedLight, HumanoidArm arm) {
        boolean flag = arm != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        poseStack.m_252880_(f * 0.64000005f, -0.6f, -0.71999997f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 45.0f));
        poseStack.m_252880_(f * -1.0f, 3.6f, 3.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 120.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * -135.0f));
        poseStack.m_252880_(f * 5.6f, 0.0f, 0.0f);
        this.setupModelAndRenderArm(player, transformer, partialTick, poseStack, src, packedLight, arm);
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return new ResourceLocation("tfp", "textures/entity/transformer/" + this.type.getName() + "/original.png");
    }

    public ResourceLocation getVehicleTextureLocation(AbstractClientPlayer entity) {
        return this.getTextureLocation(entity);
    }

    public boolean shouldHeadlightsGlow(AbstractClientPlayer player, PlayableTransformer transformer, float partialTick) {
        return transformer.isVehicleSpecialActive();
    }

    public ResourceLocation getHeadlightsTextureLocation(AbstractClientPlayer entity) {
        return new ResourceLocation("tfp", "textures/entity/transformer/" + this.type.getName() + "/headlights.png");
    }
}

