/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.transformer;

import bnb.tfp.client.model.transformer.alt.AirachnidHelicopterModel;
import bnb.tfp.client.model.transformer.alt.ArceeMotorcycleModel;
import bnb.tfp.client.model.transformer.alt.BreakdownTruckModel;
import bnb.tfp.client.model.transformer.alt.BulkheadCarModel;
import bnb.tfp.client.model.transformer.alt.BumblebeeCarModel;
import bnb.tfp.client.model.transformer.alt.KnockoutCarModel;
import bnb.tfp.client.model.transformer.alt.OptimusPrimeTruckModel;
import bnb.tfp.client.model.transformer.alt.RatchetAmbulanceModel;
import bnb.tfp.client.model.transformer.alt.ShockwaveTankModel;
import bnb.tfp.client.model.transformer.alt.SoundwaveDroneModel;
import bnb.tfp.client.model.transformer.alt.StarscreamJetModel;
import bnb.tfp.client.model.transformer.alt.UltraMagnusTruckModel;
import bnb.tfp.client.model.transformer.alt.VehiconFlyerCarModel;
import bnb.tfp.client.model.transformer.alt.VehiconGroundCarModel;
import bnb.tfp.client.model.transformer.alt.VehiconMinerDrillModel;
import bnb.tfp.client.model.transformer.alt.WheeljackCarModel;
import bnb.tfp.client.model.transformer.bot.AirachnidModel;
import bnb.tfp.client.model.transformer.bot.ArceeModel;
import bnb.tfp.client.model.transformer.bot.BreakdownModel;
import bnb.tfp.client.model.transformer.bot.BulkheadModel;
import bnb.tfp.client.model.transformer.bot.BumblebeeModel;
import bnb.tfp.client.model.transformer.bot.KnockoutModel;
import bnb.tfp.client.model.transformer.bot.MegatronModel;
import bnb.tfp.client.model.transformer.bot.NemesisPrimeModel;
import bnb.tfp.client.model.transformer.bot.OptimusPrimeModel;
import bnb.tfp.client.model.transformer.bot.RatchetModel;
import bnb.tfp.client.model.transformer.bot.ShockwaveModel;
import bnb.tfp.client.model.transformer.bot.SoundwaveModel;
import bnb.tfp.client.model.transformer.bot.StarscreamModel;
import bnb.tfp.client.model.transformer.bot.UltraMagnusModel;
import bnb.tfp.client.model.transformer.bot.VehiconFlyerModel;
import bnb.tfp.client.model.transformer.bot.VehiconGroundModel;
import bnb.tfp.client.model.transformer.bot.VehiconMinerModel;
import bnb.tfp.client.model.transformer.bot.WheeljackModel;
import bnb.tfp.client.renderer.entity.transformer.HologramCarRenderer;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.reg.PlayableTransformers;
import bnb.tfp.transformer.HealingPlayableTransformer;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import bnb.tfp.transformer.VehiconMiner;
import java.util.HashMap;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransformerRenderers {
    private static final HashMap<TransformerType, TransformerRenderer<?, ?, ?>> transformerRenderers = new HashMap();

    public static TransformerRenderer<?, ?, ?> get(TransformerType type) {
        return transformerRenderers.get(type);
    }

    public static void put(TransformerType type, BiFunction<EntityRendererProvider.Context, TransformerType, TransformerRenderer<?, ?, ?>> provider) {
        transformerRenderers.put(type, provider.apply(TransformerRenderers.createContext(), type));
    }

    private static EntityRendererProvider.Context createContext() {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher erd = mc.m_91290_();
        return new EntityRendererProvider.Context(erd, mc.m_91291_(), mc.m_91289_(), erd.m_234586_(), mc.m_91098_(), mc.m_167973_(), mc.f_91062_);
    }

    static {
        TransformerRenderers.put(PlayableTransformers.OPTIMUS_PRIME, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new OptimusPrimeModel(ctx.m_174023_(OptimusPrimeModel.LAYER_LOCATION)), new OptimusPrimeTruckModel(ctx.m_174023_(OptimusPrimeTruckModel.LAYER_LOCATION), false), 0.55f, 0.55f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.MEGATRON, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new MegatronModel(ctx.m_174023_(MegatronModel.LAYER_LOCATION)), 1.0f, 0.15f));
        TransformerRenderers.put(PlayableTransformers.SOUNDWAVE, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new SoundwaveModel(ctx.m_174023_(SoundwaveModel.LAYER_LOCATION)), new SoundwaveDroneModel(ctx.m_174023_(SoundwaveDroneModel.LAYER_LOCATION)), 0.5f, 0.25f, false, 1.0f));
        TransformerRenderers.put(PlayableTransformers.BUMBLEBEE, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new BumblebeeModel(ctx.m_174023_(BumblebeeModel.LAYER_LOCATION)), new BumblebeeCarModel(ctx.m_174023_(BumblebeeCarModel.LAYER_LOCATION)), 0.5f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.STARSCREAM, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new StarscreamModel(ctx.m_174023_(StarscreamModel.LAYER_LOCATION)), new StarscreamJetModel(ctx.m_174023_(StarscreamJetModel.LAYER_LOCATION)), 0.4f, 2.0f, false, 0.0f));
        TransformerRenderers.put(PlayableTransformers.RATCHET, (ctx, type) -> new TransformerRenderer<HealingPlayableTransformer, RatchetModel<HealingPlayableTransformer>, RatchetAmbulanceModel<AbstractClientPlayer, HealingPlayableTransformer>>(ctx, type, new RatchetModel(ctx.m_174023_(RatchetModel.LAYER_LOCATION)), new RatchetAmbulanceModel(ctx.m_174023_(RatchetAmbulanceModel.LAYER_LOCATION)), 1.0f, 1.0f, true, 1.0f){

            @Override
            public ResourceLocation getHeadlightsTextureLocation(AbstractClientPlayer entity) {
                return super.getHeadlightsTextureLocation(entity).m_247266_(path -> path.replace(".png", entity.f_19797_ / 10 % 2 + ".png"));
            }
        });
        TransformerRenderers.put(PlayableTransformers.ARCEE, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new ArceeModel(ctx.m_174023_(ArceeModel.LAYER_LOCATION)), renderer -> new HologramCarRenderer((EntityRendererProvider.Context)ctx, new ArceeMotorcycleModel(ctx.m_174023_(ArceeMotorcycleModel.LAYER_LOCATION)), renderer, 0.2f, true), 0.2f, 1.0f));
        TransformerRenderers.put(PlayableTransformers.NEMESIS_PRIME, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new NemesisPrimeModel(ctx.m_174023_(OptimusPrimeModel.LAYER_LOCATION)), new OptimusPrimeTruckModel(ctx.m_174023_(OptimusPrimeTruckModel.LAYER_LOCATION), true), 1.0f, 1.0f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.AIRACHNID, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new AirachnidModel(ctx.m_174023_(AirachnidModel.LAYER_LOCATION)), new AirachnidHelicopterModel(ctx.m_174023_(AirachnidHelicopterModel.LAYER_LOCATION)), 0.25f, 0.3f, false, 1.0f));
        TransformerRenderers.put(PlayableTransformers.BULKHEAD, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new BulkheadModel(ctx.m_174023_(BulkheadModel.LAYER_LOCATION)), new BulkheadCarModel(ctx.m_174023_(BulkheadCarModel.LAYER_LOCATION)), 0.5f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.BREAKDOWN, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new BreakdownModel(ctx.m_174023_(BreakdownModel.LAYER_LOCATION)), new BreakdownTruckModel(ctx.m_174023_(BreakdownTruckModel.LAYER_LOCATION)), 0.6f, 0.8f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.KNOCKOUT, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new KnockoutModel(ctx.m_174023_(KnockoutModel.LAYER_LOCATION)), new KnockoutCarModel(ctx.m_174023_(KnockoutCarModel.LAYER_LOCATION)), 0.3f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.VEHICON_GROUND, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new VehiconGroundModel(ctx.m_174023_(VehiconGroundModel.LAYER_LOCATION)), new VehiconGroundCarModel(ctx.m_174023_(VehiconGroundCarModel.LAYER_LOCATION)), 0.3f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.VEHICON_FLYER, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new VehiconFlyerModel(ctx.m_174023_(VehiconFlyerModel.LAYER_LOCATION)), new VehiconFlyerCarModel(ctx.m_174023_(VehiconFlyerCarModel.LAYER_LOCATION)), 0.3f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.WHEELJACK, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new WheeljackModel(ctx.m_174023_(WheeljackModel.LAYER_LOCATION)), new WheeljackCarModel(ctx.m_174023_(WheeljackCarModel.LAYER_LOCATION)), 0.5f, 0.6f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.ULTRA_MAGNUS, (ctx, type) -> new TransformerRenderer((EntityRendererProvider.Context)ctx, (TransformerType)type, new UltraMagnusModel(ctx.m_174023_(UltraMagnusModel.LAYER_LOCATION)), new UltraMagnusTruckModel(ctx.m_174023_(UltraMagnusTruckModel.LAYER_LOCATION)), 0.53f, 0.55f, true, 1.0f));
        TransformerRenderers.put(PlayableTransformers.VEHICON_MINER, (ctx, type) -> new TransformerRenderer<VehiconMiner, VehiconMinerModel<AbstractClientPlayer, VehiconMiner>, VehiconMinerDrillModel<VehiconMiner>>(ctx, type, new VehiconMinerModel(ctx.m_174023_(VehiconMinerModel.LAYER_LOCATION)), renderer -> new HologramCarRenderer((EntityRendererProvider.Context)ctx, new VehiconMinerDrillModel(ctx.m_174023_(VehiconMinerDrillModel.LAYER_LOCATION)), renderer, 0.45f, true), 0.375f, 1.0f){

            @Override
            public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
                return super.getTextureLocation(entity).m_247266_(path -> path.replace(".png", (int)(entity.f_267362_.m_267756_() * 16.0f) % 3 + ".png"));
            }
        });
        TransformerRenderers.put(PlayableTransformers.SHOCKWAVE, (ctx, type) -> new TransformerRenderer<PlayableTransformer, ShockwaveModel<AbstractClientPlayer, PlayableTransformer>, ShockwaveTankModel<AbstractClientPlayer, PlayableTransformer>>(ctx, type, new ShockwaveModel(ctx.m_174023_(ShockwaveModel.LAYER_LOCATION)), new ShockwaveTankModel(ctx.m_174023_(ShockwaveTankModel.LAYER_LOCATION)), 0.53f, 0.55f, true, 1.0f){

            @Override
            public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
                return super.getTextureLocation(entity).m_247266_(path -> path.replace(".png", (int)(entity.f_267362_.m_267756_() * 1.0f) % 4 + ".png"));
            }
        });
    }
}

