/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.client.renderer.entity.layers.TransformerColorLayers;
import bnb.tfp.client.renderer.entity.layers.TransformerHeadlightsLayer;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransformerVehicleRenderer<T extends PlayableTransformer, M extends AbstractTransformerModel<AbstractClientPlayer, T>>
extends LivingEntityRenderer<AbstractClientPlayer, M> {
    private final TransformerRenderer<T, ?, M> transformerRenderer;

    public TransformerVehicleRenderer(EntityRendererProvider.Context ctx, M model, TransformerRenderer<T, ?, M> transformerRenderer, float shadowRadius, boolean headlights) {
        super(ctx, model, shadowRadius);
        this.transformerRenderer = transformerRenderer;
        this.m_115326_(new TransformerColorLayers(this, true));
        if (headlights) {
            this.m_115326_(new TransformerHeadlightsLayer(this, transformerRenderer));
        }
    }

    protected void setupRotations(AbstractClientPlayer entity, PoseStack poseStack, float ageInTicks, float yRot, float partialTick) {
        super.m_7523_((LivingEntity)entity, poseStack, ageInTicks, yRot, partialTick);
        PlayableTransformer transformer = TFPData.getTransformerStatic((Player)entity);
        poseStack.m_252781_(transformer.getVehicleType().getRenderRot((Player)entity, transformer, Mth.m_14177_((float)(Mth.m_14179_((float)partialTick, (float)entity.f_20886_, (float)entity.m_6080_()) - yRot)), Mth.m_14177_((float)Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())), partialTick, ((AbstractTransformerModel)this.m_7200_()).transformationProgress()));
        if (entity.m_6067_()) {
            poseStack.m_252880_(0.0f, -1.0f, 0.3f);
        }
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer entity) {
        return this.transformerRenderer.getVehicleTextureLocation(entity);
    }
}

