/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.command;

import bnb.tfp.TFPData;
import bnb.tfp.network.ClientboundSetTransformerPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.reg.PlayableTransformers;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerType;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TransformerCommands {
    private static final Predicate<CommandSourceStack> HAS_CHEATS = stack -> stack.m_6761_(2);
    private static final Predicate<CommandSourceStack> IS_OP = stack -> stack.m_6761_(3);

    public static void init(Consumer<LiteralArgumentBuilder<CommandSourceStack>> register) {
        LiteralArgumentBuilder setSelf = Commands.m_82127_((String)"setself");
        RequiredArgumentBuilder setOthers = Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_());
        PlayableTransformers.getAll().forEach(type -> {
            setSelf.then(Commands.m_82127_((String)type.getName()).executes(ctx -> TransformerCommands.set((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_230896_(), type)));
            setOthers.then(Commands.m_82127_((String)type.getName()).executes(ctx -> TransformerCommands.set((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), type)));
        });
        register.accept((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"transformer").requires(HAS_CHEATS)).then((ArgumentBuilder)setSelf)).then(Commands.m_82127_((String)"clearself").executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            ServerPlayer player = Objects.requireNonNull(src.m_230896_());
            return TransformerCommands.clear((CommandSourceStack)ctx.getSource(), player.m_6302_(), player);
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(IS_OP)).then((ArgumentBuilder)setOthers))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(IS_OP)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> TransformerCommands.clear((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), null))))));
    }

    private static int clear(CommandSourceStack src, String name, @Nullable ServerPlayer player) {
        ServerPlayer player1;
        UUID uuid;
        MinecraftServer server = src.m_81377_();
        if (player != null) {
            uuid = player.m_20148_();
        } else {
            try {
                uuid = ((GameProfile)server.m_129927_().m_10996_(name).get()).getId();
            }
            catch (NullPointerException | NoSuchElementException e) {
                src.m_81352_((Component)Component.m_237115_((String)"command.failed"));
                return 0;
            }
        }
        TFPData tfpData = TFPData.serverInstance(server);
        PlayableTransformer transformer = tfpData.getTransformer(uuid);
        if (transformer == null) {
            src.m_81352_((Component)Component.m_237115_((String)"commands.tfp.transformer.clear.notATransformer"));
            return 0;
        }
        tfpData.clearTransformer(uuid);
        ServerPlayer serverPlayer = player1 = player != null ? player : server.m_6846_().m_11255_(name);
        if (player1 != null) {
            transformer.onTurnedIntoHuman((Player)player1);
        }
        ModNetworking.sendToEveryone(server, new ClientboundSetTransformerPacket(uuid));
        src.m_288197_(() -> Component.m_237110_((String)"commands.tfp.transformer.clear.success", (Object[])new Object[]{name, transformer.getNameComponent()}), true);
        return 1;
    }

    private static int set(CommandSourceStack src, ServerPlayer player, TransformerType type) {
        TFPData tfpData = TFPData.serverInstance(src.m_81377_());
        PlayableTransformer before = tfpData.getTransformer((Player)player);
        if (before != null && before.getType() == type) {
            src.m_81352_((Component)Component.m_237110_((String)"commands.tfp.transformer.set.alreadyThatTransformer", (Object[])new Object[]{before.getNameComponent()}));
            return 0;
        }
        PlayableTransformer transformer = type.get();
        if (!TransformerCommands.trySetTransformer((Player)player, tfpData, transformer)) {
            src.m_81352_((Component)Component.m_237110_((String)"commands.tfp.transformer.set.noAvailable", (Object[])new Object[]{transformer.getNameComponent()}));
            return 0;
        }
        transformer.setupTransformer(player);
        ModNetworking.sendToEveryone(src.m_81377_(), new ClientboundSetTransformerPacket(player.m_20148_(), transformer));
        src.m_288197_(() -> Component.m_237110_((String)"commands.tfp.transformer.set.success", (Object[])new Object[]{player.m_7755_(), transformer.getNameComponent()}), true);
        return 1;
    }

    public static boolean trySetTransformer(Player player, TFPData tfpData, PlayableTransformer transformer) {
        return TransformerCommands.trySetTransformer(player.m_20148_(), tfpData, transformer);
    }

    public static boolean trySetTransformer(UUID uuid, TFPData tfpData, PlayableTransformer transformer) {
        return TransformerCommands.trySetTransformer(uuid, tfpData, transformer, transformer.getVariant().size() - 1);
    }

    private static boolean trySetTransformer(UUID uuid, TFPData tfpData, PlayableTransformer transformer, int index) {
        if (index < 0) {
            return tfpData.setTransformer(uuid, transformer);
        }
        TransformerColorLayer layer = transformer.getVariant().get(index);
        for (int i = 0; i < (layer.brightColorsOnly() ? 216 : 1728); ++i) {
            if (TransformerCommands.trySetTransformer(uuid, tfpData, transformer, index - 1)) {
                return true;
            }
            HSBColor color = layer.getColor();
            int hue = color.hue;
            int saturation = color.saturation;
            int brightness = color.brightness;
            if (++hue < 24) {
                layer.setColor(new HSBColor(hue, saturation, brightness));
                continue;
            }
            if (--saturation >= 0) {
                layer.setColor(new HSBColor(0, saturation, brightness));
                continue;
            }
            if (!layer.brightColorsOnly() && --brightness > 0) {
                layer.setColor(new HSBColor(0, 8, brightness));
                continue;
            }
            layer.setColor(new HSBColor(0, 8, 8));
        }
        return false;
    }
}

