/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.entity;

import bnb.tfp.reg.ModEntities;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GroundBridge
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_DESTINATION_ID = SynchedEntityData.m_135353_(GroundBridge.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);

    public GroundBridge(EntityType<? extends GroundBridge> type, Level lvl) {
        super(type, lvl);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public GroundBridge(Level lvl, BlockPos pos, Direction facing, BlockPos destination) {
        this(ModEntities.GROUND_BRIDGE.get(), lvl);
        this.m_146884_(pos.m_252807_().m_82520_(0.0, -0.5, 0.0));
        this.m_146922_(facing.m_122435_());
        this.setDestination(destination);
    }

    public void m_8119_() {
        if (this.f_19803_) {
            this.m_20011_(this.m_142242_());
        }
        super.m_8119_();
        Level lvl = this.m_9236_();
        Optional<BlockPos> optionalPos = this.getDestination();
        if (optionalPos.isEmpty()) {
            return;
        }
        BlockPos pos = optionalPos.get();
        lvl.m_6249_((Entity)this, this.m_20191_(), entity -> !(entity instanceof GroundBridge)).forEach(entity -> {
            if (entity.m_20092_()) {
                entity.m_287199_(40);
                return;
            }
            entity.m_287199_(40);
            if (!Level.m_46741_((BlockPos)pos)) {
                return;
            }
            entity.m_146884_(entity.m_20182_().m_82549_(pos.m_252807_()).m_82546_(this.m_20183_().m_252807_()));
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinder = (PathfinderMob)entity;
                pathfinder.m_21573_().m_26573_();
            }
        });
    }

    protected AABB m_142242_() {
        Vec3 pos = this.m_20182_();
        return switch (this.m_6350_()) {
            case Direction.EAST, Direction.WEST -> new AABB(pos.m_82520_(-0.2, 0.0, -2.5), pos.m_82520_(0.2, 5.0, 2.5));
            case Direction.NORTH, Direction.SOUTH -> new AABB(pos.m_82520_(-2.5, 0.0, -0.2), pos.m_82520_(2.5, 5.0, 0.2));
            default -> super.m_142242_();
        };
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DESTINATION_ID, Optional.empty());
    }

    protected void m_7378_(CompoundTag tag) {
        String destination = "Destination";
        if (tag.m_128441_(destination)) {
            int[] pos = tag.m_128465_(destination);
            this.setDestination(new BlockPos(pos[0], pos[1], pos[2]));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        this.getDestination().ifPresent(pos -> tag.m_128385_("Destination", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        tag.m_128359_("Facing", this.m_6350_().m_122433_());
    }

    public Optional<BlockPos> getDestination() {
        return (Optional)this.f_19804_.m_135370_(DATA_DESTINATION_ID);
    }

    public void setDestination(BlockPos pos) {
        this.f_19804_.m_135381_(DATA_DESTINATION_ID, Optional.of(pos));
    }
}

