/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.entity;

import bnb.tfp.TFPData;
import bnb.tfp.block.ScrapletInfestedBlock;
import bnb.tfp.blockentity.ScrapletInfestedBlockEntity;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModItems;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Scraplet
extends Monster {
    private final MoveControl groundMoveControl;
    private final MoveControl flyingMoveControl;
    private final PathNavigation groundNavigation;
    private final PathNavigation flyingNavigation;
    public final AnimationState idleAnimState = new AnimationState();
    public final AnimationState attackAnimState = new AnimationState();
    private boolean aggressiveO;

    public Scraplet(EntityType<? extends Scraplet> entityType, Level level) {
        super(entityType, level);
        this.groundMoveControl = this.f_21342_;
        this.flyingMoveControl = new ScrapletFlyingMoveControl((Mob)this);
        this.groundNavigation = this.m_21573_();
        this.flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        this.f_21365_ = new LookControl((Mob)this){

            protected boolean m_8106_() {
                return !this.f_24937_.m_20068_();
            }
        };
        this.f_21364_ = 2;
        this.idleAnimState.m_216977_(this.f_19797_ - 20);
    }

    public Scraplet(Level level) {
        this(ModEntities.SCRAPLET.get(), level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ScrapletAttackGoal(1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, entity -> TFPData.isTransformerStatic((Entity)entity) || Scraplet.hasEdibleItems(entity)));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new ScrapletGoInsideBlockGoal(0.05f, 0.8));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.aggressiveO != this.m_5912_()) {
            this.aggressiveO = !this.aggressiveO;
            this.idleAnimState.m_216977_(this.f_19797_);
        }
        this.attackAnimState.m_216979_(state -> {
            if (state.m_216981_() >= 500L) {
                state.m_216973_();
            }
        });
    }

    public void m_21011_(InteractionHand hand, boolean updateSelf) {
        super.m_21011_(hand, updateSelf);
        this.attackAnimState.m_216982_(this.f_19797_);
    }

    public void biteArmor(LivingEntity entity) {
        Map<EquipmentSlot, ItemStack> map = Arrays.stream(EquipmentSlot.values()).filter(slot -> entity.m_6844_(slot).m_204117_(ModItems.SCRAPLETS_EAT)).collect(Collectors.toMap(slot -> slot, arg_0 -> ((LivingEntity)entity).m_6844_(arg_0)));
        if (map.isEmpty()) {
            return;
        }
        Map.Entry<EquipmentSlot, ItemStack> entry = List.copyOf(map.entrySet()).get(entity.m_217043_().m_188503_(map.size()));
        ItemStack stack = entry.getValue();
        if (stack.m_41763_()) {
            int count = stack.m_41613_();
            stack.m_41622_(16, entity, player1 -> player1.m_21166_((EquipmentSlot)entry.getKey()));
            if (count != stack.m_41613_()) {
                return;
            }
            this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.HOSTILE, 0.25f, 2.0f - (float)stack.m_41773_() * 0.8f / (float)stack.m_41776_());
        } else if ((double)entity.m_217043_().m_188501_() > 0.8 / (double)Mth.m_14116_((float)Mth.m_14116_((float)stack.m_41741_()))) {
            stack.m_41774_(1);
            entity.m_21166_(entry.getKey());
        } else {
            this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), SoundEvents.f_12018_, SoundSource.HOSTILE, 0.25f, 1.6f + entity.m_217043_().m_188501_() * 0.4f);
        }
    }

    public static boolean hasEdibleItems(LivingEntity entity) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!entity.m_6844_(slot).m_204117_(ModItems.SCRAPLETS_EAT)) continue;
            return true;
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Scraplet.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22280_, 1.1).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static class ScrapletFlyingMoveControl
    extends MoveControl {
        public ScrapletFlyingMoveControl(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            double y = this.f_24976_ - this.f_24974_.m_20186_();
            this.f_24974_.m_20242_(y > (double)1.2f || this.f_24974_.m_20068_() && !this.f_24974_.m_9236_().m_46575_(BlockPos.m_274561_((double)this.f_24975_, (double)(this.f_24976_ - 1.0), (double)this.f_24977_), (Entity)this.f_24974_));
            if (this.f_24974_.m_20068_()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    double z;
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    double x = this.f_24975_ - this.f_24974_.m_20185_();
                    if (x * x + y * y + (z = this.f_24977_ - this.f_24974_.m_20189_()) * z < 1.0E-6) {
                        this.f_24974_.f_20902_ = 0.0f;
                        this.f_24974_.f_20901_ = 0.0f;
                        return;
                    }
                    double horizontal = Math.sqrt(x * x + z * z);
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), (float)(-Mth.m_14136_((double)x, (double)z)) * 180.0f / (float)Math.PI, 30.0f));
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), (float)(-Mth.m_14136_((double)y, (double)horizontal)) * 180.0f / (float)Math.PI, 9.0f));
                    float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
                    float xRad = this.f_24974_.m_146909_() * (float)Math.PI / 180.0f;
                    this.f_24974_.m_7910_(speed * Mth.m_14089_((float)xRad));
                    this.f_24974_.m_21567_(-speed * Mth.m_14031_((float)xRad));
                } else {
                    this.f_24974_.f_20902_ = 0.0f;
                    this.f_24974_.f_20901_ = 0.0f;
                }
                return;
            }
            super.m_8126_();
        }
    }

    protected class ScrapletAttackGoal
    extends MeleeAttackGoal {
        public ScrapletAttackGoal(double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)Scraplet.this, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            PathNavigation navigation1 = Scraplet.this.f_21344_;
            Scraplet.this.f_21344_ = Scraplet.this.flyingNavigation;
            if (super.m_8036_()) {
                Scraplet.this.f_21342_ = Scraplet.this.flyingMoveControl;
                return true;
            }
            Scraplet.this.f_21344_ = navigation1;
            return false;
        }

        public boolean m_8045_() {
            Player player;
            LivingEntity livingEntity = Scraplet.this.m_5448_();
            if (livingEntity instanceof Player && !TFPData.isTransformerStatic((Entity)(player = (Player)livingEntity)) && !Scraplet.hasEdibleItems((LivingEntity)player)) {
                Scraplet.this.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos pos1 = Scraplet.this.m_20183_().m_7918_(x, y, z);
                        BlockEntity blockEntity = Scraplet.this.m_9236_().m_7702_(pos1);
                        if (!(blockEntity instanceof ScrapletInfestedBlockEntity)) continue;
                        ScrapletInfestedBlockEntity blockEntity2 = (ScrapletInfestedBlockEntity)blockEntity;
                        Scraplet.this.m_9236_().m_46961_(pos1, false);
                        blockEntity2.releaseScraplet(Scraplet.this.m_9236_(), pos1);
                    }
                }
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double reach = this.m_6639_(enemy);
            if (distToEnemySqr <= reach && this.m_25564_()) {
                Player player;
                this.m_25563_();
                if (enemy instanceof Player && !TFPData.isTransformerStatic((Entity)(player = (Player)enemy))) {
                    Scraplet.this.biteArmor(enemy);
                } else {
                    this.f_25540_.m_7327_((Entity)enemy);
                }
            } else if (distToEnemySqr <= reach * 2.0) {
                if (this.m_25565_() <= 5) {
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else {
                this.m_25563_();
            }
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 2.0f + attackTarget.m_20205_();
        }

        public void m_8041_() {
            super.m_8041_();
            Scraplet.this.f_21342_ = Scraplet.this.groundMoveControl;
            Scraplet.this.f_21344_ = Scraplet.this.groundNavigation;
            Scraplet.this.m_20242_(false);
            Scraplet.this.f_21344_.m_26573_();
        }
    }

    protected class ScrapletGoInsideBlockGoal
    extends Goal {
        private BlockPos wantedPos;
        private final float chance;
        private final double speedModifier;

        public ScrapletGoInsideBlockGoal(float chance, double speedModifier) {
            this.chance = chance;
            this.speedModifier = speedModifier;
        }

        public boolean m_8036_() {
            if (Scraplet.this.f_19796_.m_188501_() > this.chance) {
                return false;
            }
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        this.wantedPos = Scraplet.this.m_20183_().m_7918_(x, y, z);
                        if (!ScrapletInfestedBlock.canBeInfested(Scraplet.this.m_9236_().m_8055_(this.wantedPos).m_60734_())) continue;
                        return Scraplet.this.m_21573_().m_26536_(Scraplet.this.m_21573_().m_7864_(this.wantedPos, 1), this.speedModifier);
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return !Scraplet.this.m_21573_().m_26577_() && !Scraplet.this.m_21573_().m_26571_() && !this.closeEnough();
        }

        public void m_8041_() {
            BlockState state;
            super.m_8041_();
            if (this.closeEnough() && (state = ScrapletInfestedBlock.infest(Scraplet.this.m_9236_().m_8055_(this.wantedPos))) != null) {
                Scraplet.this.m_9236_().m_46961_(this.wantedPos, false);
                Scraplet.this.m_9236_().m_7731_(this.wantedPos, state, 1);
                Scraplet.this.m_146870_();
                BlockEntity blockEntity = Scraplet.this.m_9236_().m_7702_(this.wantedPos);
                if (blockEntity instanceof ScrapletInfestedBlockEntity) {
                    ScrapletInfestedBlockEntity blockEntity2 = (ScrapletInfestedBlockEntity)blockEntity;
                    blockEntity2.setScraplet(Scraplet.this);
                }
            }
        }

        private boolean closeEnough() {
            return Scraplet.this.m_20238_(this.wantedPos.m_252807_()) <= 1.5;
        }
    }
}

