/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.entity;

import bnb.tfp.TFPData;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModItems;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SparkExtractor
extends Entity {
    private static final EntityDataAccessor<Byte> DATA_ACTIVATING_TICKS_ID = SynchedEntityData.m_135353_(SparkExtractor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_DROP_AFTER_USING_ID = SynchedEntityData.m_135353_(SparkExtractor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final byte TICKS_UNTIL_ACTIVATING = 60;
    public static final byte WORKING_TICKS = 20;
    public static final float DAMAGE_FIELD_COEF = 0.4f;
    private AABB damageField;

    public SparkExtractor(EntityType type, Level lvl) {
        super(type, lvl);
        this.m_20242_(true);
        this.m_20334_(0.0, 0.04f, 0.0);
        this.damageField = this.m_20191_();
    }

    public SparkExtractor(Level lvl, boolean dropAfterUsing) {
        this(ModEntities.SPARK_EXTRACTOR.get(), lvl);
        this.setDropAfterUsing(dropAfterUsing);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.95, 1.0));
        Level lvl = this.m_9236_();
        int ticksLeft = this.getActivatingTicks();
        this.setActivatingTicks(--ticksLeft);
        if (ticksLeft > 20) {
            return;
        }
        this.damageField = this.m_20191_().m_82400_((double)((float)(20 - ticksLeft) * 0.4f));
        if (!lvl.f_46443_) {
            lvl.m_6249_((Entity)this, this.damageField, entity -> {
                if (!TFPData.serverInstance(Objects.requireNonNull(lvl.m_7654_())).isTransformer((Entity)entity)) return false;
                if (!entity.m_6084_()) return false;
                if (!(entity instanceof Player)) return true;
                Player player = (Player)entity;
                if (player.m_150110_().f_35934_) return false;
                return true;
            }).forEach(Entity::m_6074_);
            if (ticksLeft <= 0) {
                if (this.shouldDropAfterUsing()) {
                    this.m_19998_((ItemLike)ModItems.SPARK_EXTRACTOR.get());
                }
                this.m_146870_();
            }
        }
    }

    public AABB getDamageField() {
        return this.damageField;
    }

    public ItemStack m_142340_() {
        return ModItems.SPARK_EXTRACTOR.get().m_7968_();
    }

    public boolean m_6000_(double x, double y, double z) {
        return Vec3.m_82512_((Vec3i)this.m_20183_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)new Vec3(x, 0.0, z), 32.0);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ACTIVATING_TICKS_ID, (Object)60);
        this.f_19804_.m_135372_(DATA_DROP_AFTER_USING_ID, (Object)false);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setActivatingTicks(tag.m_128445_("ActivatingTicks"));
        this.setDropAfterUsing(tag.m_128471_("DropAfterUsing"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128344_("ActivatingTicks", this.getActivatingTicks());
        tag.m_128379_("DropAfterUsing", this.shouldDropAfterUsing());
    }

    public byte getActivatingTicks() {
        return (Byte)this.f_19804_.m_135370_(DATA_ACTIVATING_TICKS_ID);
    }

    public void setActivatingTicks(int value) {
        this.f_19804_.m_135381_(DATA_ACTIVATING_TICKS_ID, (Object)((byte)value));
    }

    public boolean shouldDropAfterUsing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DROP_AFTER_USING_ID);
    }

    public void setDropAfterUsing(boolean value) {
        this.f_19804_.m_135381_(DATA_DROP_AFTER_USING_ID, (Object)value);
    }
}

