/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.inventory;

import bnb.tfp.blockentity.EnergonConverterBlockEntity;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModMenus;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonConverterMenu
extends AbstractContainerMenu {
    protected final Container container;
    private final ContainerData data;

    public EnergonConverterMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(2));
    }

    public EnergonConverterMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super(ModMenus.ENERGON_CONVERTER.get(), containerId);
        this.container = container;
        this.data = data;
        this.m_38897_(new ConverterResultSlot(playerInventory.f_35978_, 0, 148, 30));
        this.m_38897_(new IngredientSlot(container, 1, Items.f_42616_, 17, 17));
        this.m_38897_(new IngredientSlot(container, 2, Items.f_42593_, 17, 43));
        this.m_38897_(new IngredientSlot(container, 3, 39, 17));
        this.m_38897_(new IngredientSlot(container, 4, 39, 43));
        this.m_38897_(new IngredientSlot(container, 5, 61, 17));
        this.m_38897_(new IngredientSlot(container, 6, 61, 43));
        this.m_38897_(new IngredientSlot(container, 7, ModItems.SYRINGE.get(), 94, 30));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player player, int i) {
        ItemStack output = ItemStack.f_41583_;
        Slot slot = this.m_38853_(i);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (!(i < 8 ? this.m_38903_(stack, 8, this.f_38839_.size(), true) : this.m_38903_(stack, 0, 8, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_269060_(stack);
            } else {
                slot.m_6654_();
            }
        }
        return output;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public int getEnergy() {
        return this.data.m_6413_(0);
    }

    public int getXpPoints() {
        return this.data.m_6413_(1);
    }

    public void setXpPoints(int xp) {
        this.data.m_8050_(1, xp);
    }

    class ConverterResultSlot
    extends Slot {
        private final Player player;

        public ConverterResultSlot(Player player, int slot, int x, int y) {
            super(EnergonConverterMenu.this.container, slot, x, y);
            this.player = player;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_269060_(ItemStack stack) {
            super.m_269060_(stack);
            this.player.m_6756_(EnergonConverterMenu.this.getXpPoints());
            EnergonConverterMenu.this.setXpPoints(0);
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            player.m_6756_(EnergonConverterMenu.this.getXpPoints());
            EnergonConverterMenu.this.setXpPoints(0);
        }
    }

    static class IngredientSlot
    extends Slot {
        private final Set<Item> ingredients;

        public IngredientSlot(Container container, int slot, Set<Item> ingredients, int x, int y) {
            super(container, slot, x, y);
            this.ingredients = ingredients;
        }

        public IngredientSlot(Container container, int slot, Item ingredient, int x, int y) {
            this(container, slot, Set.of(ingredient), x, y);
        }

        public IngredientSlot(Container container, int slot, int x, int y) {
            this(container, slot, EnergonConverterBlockEntity.INGREDIENT_VALUES.get(slot - 3).keySet(), x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.ingredients.contains(stack.m_41720_());
        }
    }
}

