/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.item;

import bnb.tfp.TFPData;
import bnb.tfp.blockentity.EnergonTankBlockEntity;
import bnb.tfp.network.ClientboundDarkEnergonExposurePacket;
import bnb.tfp.network.ClientboundVampireTerrorconPacket;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonShardItem
extends Item {
    protected EnergonShardItem(Item.Properties properties) {
        super(properties);
    }

    public static EnergonShardItem normal() {
        EnergonShardItem output = new EnergonShardItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(12.8f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 200), 1.0f).m_38765_().m_38767_())){

            public ItemStack m_5922_(ItemStack stack, Level lvl, LivingEntity entity) {
                if (!lvl.f_46443_ && entity instanceof Player) {
                    Player player = (Player)entity;
                    PlayableTransformer transformer = TFPData.getInstance(lvl).getTransformer(player);
                    int darken = transformer.getDarkEnergonExposure();
                    if (darken != 0) {
                        if (darken > 0) {
                            transformer.setDarkEnergonExposure(darken > 2 ? 2 : --darken);
                        } else {
                            transformer.setDarkEnergonExposure(darken < -2 ? -2 : ++darken);
                        }
                        ModNetworking.sendToEveryone(lvl.m_7654_(), new ClientboundDarkEnergonExposurePacket(entity.m_20148_(), transformer));
                    }
                }
                return super.m_5922_(stack, lvl, entity);
            }
        };
        DispenserBlock.m_52672_((ItemLike)output, (src, stack) -> {
            EnergonTankBlockEntity tank;
            BlockPos pos = src.m_7961_().m_121945_((Direction)src.m_6414_().m_61143_((Property)DirectionalBlock.f_52588_));
            ServerLevel lvl = src.m_7727_();
            BlockEntity patt2989$temp = lvl.m_7702_(pos);
            if (patt2989$temp instanceof EnergonTankBlockEntity && (tank = (EnergonTankBlockEntity)patt2989$temp).fill((Level)lvl, pos, lvl.m_8055_(pos))) {
                stack.m_41774_(1);
            }
            return stack;
        });
        return output;
    }

    public static EnergonShardItem red() {
        return new EnergonShardItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(12.8f).m_38762_(new MobEffectInstance(MobEffects.f_19596_, 600, 2), 1.0f).m_38765_().m_38767_()));
    }

    public static EnergonShardItem toxen() {
        return new EnergonShardItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(12.8f).m_38762_(new MobEffectInstance(MobEffects.f_19604_, 900, 2), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19597_, 600, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_216964_, 900), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19613_, 600, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19615_, 300, 2), 1.0f).m_38765_().m_38767_())){

            public void m_6883_(ItemStack stack, Level lvl, Entity entity, int slot, boolean selected) {
                super.m_6883_(stack, lvl, entity, slot, selected);
                2.toxenPoisonEntity(entity);
            }
        };
    }

    public static EnergonShardItem dark() {
        return new EnergonShardItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(12.8f).m_38765_().m_38762_(new MobEffectInstance(MobEffects.f_19600_, 200), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19596_, 200), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19598_, 200), 1.0f).m_38767_())){

            public ItemStack m_5922_(ItemStack stack, Level lvl, LivingEntity entity) {
                Player player;
                PlayableTransformer transformer;
                if (!lvl.f_46443_ && entity instanceof Player && (transformer = TFPData.getTransformerStatic(player = (Player)entity)) != null) {
                    if (!transformer.onDarkEnergon()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200));
                    }
                    if (transformer.onSynthEn()) {
                        transformer.setVampire(true);
                        transformer.setDarkEnergonExposure(0);
                        ModNetworking.sendToEveryone(lvl.m_7654_(), new ClientboundVampireTerrorconPacket(player.m_20148_(), true));
                    } else {
                        transformer.addDarkEnergonExposure(1);
                    }
                    ModNetworking.sendToEveryone(lvl.m_7654_(), new ClientboundDarkEnergonExposurePacket(player.m_20148_(), transformer));
                }
                return super.m_5922_(stack, lvl, entity);
            }
        };
    }

    public static EnergonShardItem synthen() {
        return new EnergonShardItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(9).m_38758_(12.8f).m_38765_().m_38762_(new MobEffectInstance(MobEffects.f_19600_, 200), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19596_, 200), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19598_, 200), 1.0f).m_38767_()).m_41495_(ModItems.SYRINGE.get())){

            public UseAnim m_6164_(ItemStack stack) {
                return UseAnim.DRINK;
            }

            public SoundEvent m_6023_() {
                return SoundEvents.f_271165_;
            }

            public ItemStack m_5922_(ItemStack stack, Level lvl, LivingEntity entity) {
                Player player;
                PlayableTransformer transformer;
                super.m_5922_(stack, lvl, entity);
                if (!lvl.f_46443_ && entity instanceof Player && (transformer = TFPData.getTransformerStatic(player = (Player)entity)) != null) {
                    if (transformer.onSynthEn()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200));
                    }
                    if (transformer.onDarkEnergon()) {
                        transformer.setVampire(true);
                        transformer.setDarkEnergonExposure(0);
                        ModNetworking.sendToEveryone(lvl.m_7654_(), new ClientboundVampireTerrorconPacket(player.m_20148_(), true));
                    } else {
                        transformer.addDarkEnergonExposure(-1);
                    }
                    ModNetworking.sendToEveryone(lvl.m_7654_(), new ClientboundDarkEnergonExposurePacket(player.m_20148_(), transformer));
                    if (!player.m_150110_().f_35937_) {
                        ItemStack syringe = ModItems.SYRINGE.get().m_7968_();
                        if (stack.m_41619_()) {
                            return syringe;
                        }
                        if (!player.m_36356_(syringe)) {
                            player.m_36176_(syringe, false);
                        }
                    }
                }
                return stack;
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level lvl, Player player, InteractionHand hand) {
        if (lvl.f_46443_ || !TFPData.serverInstance(Objects.requireNonNull(lvl.m_7654_())).isTransformer((Entity)player)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(lvl, player, hand);
    }

    public static void toxenPoisonEntity(Entity entity) {
        block6: {
            LivingEntity living;
            block7: {
                if (!(entity instanceof LivingEntity)) break block6;
                living = (LivingEntity)entity;
                if (!(living instanceof Player)) break block7;
                Player player = (Player)living;
                if (player.m_150110_().f_35934_) break block6;
            }
            if (TFPData.getInstance(entity.m_9236_()).isTransformer((Entity)living)) {
                for (MobEffect effect : new MobEffect[]{MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_216964_, MobEffects.f_19613_}) {
                    living.m_7292_(new MobEffectInstance(effect, 20));
                }
                if (!living.m_21023_(MobEffects.f_19615_)) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40));
                }
            }
        }
    }
}

