/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ForgeOfSPItem
extends Item
implements Vanishable {
    public static final UUID KNOCKBACK_UUID = UUID.fromString("424C8D02-C306-4035-88F2-3364E658534B");
    public final ImmutableMultimap<Attribute, AttributeModifier> defaultModifiers;

    protected ForgeOfSPItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 17.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -3.2, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public ForgeOfSPItem() {
        this(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.EPIC));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public int m_8105_(ItemStack stack) {
        return 80;
    }

    public static ArrayListMultimap<Ingredient, Item> getResults() {
        ArrayListMultimap output = ArrayListMultimap.create();
        output.put((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42355_}), (Object)Items.f_42354_);
        output.put((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42695_}), (Object)Items.f_42713_);
        output.putAll((Object)Ingredient.m_204132_((TagKey)ItemTags.f_13168_), List.of(Items.f_42423_, Items.f_42424_, Items.f_42422_, Items.f_42421_, Items.f_42420_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}), List.of(Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_, Items.f_42654_));
        output.putAll((Object)Ingredient.m_204132_((TagKey)ItemTags.f_13165_), List.of(Items.f_42428_, Items.f_42429_, Items.f_42427_, Items.f_42426_, Items.f_42425_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42749_}), List.of(Items.f_42464_, Items.f_42465_, Items.f_42466_, Items.f_42467_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), List.of(Items.f_42386_, Items.f_42387_, Items.f_42385_, Items.f_42384_, Items.f_42383_, Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_, Items.f_42651_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}), List.of(Items.f_42747_, Items.f_42433_, Items.f_42434_, Items.f_42432_, Items.f_42431_, Items.f_42430_, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42652_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}), List.of(Items.f_42391_, Items.f_42392_, Items.f_42390_, Items.f_42389_, Items.f_42388_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42653_));
        output.putAll((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42419_}), List.of(Items.f_42396_, Items.f_42397_, Items.f_42395_, Items.f_42394_, Items.f_42393_, Items.f_42480_, Items.f_42481_, Items.f_42482_, Items.f_42483_));
        output.put((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), (Object)Items.f_42741_);
        return output;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public ItemStack m_5922_(ItemStack stack, Level lvl, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean flag = player.m_150109_().m_36062_() == -1;
            ArrayListMultimap<Ingredient, Item> results = ForgeOfSPItem.getResults();
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stackInSlot = player.m_150109_().m_8020_(i);
                if (flag && stackInSlot.m_41613_() >= 2) continue;
                for (Ingredient ingredient : results.keys()) {
                    if (!ingredient.test(stackInSlot)) continue;
                    player.m_6674_(player.m_7655_());
                    if (!lvl.f_46443_) {
                        List possibleResults = results.get((Object)ingredient);
                        stackInSlot.m_41774_(1);
                        player.m_36356_(new ItemStack((ItemLike)possibleResults.get(player.m_217043_().m_188503_(possibleResults.size()))));
                        lvl.m_5594_(null, player.m_20183_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 3.0f, 0.5f + player.m_217043_().m_188501_() * 0.3f);
                        lvl.m_5594_(null, player.m_20183_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 3.0f, 1.0f);
                    }
                    return super.m_5922_(stack, lvl, entity);
                }
            }
        }
        return super.m_5922_(stack, lvl, entity);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockState block = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (block.m_60713_(Blocks.f_50322_) || block.m_60713_(Blocks.f_50323_) || block.m_60713_(Blocks.f_50324_)) {
            Player player = ctx.m_43723_();
            if (player == null) {
                return InteractionResult.PASS;
            }
            player.m_6672_(player.m_7655_());
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

