/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.item;

import bnb.tfp.entity.WheeljackGrenade;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WheeljackGrenadeItem
extends Item {
    public WheeljackGrenadeItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (src, stack) -> {
            WheeljackGrenade grenade = new WheeljackGrenade((Level)src.m_7727_(), null, 200);
            Direction direction = (Direction)src.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            WheeljackGrenadeItem.placeGrenadeOnBlock(grenade, src.m_7961_(), direction);
            if (!src.m_7727_().m_45786_((Entity)grenade) || !src.m_7727_().m_45784_((Entity)grenade)) {
                return stack;
            }
            grenade.m_20256_(Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(0.75));
            src.m_7727_().m_7967_((Entity)grenade);
            return WheeljackGrenadeItem.onUseGrenade(stack, null);
        });
    }

    public WheeljackGrenadeItem() {
        this(new Item.Properties().m_41487_(16));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (Block.m_49863_((LevelReader)context.m_43725_(), (BlockPos)context.m_8083_(), (Direction)context.m_43719_())) {
            ItemStack stack = context.m_43722_();
            WheeljackGrenade grenade = new WheeljackGrenade(context.m_43725_(), (Entity)context.m_43723_(), WheeljackGrenadeItem.getDetonationTime(stack));
            Direction direction = context.m_43719_();
            WheeljackGrenadeItem.placeGrenadeOnBlock(grenade, context.m_8083_(), direction);
            if (context.m_43725_().m_45786_((Entity)grenade) && context.m_43725_().m_45784_((Entity)grenade)) {
                if (direction.m_122434_() == Direction.Axis.Y) {
                    grenade.m_146922_(context.m_7074_());
                }
                grenade.m_20242_(true);
                context.m_43725_().m_7967_((Entity)grenade);
                WheeljackGrenadeItem.onUseGrenade(stack, (Entity)context.m_43723_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (WheeljackGrenadeItem.getDetonationTime(stack) < 0) {
            ItemStack stack1 = player.m_150110_().f_35937_ ? ItemStack.f_41583_ : stack.m_41620_(stack.m_41613_() - 1);
            WheeljackGrenadeItem.setDetonationTime(stack, (short)200);
            if (!player.m_36356_(stack1)) {
                player.m_36176_(stack1, false);
            }
        } else {
            player.m_6672_(usedHand);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        super.m_5551_(stack, level, livingEntity, timeCharged);
        RandomSource random = livingEntity.m_217043_();
        Vec3 vec3 = livingEntity.m_20154_().m_82520_(random.m_216328_(0.0, 0.1), random.m_216328_(0.0, 0.1), random.m_216328_(0.0, 0.1)).m_82490_(Math.min(0.25 + (double)(this.m_8105_(stack) - timeCharged) * 0.0375, 1.0));
        WheeljackGrenade grenade = new WheeljackGrenade(level, (Entity)livingEntity, WheeljackGrenadeItem.getDetonationTime(stack));
        grenade.setDetonationTime(WheeljackGrenadeItem.getDetonationTime(stack));
        grenade.m_146884_(livingEntity.m_146892_().m_82549_(vec3));
        grenade.m_20256_(vec3);
        grenade.m_146922_(livingEntity.m_146908_());
        level.m_7967_((Entity)grenade);
        WheeljackGrenadeItem.onUseGrenade(stack, (Entity)livingEntity);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        short detonationTime = WheeljackGrenadeItem.getDetonationTime(stack);
        detonationTime = (short)(detonationTime - 1);
        if (detonationTime == 0) {
            WheeljackGrenadeItem.onUseGrenade(stack, entity);
            if (!level.f_46443_) {
                level.m_254877_(null, entity.m_269291_().m_269036_(entity, entity), null, entity.m_20185_(), entity.m_20186_() + 0.75, entity.m_20189_(), 3.0f, false, Level.ExplosionInteraction.TNT);
            }
        } else if (detonationTime > 0) {
            WheeljackGrenadeItem.setDetonationTime(stack, detonationTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ItemStack onUseGrenade(ItemStack stack, @Nullable Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                WheeljackGrenadeItem.setDetonationTime(stack, (short)-1);
                return stack;
            }
        }
        stack.m_41774_(1);
        return stack;
    }

    private static void placeGrenadeOnBlock(WheeljackGrenade grenade, BlockPos pos, Direction direction) {
        switch (direction) {
            case UP: {
                grenade.m_146884_(pos.m_252807_().m_82520_(0.0, 0.5, 0.0));
                grenade.m_146926_(-90.0f);
                break;
            }
            case DOWN: {
                grenade.m_146884_(pos.m_252807_().m_82520_(0.0, -0.6875, 0.0));
                grenade.m_146926_(90.0f);
                break;
            }
            default: {
                grenade.m_146884_(pos.m_252807_().m_82520_(0.0, -0.09375, 0.0).m_231075_(direction, 0.59375));
                grenade.m_146922_(direction.m_122435_());
            }
        }
    }

    public static short getDetonationTime(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_("DetonationTime") ? tag.m_128448_("DetonationTime") : (short)-1;
    }

    public static void setDetonationTime(ItemStack stack, short detonationTime) {
        stack.m_41784_().m_128376_("DetonationTime", detonationTime);
    }
}

