/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.levelgen.feature;

import bnb.tfp.block.EnergonCrystalBlock;
import bnb.tfp.levelgen.feature.configuration.EnergonDepositConfiguration;
import bnb.tfp.reg.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonDepositFeature
extends Feature<EnergonDepositConfiguration> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();
    private static final BlockState BUDDING = ModBlocks.BUDDING_ENERGON.get().m_49966_();
    private static final BlockState CYBERMATTER = ModBlocks.CYBERMATTER.get().m_49966_();
    private static final Direction[] DIRECTIONS = Direction.values();

    public EnergonDepositFeature(Codec<EnergonDepositConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<EnergonDepositConfiguration> ctx) {
        BlockPos origin;
        WorldGenLevel lvl = ctx.m_159774_();
        if (lvl.m_151570_(origin = ctx.m_159777_())) {
            return false;
        }
        EnergonDepositConfiguration config = (EnergonDepositConfiguration)ctx.m_159778_();
        RandomSource random = ctx.m_225041_();
        float radius = config.segmentRadius().m_214084_(random);
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>();
        for (int i = config.segmentsAmount().m_214085_(random); i > 0; --i) {
            centers.add(new BlockPos((int)random.m_216328_((double)origin.m_123341_(), (double)(radius * 2.0f - 2.0f)), (int)random.m_216328_((double)origin.m_123342_(), (double)(radius * 2.0f - 2.0f)), (int)random.m_216328_((double)origin.m_123343_(), (double)(radius * 2.0f - 2.0f))));
        }
        boolean[] impossibleToPlace = new boolean[]{false, true};
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius + 1.0f, (pos, distance) -> {
            if (impossibleToPlace[0]) {
                return;
            }
            BlockState state = lvl.m_8055_(pos);
            if (!state.m_60819_().m_76178_()) {
                impossibleToPlace[0] = true;
            } else if (!state.m_60795_()) {
                impossibleToPlace[1] = false;
            }
        });
        if (impossibleToPlace[0] || impossibleToPlace[1]) {
            return false;
        }
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius, (pos, distance) -> lvl.m_7731_(pos, AIR, 3));
        float f0 = config.buddingEnergonChance();
        boolean b0 = config.buddingEnergonChance() > 0.0f;
        float f1 = f0 + config.cybermatterChance();
        boolean b1 = config.cybermatterChance() > 0.0f;
        float f2 = f1 + config.crystalChance();
        BlockStateProvider crystalProvider = config.crystalProvider();
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius + 1.0f, (pos, distance) -> {
            block5: {
                float f3;
                block6: {
                    block4: {
                        if (distance < (double)radius || lvl.m_151570_(pos)) {
                            return;
                        }
                        BlockState state = lvl.m_8055_(pos);
                        if (state.m_60795_() || state.m_204336_(ModBlocks.ENERGONS)) {
                            return;
                        }
                        f3 = random.m_188501_();
                        if (!b0 || !(f3 < f0)) break block4;
                        this.m_5974_((LevelWriter)lvl, (BlockPos)pos, BUDDING);
                        for (Direction direction : DIRECTIONS) {
                            if (!(random.m_188501_() < f2)) continue;
                            EnergonCrystalBlock.tryPlaceOnBLock(crystalProvider.m_213972_(random, pos), lvl, pos, direction, random);
                        }
                        break block5;
                    }
                    if (!b1 || !(f3 < f1)) break block6;
                    this.m_5974_((LevelWriter)lvl, (BlockPos)pos, CYBERMATTER);
                    break block5;
                }
                if (!(f3 < f2)) break block5;
                for (Direction direction : Direction.m_235667_((RandomSource)random)) {
                    if (!EnergonCrystalBlock.tryPlaceOnBLock(crystalProvider.m_213972_(random, pos), lvl, pos, direction, random)) continue;
                    return;
                }
            }
        });
        return true;
    }

    private static void applyToAllBlocksCloseEnough(List<BlockPos> centers, float radius, BiConsumer<BlockPos, Double> action) {
        for (BlockPos pos : centers) {
            Vec3 center = pos.m_252807_();
            int intRadius = (int)radius;
            for (int x = pos.m_123341_() - intRadius; x <= pos.m_123341_() + intRadius; ++x) {
                for (int y = pos.m_123342_() - intRadius; y <= pos.m_123342_() + intRadius; ++y) {
                    for (int z = pos.m_123343_() - intRadius; z <= pos.m_123343_() + intRadius; ++z) {
                        BlockPos pos1 = new BlockPos(x, y, z);
                        double distance = center.m_82554_(pos1.m_252807_());
                        if (!(distance <= (double)radius)) continue;
                        action.accept(pos1, distance);
                    }
                }
            }
        }
    }
}

