/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.mixin;

import bnb.tfp.TFPData;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity {
    protected MixinPlayer(EntityType<? extends LivingEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        Player self = (Player)this;
        TFPData tfpData = TFPData.getInstance(this.m_9236_());
        PlayableTransformer transformer = tfpData.getTransformer(self);
        if (transformer == null) {
            return;
        }
        transformer.tick(self);
        transformer.tryUpdatePassengers(self);
        if (transformer.isDirty()) {
            tfpData.m_77762_();
            transformer.setDirty(false);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        TFPData tfpData = TFPData.getInstance(this.m_9236_());
        PlayableTransformer transformer = tfpData.getTransformer((Player)this);
        if (transformer != null && transformer.isTransformed() && this.m_20197_().size() < transformer.getPassengersLimit() && !tfpData.isTransformer((Entity)player)) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public boolean m_142535_(float $$0, float $$1, DamageSource $$2) {
        return !TFPData.isTransformerStatic((Entity)((Player)this)) && super.m_142535_($$0, $$1, $$2);
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, cancellable=true)
    public void preAttack(Entity entity, CallbackInfo ci) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        if (transformer != null && transformer.beforeHit(self, entity)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"attack"})
    public void postAttack(Entity entity, CallbackInfo ci) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        if (transformer != null) {
            transformer.onHit(self, entity);
        }
    }

    public void m_6674_(InteractionHand hand) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        if (transformer != null) {
            transformer.swing(self);
        }
        super.m_6674_(hand);
    }

    protected float m_6118_() {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        return transformer != null ? super.m_6118_() * transformer.getJumpPowerCoef(self) : super.m_6118_();
    }

    @Inject(at={@At(value="HEAD")}, method={"getDimensions"}, cancellable=true)
    public void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        if (transformer != null) {
            cir.setReturnValue((Object)transformer.makeDimensions(self, pose));
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"travel"}, cancellable=true)
    public void travel(Vec3 input, CallbackInfo ci) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        if (transformer == null || transformer.getVehicleType().shouldTravelNormally(transformer, self)) {
            return;
        }
        VehicleType vehicle = transformer.getVehicleType();
        double x = self.m_20185_();
        double y = self.m_20186_();
        double z = self.m_20189_();
        if (this.m_6109_()) {
            vehicle.travel(transformer, self, input, this.m_20099_());
        }
        this.m_267651_(false);
        vehicle.checkMovementStatistics(transformer, self, self.m_20185_() - x, self.m_20186_() - y, self.m_20189_() - z);
        ci.cancel();
    }

    public boolean m_6040_() {
        return TFPData.isTransformerStatic((Entity)this) || super.m_6040_();
    }

    protected float m_5632_(float yRot, float movement) {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        return transformer != null ? transformer.getVehicleType().tickHeadTurn(self, transformer, yRot, movement) : super.m_5632_(yRot, movement);
    }

    public float m_274421_() {
        Player self = (Player)this;
        PlayableTransformer transformer = TFPData.getTransformerStatic(self);
        return transformer != null ? transformer.getMaxUpStep(self) : super.m_274421_();
    }
}

