/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.network;

import bnb.tfp.TFPData;
import bnb.tfp.network.ModClientboundPacket;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientboundSetTransformerPacket
implements ModClientboundPacket {
    public final UUID uuid;
    @Nullable
    public final PlayableTransformer transformer;

    public ClientboundSetTransformerPacket(UUID uuid, PlayableTransformer transformer) {
        this.uuid = uuid;
        this.transformer = transformer;
    }

    public ClientboundSetTransformerPacket(UUID uuid) {
        this.uuid = uuid;
        this.transformer = null;
    }

    public ClientboundSetTransformerPacket(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.transformer = buf.readBoolean() ? PlayableTransformer.fromNbt(Objects.requireNonNull(buf.m_130260_())) : null;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        if (this.transformer != null) {
            buf.writeBoolean(true);
            CompoundTag tag = new CompoundTag();
            this.transformer.save(tag);
            buf.m_130079_(tag);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(Minecraft mc) {
        TFPData tfpData = TFPData.clientInstance();
        Player player = Objects.requireNonNull(mc.f_91073_).m_46003_(this.uuid);
        if (this.transformer != null) {
            tfpData.setTransformer(this.uuid, this.transformer);
            this.transformer.resetAnimStates(player);
        } else {
            tfpData.clearTransformer(this.uuid);
        }
        if (player != null) {
            player.m_6210_();
        }
    }
}

