/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.network;

import bnb.tfp.TFPData;
import bnb.tfp.client.ModKeys;
import bnb.tfp.network.ModClientboundPacket;
import bnb.tfp.network.TransformerActionPacket;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientboundTransformerActionPacket
implements ModClientboundPacket {
    public final UUID playerUUID;
    public final TransformerActionPacket.Action action;

    public ClientboundTransformerActionPacket(UUID uuid, TransformerActionPacket.Action action) {
        this.playerUUID = uuid;
        this.action = action;
    }

    public ClientboundTransformerActionPacket(FriendlyByteBuf buf) {
        this(buf.m_130259_(), (TransformerActionPacket.Action)buf.m_130066_(TransformerActionPacket.Action.class));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.m_130068_((Enum)this.action);
    }

    @Override
    public void handle(Minecraft mc) {
        PlayableTransformer transformer = TFPData.clientInstance().getTransformer(this.playerUUID);
        if (transformer == null) {
            return;
        }
        Level lvl = (Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        Player player = lvl.m_46003_(this.playerUUID);
        if (player != null && player.m_7578_()) {
            ModKeys.actionCooldown(this.action);
        }
        switch (this.action) {
            case TRANSFORM: {
                if (!transformer.transform(lvl, player) || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || player == null || !player.m_7578_() || !transformer.getF5Vehicle()) break;
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
                break;
            }
            case WEAPON: {
                transformer.equipWeapon(player, !transformer.isUsingWeapon());
                break;
            }
            case GUN: {
                transformer.equipGun(player, !transformer.isGunLoaded());
                break;
            }
            case SPECIAL: {
                transformer.useSpecial(lvl, player);
            }
        }
    }
}

