/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.network;

import bnb.tfp.TFPData;
import bnb.tfp.network.ClientboundTransformerActionPacket;
import bnb.tfp.network.ModServerboundPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerSounds;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TransformerActionPacket
implements ModServerboundPacket {
    private final Action action;

    public TransformerActionPacket(Action action) {
        this.action = action;
    }

    public TransformerActionPacket(FriendlyByteBuf buf) {
        this((Action)buf.m_130066_(Action.class));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
    }

    @Override
    public void handle(ServerPlayer sender) {
        ServerLevel lvl = sender.m_284548_();
        TFPData tfpData = TFPData.serverInstance(Objects.requireNonNull(sender.m_20194_()));
        PlayableTransformer transformer = tfpData.getTransformer((Player)sender);
        if (transformer == null) {
            return;
        }
        Optional<SoundEvent> optional = Optional.empty();
        switch (this.action) {
            case TRANSFORM: {
                transformer.transform((Level)lvl, (Player)sender);
                break;
            }
            case WEAPON: {
                boolean value = !transformer.isUsingWeapon();
                optional = transformer.getSounds().getSound(value ? TransformerSounds.Sound.EQUIP_WEAPON : TransformerSounds.Sound.HIDE_WEAPON);
                transformer.equipWeapon((Player)sender, value);
                break;
            }
            case GUN: {
                boolean value = !transformer.isGunLoaded();
                optional = transformer.getSounds().getSound(value ? TransformerSounds.Sound.EQUIP_GUN : TransformerSounds.Sound.HIDE_GUN);
                transformer.equipGun((Player)sender, value);
                break;
            }
            case SPECIAL: {
                transformer.useSpecial((Level)lvl, (Player)sender);
            }
        }
        optional.ifPresent(soundEvent -> sender.m_9236_().m_6269_(null, (Entity)sender, soundEvent, SoundSource.PLAYERS, 1.0f, 0.9f + sender.m_217043_().m_188501_() * 0.2f));
        ModNetworking.sendToEveryone(sender.f_8924_, new ClientboundTransformerActionPacket(sender.m_20148_(), this.action));
    }

    public static enum Action {
        TRANSFORM,
        WEAPON,
        GUN,
        SPECIAL;

    }
}

