/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.reg;

import bnb.tfp.blockentity.EnergonConverterBlockEntity;
import bnb.tfp.blockentity.EnergonTankBlockEntity;
import bnb.tfp.blockentity.GroundBridgeControlBlockEntity;
import bnb.tfp.blockentity.JafjayBlockEntity;
import bnb.tfp.blockentity.LaptopBlockEntity;
import bnb.tfp.blockentity.ScrapletInfestedBlockEntity;
import bnb.tfp.platform.Services;
import bnb.tfp.reg.ModBlocks;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ModBlockEntities {
    public static final Supplier<BlockEntityType<EnergonTankBlockEntity>> ENERGON_TANK;
    public static final Supplier<BlockEntityType<GroundBridgeControlBlockEntity>> GROUND_BRIDGE_CONTROL;
    public static final Supplier<BlockEntityType<LaptopBlockEntity>> LAPTOP;
    public static final Supplier<BlockEntityType<JafjayBlockEntity>> JAFJAY_BLOCK;
    public static final Supplier<BlockEntityType<EnergonConverterBlockEntity>> ENERGON_CONVERTER;
    public static final Supplier<BlockEntityType<ScrapletInfestedBlockEntity>> SCRAPLET_INFESTED;

    public static void init() {
    }

    static {
        Register register = Services.REGISTERS.blockEntities();
        ENERGON_TANK = register.register("energon_tank", EnergonTankBlockEntity::new, Set.of(ModBlocks.ENERGON_TANK));
        GROUND_BRIDGE_CONTROL = register.register("ground_bridge_control", GroundBridgeControlBlockEntity::new, Set.of(ModBlocks.GROUND_BRIDGE_CONTROL));
        LAPTOP = register.register("laptop", LaptopBlockEntity::new, Set.of(ModBlocks.LAPTOP));
        JAFJAY_BLOCK = register.register("jafjay_block", JafjayBlockEntity::new, Set.of(ModBlocks.JAFJAY_BLOCK));
        ENERGON_CONVERTER = register.register("energon_converter", EnergonConverterBlockEntity::new, Set.of(ModBlocks.ENERGON_CONVERTER));
        SCRAPLET_INFESTED = register.register("scraplet_infested", ScrapletInfestedBlockEntity::new, Set.copyOf(ModBlocks.SCRAPLET_INFESTED_BLOCKS.values()));
    }

    @FunctionalInterface
    public static interface Register {
        public <T extends BlockEntity> Supplier<BlockEntityType<T>> register(ResourceLocation var1, BiFunction<BlockPos, BlockState, T> var2, Set<Supplier<? extends Block>> var3);

        default public <T extends BlockEntity> Supplier<BlockEntityType<T>> register(String name, BiFunction<BlockPos, BlockState, T> factory, Set<Supplier<? extends Block>> blocks) {
            return this.register(new ResourceLocation("tfp", name), factory, blocks);
        }
    }
}

