/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.reg;

import bnb.tfp.item.EnergonShardItem;
import bnb.tfp.item.ForgeOfSPItem;
import bnb.tfp.item.PolarityGauntletItem;
import bnb.tfp.item.SparkExtractorItem;
import bnb.tfp.item.TransformerArmorItem;
import bnb.tfp.item.WheeljackGrenadeItem;
import bnb.tfp.item.WhiteHatItem;
import bnb.tfp.platform.Services;
import bnb.tfp.reg.ModBlocks;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModRegisters;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModItems {
    public static final Item.Properties devPlushyProperties = new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC);
    public static final Supplier<Item> SPARK_EXTRACTOR;
    public static final Supplier<ForgeOfSPItem> FORGE_OF_SP;
    public static final Supplier<PolarityGauntletItem> POLARITY_GAUNTLET;
    public static final Supplier<WheeljackGrenadeItem> WHEELJACK_GRENADE;
    public static final Supplier<EnergonShardItem> ENERGON_SHARD;
    public static final Supplier<EnergonShardItem> RED_ENERGON_SHARD;
    public static final Supplier<EnergonShardItem> TOXEN_SHARD;
    public static final Supplier<EnergonShardItem> DARK_ENERGON_SHARD;
    public static final Supplier<BlockItem> ENERGON_CRYSTAL;
    public static final Supplier<BlockItem> RED_ENERGON_CRYSTAL;
    public static final Supplier<BlockItem> DARK_ENERGON_CRYSTAL;
    public static final Supplier<BlockItem> TOXEN;
    public static final Supplier<BlockItem> ENERGON_BLOCK;
    public static final Supplier<BlockItem> BUDDING_ENERGON;
    public static final Supplier<BlockItem> RED_ENERGON_BLOCK;
    public static final Supplier<BlockItem> TOXEN_BLOCK;
    public static final Supplier<BlockItem> DARK_ENERGON_BLOCK;
    public static final Supplier<Item> SYRINGE;
    public static final Supplier<EnergonShardItem> SYNTH_EN;
    public static final Supplier<BlockItem> ENERGON_CABLE;
    public static final Supplier<BlockItem> ENERGON_TANK;
    public static final Supplier<BlockItem> GROUND_BRIDGE_CONTROL;
    public static final Supplier<BlockItem> SIGNAL_NAVIGATOR;
    public static final Supplier<BlockItem> LAPTOP;
    public static final Supplier<BlockItem> ENERGON_CONVERTER;
    public static final Supplier<BlockItem> MAIN_CONTROL_PANEL;
    public static final Supplier<BlockItem> HOLOGRAM_TILE_BLOCK;
    public static final Supplier<BlockItem> CYBERMATTER;
    public static final Set<Supplier<BlockItem>> SCRAPLET_INFESTED_BLOCKS;
    public static final TransformerArmor AUTOBOT_ARMOR;
    public static final TransformerArmor DECEPTICON_ARMOR;
    public static final Supplier<Item> SCRAPLET_SPAWN_EGG;
    public static final Supplier<BlockItem> SANTINO_PLUSHY;
    public static final Supplier<BlockItem> AIMYX_PLUSHY;
    public static final Supplier<BlockItem> JAFJAY_BLOCK;
    public static final Supplier<BlockItem> OVERKILL_PLUSHY;
    public static final Supplier<WhiteHatItem> WHITE_HAT;
    public static final Supplier<WhiteHatItem> BLACK_HAT;
    public static final TagKey<Item> TRANSFORMERS_CAN_EAT;
    public static final TagKey<Item> MAGNETIC;
    public static final TagKey<Item> ENERGON_CRAFTING_MATERIALS;
    public static final TagKey<Item> SCRAPLETS_EAT;

    public static void init() {
    }

    public static CreativeModeTab buildTab(CreativeModeTab.Builder builder) {
        return builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.tfp")).m_257737_(() -> ENERGON_CRYSTAL.get().m_7968_()).m_257501_((params, output) -> {
            output.m_246326_((ItemLike)ENERGON_SHARD.get());
            output.m_246326_((ItemLike)RED_ENERGON_SHARD.get());
            output.m_246326_((ItemLike)TOXEN_SHARD.get());
            output.m_246326_((ItemLike)DARK_ENERGON_SHARD.get());
            output.m_246326_((ItemLike)SYRINGE.get());
            output.m_246326_((ItemLike)SYNTH_EN.get());
            output.m_246326_((ItemLike)ENERGON_CRYSTAL.get());
            output.m_246326_((ItemLike)RED_ENERGON_CRYSTAL.get());
            output.m_246326_((ItemLike)DARK_ENERGON_CRYSTAL.get());
            output.m_246326_((ItemLike)TOXEN.get());
            output.m_246326_((ItemLike)ENERGON_BLOCK.get());
            output.m_246326_((ItemLike)BUDDING_ENERGON.get());
            output.m_246326_((ItemLike)RED_ENERGON_BLOCK.get());
            output.m_246326_((ItemLike)TOXEN_BLOCK.get());
            output.m_246326_((ItemLike)DARK_ENERGON_BLOCK.get());
            output.m_246326_((ItemLike)ENERGON_CABLE.get());
            output.m_246326_((ItemLike)ENERGON_TANK.get());
            output.m_246326_((ItemLike)GROUND_BRIDGE_CONTROL.get());
            output.m_246326_((ItemLike)SIGNAL_NAVIGATOR.get());
            output.m_246326_((ItemLike)LAPTOP.get());
            output.m_246326_((ItemLike)MAIN_CONTROL_PANEL.get());
            output.m_246326_((ItemLike)ENERGON_CONVERTER.get());
            output.m_246326_((ItemLike)HOLOGRAM_TILE_BLOCK.get());
            output.m_246326_((ItemLike)CYBERMATTER.get());
            SCRAPLET_INFESTED_BLOCKS.forEach(item -> output.m_246326_((ItemLike)item.get()));
            output.m_246326_((ItemLike)SPARK_EXTRACTOR.get());
            output.m_246326_((ItemLike)FORGE_OF_SP.get());
            output.m_246326_((ItemLike)POLARITY_GAUNTLET.get());
            output.m_246326_((ItemLike)WHEELJACK_GRENADE.get());
            output.m_246326_((ItemLike)SCRAPLET_SPAWN_EGG.get());
            output.m_246326_((ItemLike)SANTINO_PLUSHY.get());
            output.m_246326_((ItemLike)AIMYX_PLUSHY.get());
            output.m_246326_((ItemLike)JAFJAY_BLOCK.get());
            output.m_246326_((ItemLike)OVERKILL_PLUSHY.get());
            output.m_246326_((ItemLike)WHITE_HAT.get());
        }).m_257652_();
    }

    private static Supplier<BlockItem> blockItem(Supplier<? extends Block> block, Item.Properties props) {
        return () -> new BlockItem((Block)block.get(), props);
    }

    private static Supplier<BlockItem> blockItem(Supplier<? extends Block> block) {
        return ModItems.blockItem(block, new Item.Properties());
    }

    public static Supplier<BlockItem> toxen(Supplier<? extends Block> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties()){

            public void m_6883_(ItemStack stack, Level lvl, Entity entity, int slot, boolean selected) {
                super.m_6883_(stack, lvl, entity, slot, selected);
                EnergonShardItem.toxenPoisonEntity(entity);
            }
        };
    }

    private static TagKey<Item> tag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("tfp", name));
    }

    private static /* synthetic */ BlockItem lambda$static$1(Supplier supplier) {
        return new BlockItem((Block)supplier.get(), new Item.Properties());
    }

    static {
        ModRegisters.OfFactory<Item> register = Services.REGISTERS.items();
        ENERGON_CONVERTER = register.register("energon_converter", ModItems.blockItem(ModBlocks.ENERGON_CONVERTER));
        MAIN_CONTROL_PANEL = register.register("main_control_panel", ModItems.blockItem(ModBlocks.MAIN_CONTROL_PANEL));
        HOLOGRAM_TILE_BLOCK = register.register("hologram_tile_block", ModItems.blockItem(ModBlocks.HOLOGRAM_TILE_BLOCK));
        ENERGON_SHARD = register.register("energon_shard", EnergonShardItem::normal);
        RED_ENERGON_SHARD = register.register("red_energon_shard", EnergonShardItem::red);
        TOXEN_SHARD = register.register("toxen_shard", EnergonShardItem::toxen);
        DARK_ENERGON_SHARD = register.register("dark_energon_shard", EnergonShardItem::dark);
        ENERGON_CRYSTAL = register.register("energon_crystal", ModItems.blockItem(ModBlocks.ENERGON_CRYSTAL));
        RED_ENERGON_CRYSTAL = register.register("red_energon_crystal", ModItems.blockItem(ModBlocks.RED_ENERGON_CRYSTAL));
        DARK_ENERGON_CRYSTAL = register.register("dark_energon_crystal", ModItems.blockItem(ModBlocks.DARK_ENERGON_CRYSTAL));
        TOXEN = register.register("toxen", ModItems.toxen(ModBlocks.TOXEN));
        ENERGON_BLOCK = register.register("energon_block", ModItems.blockItem(ModBlocks.ENERGON_BLOCK));
        BUDDING_ENERGON = register.register("budding_energon", ModItems.blockItem(ModBlocks.BUDDING_ENERGON));
        RED_ENERGON_BLOCK = register.register("red_energon_block", ModItems.blockItem(ModBlocks.RED_ENERGON_BLOCK));
        TOXEN_BLOCK = register.register("toxen_block", ModItems.toxen(ModBlocks.TOXEN_BLOCK));
        DARK_ENERGON_BLOCK = register.register("dark_energon_block", ModItems.blockItem(ModBlocks.DARK_ENERGON_BLOCK));
        SYRINGE = register.register("syringe", () -> new Item(new Item.Properties()));
        SYNTH_EN = register.register("synth_en", EnergonShardItem::synthen);
        ENERGON_CABLE = register.register("energon_cable", ModItems.blockItem(ModBlocks.ENERGON_CABLE));
        ENERGON_TANK = register.register("energon_tank", ModItems.blockItem(ModBlocks.ENERGON_TANK));
        GROUND_BRIDGE_CONTROL = register.register("ground_bridge_control", ModItems.blockItem(ModBlocks.GROUND_BRIDGE_CONTROL));
        SIGNAL_NAVIGATOR = register.register("signal_navigator", ModItems.blockItem(ModBlocks.SIGNAL_NAVIGATOR));
        LAPTOP = register.register("laptop", ModItems.blockItem(ModBlocks.LAPTOP));
        CYBERMATTER = register.register("cybermatter", ModItems.blockItem(ModBlocks.CYBERMATTER));
        HashSet set = new HashSet();
        ModBlocks.SCRAPLET_INFESTED_BLOCKS.forEach((block, supplier) -> set.add(register.register("scraplet_infested_" + BuiltInRegistries.f_256975_.m_7981_(block).m_135815_(), () -> ModItems.lambda$static$1((Supplier)supplier))));
        SCRAPLET_INFESTED_BLOCKS = Set.copyOf(set);
        SPARK_EXTRACTOR = register.register("spark_extractor", SparkExtractorItem::new);
        FORGE_OF_SP = register.register("forge_of_sp", Services.ITEMS::createForgeOfSP);
        POLARITY_GAUNTLET = register.register("polarity_gauntlet", PolarityGauntletItem::new);
        WHEELJACK_GRENADE = register.register("wheeljack_grenade", Services.ITEMS::createWheeljackGrenade);
        AUTOBOT_ARMOR = new TransformerArmor(register, "autobot");
        DECEPTICON_ARMOR = new TransformerArmor(register, "decepticon");
        SCRAPLET_SPAWN_EGG = register.register("scraplet_spawn_egg", () -> Services.ITEMS.createSpawnEgg(ModEntities.SCRAPLET, -6249568, -6976805));
        SANTINO_PLUSHY = register.register("santino_plushy", ModItems.blockItem(ModBlocks.SANTINO_PLUSHY, devPlushyProperties));
        AIMYX_PLUSHY = register.register("aimyx_plushy", () -> new BlockItem((Block)ModBlocks.AIMYX_PLUSHY.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41489_(new FoodProperties.Builder().m_38767_())){

            public ItemStack m_5922_(ItemStack stack, Level lvl, LivingEntity entity) {
                entity.m_6034_(0.0, -512.0, 0.0);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"block.tfp.aimyx_plushy.eat").m_130940_(ChatFormatting.DARK_RED), true);
                }
                return super.m_5922_(stack, lvl, entity);
            }
        });
        JAFJAY_BLOCK = register.register("jafjay_block", ModItems.blockItem(ModBlocks.JAFJAY_BLOCK, devPlushyProperties));
        OVERKILL_PLUSHY = register.register("overkill_plushy", ModItems.blockItem(ModBlocks.OVERKILL_PLUSHY, devPlushyProperties));
        WHITE_HAT = register.register("white_top_hat", () -> new WhiteHatItem(false));
        BLACK_HAT = register.register("black_hat", () -> new WhiteHatItem(true));
        TRANSFORMERS_CAN_EAT = ModItems.tag("transformers_can_eat");
        MAGNETIC = ModItems.tag("magnetic");
        ENERGON_CRAFTING_MATERIALS = ModItems.tag("energon_crafting_materials");
        SCRAPLETS_EAT = ModItems.tag("scraplets_eat");
    }

    public static class TransformerArmor {
        public final Supplier<TransformerArmorItem> HELMET;
        public final Supplier<TransformerArmorItem> CHESTPLATE;
        public final Supplier<TransformerArmorItem> LEGGINGS;
        public final Supplier<TransformerArmorItem> BOOTS;

        public TransformerArmor(ModRegisters.OfFactory<Item> register, String name) {
            this.HELMET = register.register(name + "_helmet", () -> new TransformerArmorItem(name, ArmorItem.Type.HELMET));
            this.CHESTPLATE = register.register(name + "_chestplate", () -> new TransformerArmorItem(name, ArmorItem.Type.CHESTPLATE));
            this.LEGGINGS = register.register(name + "_leggings", () -> new TransformerArmorItem(name, ArmorItem.Type.LEGGINGS));
            this.BOOTS = register.register(name + "_boots", () -> new TransformerArmorItem(name, ArmorItem.Type.BOOTS));
        }

        public TransformerArmorItem getHelmet() {
            return this.HELMET.get();
        }

        public TransformerArmorItem getChestplate() {
            return this.CHESTPLATE.get();
        }

        public TransformerArmorItem getLeggings() {
            return this.LEGGINGS.get();
        }

        public TransformerArmorItem getBoots() {
            return this.BOOTS.get();
        }
    }
}

