/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.reg;

import bnb.tfp.reg.ModSounds;
import bnb.tfp.transformer.Airachnid;
import bnb.tfp.transformer.Arcee;
import bnb.tfp.transformer.Bulkhead;
import bnb.tfp.transformer.FlippingPlayableTransformer;
import bnb.tfp.transformer.HealingPlayableTransformer;
import bnb.tfp.transformer.Knockout;
import bnb.tfp.transformer.MaskPlayableTransformer;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.Starscream;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerSounds;
import bnb.tfp.transformer.TransformerType;
import bnb.tfp.transformer.VehiconMiner;
import bnb.tfp.transformer.vehicletypes.Car;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlayableTransformers {
    private static final HashMap<String, TransformerType> REGISTRY = new HashMap();
    public static final TransformerType OPTIMUS_PRIME = PlayableTransformers.add(new TransformerType.Builder("optimus_prime", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(0, 6, 6), new TransformerColorLayer("secondary").setColor(15, 6, 5), TransformerColorLayer.cyanGlowing()).canUseVariant(PlayableTransformers.canUseOptimusVariant()).canUseSpecialInMode(true, true).passengersLimit(2).sized(1.1f, 4.2f, 1.1f, 1.8f).health(80).weaponDamage(13.0).gunDamage(8.0f).weaponCooldown(1.0).gunCooldown(0.8).constructor(MaskPlayableTransformer::new).build());
    public static final TransformerType MEGATRON = PlayableTransformers.add(new TransformerType.Builder("megatron", PlayableTransformer.Faction.DECEPTICONS, VehicleType.AIRCRAFT).defaultVariant(new TransformerColorLayer("main").setColor(-1, 0, 5), new TransformerColorLayer("secondary").setColor(20, 5, 4), new TransformerColorLayer.Glowing().setColor(0, 6, 8)).canUseSpecialInMode(false, false).passengersLimit(1, 0).sized(1.2f, 4.4f, 2.4f, 1.0f).sounds(ModSounds.MEGATRON).health(85).weaponDamage(14.0).gunDamage(10.0f).weaponCooldown(0.8).gunCooldown(1.0).build());
    public static final TransformerType SOUNDWAVE = PlayableTransformers.add(new TransformerType.Builder("soundwave", PlayableTransformer.Faction.DECEPTICONS, VehicleType.AIRCRAFT).defaultVariant(new TransformerColorLayer("base").setColor(17, 7, 1), new TransformerColorLayer("main").setColor(17, 4, 5), new TransformerColorLayer("secondary").setColor(20, 5, 4), new TransformerColorLayer.Glowing(TransformerColorLayer.AltGlowing.ALWAYS).setColor(18, 4)).sized(0.9f, 3.5f, 0.9f, 0.9f).hasGunAndWeapon(false, true).health(65).gunDamage(8.0f).gunCooldown(0.6).weaponDamage(10.0).constructor(type -> new FlippingPlayableTransformer((TransformerType)type){

        @Override
        public boolean isUsingGun(Player player) {
            return this.isTransformed() && player.m_21205_().m_41619_() || this.isUsingWeapon(player) && (player.m_150110_().f_35934_ || player.m_36324_().m_38702_() > 4);
        }
    }).build());
    public static final TransformerType BUMBLEBEE = PlayableTransformers.add(new TransformerType.Builder("bumblebee", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(3, 8, 8), new TransformerColorLayer("secondary").setColor(-1, 0, 1), TransformerColorLayer.cyanGlowing()).passengersLimit(5).sized(1.0f, 3.2f, 1.2f, 0.8f).sounds(ModSounds.BUMBLEBEE).health(65).weaponDamage(9.0).gunDamage(9.0f).weaponCooldown(0.6f).gunCooldown(0.5).build());
    public static final TransformerType STARSCREAM = PlayableTransformers.add(new TransformerType.Builder("starscream", PlayableTransformer.Faction.DECEPTICONS, VehicleType.AIRCRAFT).defaultVariant(new TransformerColorLayer("base").setColor(-1, 0, 3), new TransformerColorLayer("main").setColor(14, 1, 7), new TransformerColorLayer("secondary").setColor(14, 3, 5), new TransformerColorLayer("insignia").setColor(0, 6, 5), TransformerColorLayer.redGlowing()).canUseSpecialInMode(true, true).passengersLimit(1, 0).sized(0.8f, 3.9f, 0.8f, 0.8f).constructor(Starscream::new).health(65).weaponDamage(9.0).gunDamage(9.0f).weaponCooldown(0.6f).gunCooldown(0.8f).build());
    public static final TransformerType RATCHET = PlayableTransformers.add(new TransformerType.Builder("ratchet", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(1, 8, 8), new TransformerColorLayer("secondary").setColor(-1, 0, 7), TransformerColorLayer.cyanGlowing()).hasGunAndWeapon(false, true).canUseSpecialInMode(true, true).passengersLimit(6).sized(1.2f, 3.6f, 1.25f, 1.4f).constructor(HealingPlayableTransformer::new).health(65).weaponCooldown(0.6).weaponDamage(8.0).build());
    public static final TransformerType ARCEE = PlayableTransformers.add(new TransformerType.Builder("arcee", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(15, 4, 5), new TransformerColorLayer("secondary").setColor(0, 2, 7), new TransformerColorLayer("blades").setColor(0, 0, 8), TransformerColorLayer.cyanGlowing()).passengersLimit(1).sized(0.5f, 2.7f, 0.6f, 0.8f).sounds(ModSounds.ARCEE).constructor(Arcee::new).health(50).weaponDamage(6.0).gunDamage(6.0f).weaponCooldown(0.4f).gunCooldown(0.6f).build());
    public static final TransformerType NEMESIS_PRIME = PlayableTransformers.add(new TransformerType.Builder("nemesis_prime", PlayableTransformer.Faction.DECEPTICONS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(0, 3, 2), new TransformerColorLayer("secondary").setColor(-1, 0, 1), new TransformerColorLayer.Glowing().setColor(4, 5)).canUseVariant(PlayableTransformers.canUseOptimusVariant()).passengersLimit(2, 0).sized(1.2f, 4.2f, 1.2f, 1.8f).health(80).weaponDamage(13.0).gunDamage(8.0f).weaponCooldown(1.0).gunCooldown(0.8f).build());
    public static final TransformerType AIRACHNID = PlayableTransformers.add(new TransformerType.Builder("airachnid", PlayableTransformer.Faction.DECEPTICONS, VehicleType.HELICOPTER).defaultVariant(new TransformerColorLayer("base").setColor(0, 0, 1), new TransformerColorLayer("main").setColor(17, 4, 5), new TransformerColorLayer("secondary").setColor(3, 6, 7), new TransformerColorLayer("heels").setColor(2, 6, 6), new TransformerColorLayer.Glowing().setColor(18, 4), new TransformerColorLayer.Glowing("eyes", TransformerColorLayer.AltGlowing.HEADLIGHTS).setColor(20, 6)).health(60).gunDamage(6.0f).weaponDamage(5.0).gunCooldown(0.5).weaponCooldown(1.0).sized(0.5f, 2.75f, 0.6f, 0.75f).constructor(Airachnid::new).build());
    public static final TransformerType BULKHEAD = PlayableTransformers.add(new TransformerType.Builder("bulkhead", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(5, 3, 3), new TransformerColorLayer("secondary").setColor(3, 2, 2), TransformerColorLayer.cyanGlowing()).passengersLimit(5).sized(1.1f, 3.66f, 1.4f, 1.75f).constructor(Bulkhead::new).sounds(ModSounds.BULKHEAD).health(90).weaponDamage(12.0).gunDamage(8.0f).weaponCooldown(1.2f).gunCooldown(0.9f).build());
    public static final TransformerType BREAKDOWN = PlayableTransformers.add(new TransformerType.Builder("breakdown", PlayableTransformer.Faction.DECEPTICONS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("face").setColor(1, 6, 7), new TransformerColorLayer("main").setColor(15, 2, 5), new TransformerColorLayer("secondary").setColor(14, 4, 3), new TransformerColorLayer("hinges").setColor(3, 3, 5), new TransformerColorLayer.Glowing(TransformerColorLayer.AltGlowing.HEADLIGHTS).setColor(3, 6)).passengersLimit(5, 0).sized(1.2f, 3.66f, 1.5f, 1.6f).sounds(TransformerSounds.builder().put(TransformerSounds.Sound.EQUIP_GUN, null).put(TransformerSounds.Sound.HIDE_GUN, null).build()).health(90).weaponDamage(12.0).gunDamage(8.0f).weaponCooldown(1.2f).gunCooldown(0.9f).build());
    public static final TransformerType KNOCKOUT = PlayableTransformers.add(new TransformerType.Builder("knockout", PlayableTransformer.Faction.DECEPTICONS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(0, 7, 7), new TransformerColorLayer("secondary").setColor(23, 8, 4), new TransformerColorLayer("wheels").setColor(4, 7, 8), TransformerColorLayer.redGlowing()).canUseSpecialInMode(true, true).passengersLimit(5, 0).sized(0.6f, 3.3f, 1.2f, 0.8f).constructor(Knockout::new).health(65).weaponCooldown(0.6).weaponDamage(8.0).build());
    public static final TransformerType VEHICON_GROUND = PlayableTransformers.add(new TransformerType.Builder("vehicon_ground", PlayableTransformer.Faction.DECEPTICONS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("main").setColor(17, 4, 3), new TransformerColorLayer("secondary").setColor(20, 5, 4), new TransformerColorLayer.Glowing("eyes").setColor(0, 6), new TransformerColorLayer.Glowing().setColor(18, 4)).noVariantRestrictions().canUseSpecialInMode(true, true).passengersLimit(5, 0).sized(1.0f, 3.2f, 1.2f, 0.8f).constructor(PlayableTransformer::new).health(55).weaponDamage(7.0).gunDamage(4.0f).weaponCooldown(0.5).gunCooldown(0.25).build());
    public static final TransformerType VEHICON_FLYER = PlayableTransformers.add(new TransformerType.Builder("vehicon_flyer", PlayableTransformer.Faction.DECEPTICONS, VehicleType.AIRCRAFT).defaultVariant(new TransformerColorLayer("main").setColor(17, 4, 3), new TransformerColorLayer("secondary").setColor(20, 5, 4), new TransformerColorLayer.Glowing("eyes").setColor(0, 6), new TransformerColorLayer.Glowing(TransformerColorLayer.AltGlowing.ALWAYS).setColor(18, 4)).noVariantRestrictions().canUseSpecialInMode(true, true).passengersLimit(5, 0).sized(1.0f, 3.5f, 1.2f, 1.0f).constructor(PlayableTransformer::new).health(55).weaponDamage(7.0).gunDamage(4.0f).weaponCooldown(0.5).gunCooldown(0.25).build());
    public static final TransformerType WHEELJACK = PlayableTransformers.add(new TransformerType.Builder("wheeljack", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("base").setColor(0, 0, 7), new TransformerColorLayer("main").setColor(0, 6, 6), new TransformerColorLayer("secondary").setColor(7, 4, 3), TransformerColorLayer.cyanGlowing()).canUseSpecialInMode(true, true).passengersLimit(4).sized(1.0f, 3.3f, 1.2f, 0.8f).health(65).weaponDamage(9.0).gunDamage(8.0f).weaponCooldown(0.6f).gunCooldown(0.6f).constructor(MaskPlayableTransformer::new).build());
    public static final TransformerType ULTRA_MAGNUS = PlayableTransformers.add(new TransformerType.Builder("ultra_magnus", PlayableTransformer.Faction.AUTOBOTS, VehicleType.CAR).defaultVariant(new TransformerColorLayer("base").setColor(14, 6, 5), new TransformerColorLayer("main").setColor(14, 6, 3), new TransformerColorLayer("secondary").setColor(0, 7, 7), TransformerColorLayer.cyanGlowing()).canUseSpecialInMode(true, true).passengersLimit(2).sized(1.06f, 4.25f, 1.1f, 1.8f).health(75).weaponDamage(9.0).gunDamage(9.0f).weaponCooldown(0.6f).gunCooldown(0.5).constructor(MaskPlayableTransformer::new).build());
    public static final TransformerType SHOCKWAVE = PlayableTransformers.add(new TransformerType.Builder("shockwave", PlayableTransformer.Faction.DECEPTICONS, VehicleType.TANK).defaultVariant(new TransformerColorLayer("main").setColor(20, 5, 4), new TransformerColorLayer.Glowing("eyes").setColor(0, 6), new TransformerColorLayer.Glowing("glowing").setColor(18, 4)).canUseSpecialInMode(true, true).passengersLimit(0).sized(1.06f, 4.0f, 1.1f, 1.4f).health(75).weaponDamage(6.0).gunDamage(12.0f).weaponCooldown(0.6f).gunCooldown(1.0).constructor(PlayableTransformer::new).build());
    public static final TransformerType VEHICON_MINER = PlayableTransformers.add(new TransformerType.Builder("vehicon_miner", PlayableTransformer.Faction.DECEPTICONS, new Car(0.25, 1.0, 0.05, 0.04)).defaultVariant(new TransformerColorLayer("main").setColor(22, 6, 4), new TransformerColorLayer.Glowing("insignia", TransformerColorLayer.AltGlowing.HEADLIGHTS).setColor(20, 5), new TransformerColorLayer.Glowing("eyes").setColor(0, 6), new TransformerColorLayer.Glowing(TransformerColorLayer.AltGlowing.ALWAYS){

        @Override
        public ResourceLocation getTextureLocation(Player player, PlayableTransformer transformer, float partialTick) {
            return new ResourceLocation("tfp", "textures/entity/transformer/vehicon_miner/glowing" + (int)(player.f_267362_.m_267756_() * 16.0f) % 3 + ".png");
        }
    }.setColor(18, 4, 8)).noVariantRestrictions().passengersLimit(1, 0).sized(0.75f, 2.8f, 1.0f, 0.9f).health(40).gunDamage(4.0f).gunCooldown(0.5).constructor(VehiconMiner::new).build());

    public static TransformerType add(TransformerType type) {
        REGISTRY.put(type.getName(), type);
        return type;
    }

    public static TransformerType get(String name) {
        return REGISTRY.get(name);
    }

    public static HashSet<TransformerType> getAll() {
        return new HashSet<TransformerType>(REGISTRY.values());
    }

    private static TransformerType.CanUseVariantPredicate canUseOptimusVariant() {
        return (tfpData, type, variant, uuid) -> !tfpData.contains((uuid1, transformer) -> !uuid1.equals(uuid) && (transformer.getType() == OPTIMUS_PRIME || transformer.getType() == NEMESIS_PRIME) && variant.equals(transformer.getColors()));
    }
}

