/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPUtils;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Airachnid
extends PlayableTransformer {
    private static final EntityDimensions SPIDER_DIMENSIONS = EntityDimensions.m_20395_((float)2.8f, (float)3.2f);
    private static final AttributeModifier SPIDER_SPEED_MODIFIER = new AttributeModifier(TFPUtils.TRANSFORMER_MODIFIERS_UUID, "Airachnid spider modifier", 0.05, AttributeModifier.Operation.ADDITION);
    public final AnimationState spiderAnimState = new AnimationState();

    public Airachnid(TransformerType type) {
        super(type);
    }

    public AnimationState getSpiderAnimState() {
        return this.spiderAnimState;
    }

    @Override
    public void resetAnimStates(@Nullable Player player) {
        super.resetAnimStates(player);
        this.spiderAnimState.m_216977_(Integer.MIN_VALUE);
    }

    @Override
    public EntityDimensions makeDimensions(Player player, Pose pose) {
        return this.isSpecialActive() ? SPIDER_DIMENSIONS : super.makeDimensions(player, pose);
    }

    @Override
    public void tick(Player player) {
        super.tick(player);
        AttributeInstance instance = Objects.requireNonNull(player.m_21051_(Attributes.f_22279_));
        if (this.isSpecialActive()) {
            if (!instance.m_22109_(SPIDER_SPEED_MODIFIER)) {
                instance.m_22125_(SPIDER_SPEED_MODIFIER);
            }
        } else {
            instance.m_22120_(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
        }
    }

    @Override
    public boolean transform(Level lvl, @Nullable Player player) {
        if (player != null && (this.isSpecialActive() || !this.isTransformed() && player.m_6047_())) {
            this.setSpecialActive(!this.isSpecialActive());
            player.m_6210_();
            this.getSpiderAnimState().m_216977_(player.f_19797_);
            return true;
        }
        return super.transform(lvl, player);
    }

    @Override
    public boolean canUseWeapon(Player player) {
        return !this.isSpecialActive() && super.canUseWeapon(player);
    }

    @Override
    public boolean isUsingWeapon(Player player) {
        return this.isSpecialActive() && !this.isGunLoaded() && player.m_21205_().m_41619_() || super.isUsingWeapon(player);
    }

    @Override
    public boolean beforeHit(Player attacker, Entity target) {
        if (super.beforeHit(attacker, target)) {
            return true;
        }
        if (this.isUsingWeapon(attacker)) {
            double damage = this.getType().getWeaponDamage();
            if (target instanceof LivingEntity) {
                MobEffectInstance instance;
                LivingEntity living = (LivingEntity)target;
                if (this.isUsingWeapon(attacker) && (instance = living.m_21124_(MobEffects.f_19597_)) != null) {
                    damage += (double)((instance.m_19564_() + 1) * 3);
                }
            }
            AttributeInstance attribute = Objects.requireNonNull(attacker.m_21051_(Attributes.f_22281_));
            attribute.m_22120_(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
            attribute.m_22118_(new AttributeModifier(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID, "Transformer weapon modifier", damage, AttributeModifier.Operation.ADDITION));
        }
        return false;
    }

    @Override
    public void shoot(Player player, Level lvl) {
        if (this.isSpecialActive()) {
            lvl.m_7967_((Entity)TFPUtils.createAndShootProjectile(lvl, ModEntities.COBWEB_PROJECTILE.get(), player, 2.0f, 1.0f, true));
            if (!player.m_150110_().f_35934_ && player.m_217043_().m_188503_(4) == 0) {
                player.m_36324_().m_38707_(-1, 0.0f);
            }
            lvl.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144073_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_217043_().m_188501_() * 0.4f);
            return;
        }
        super.shoot(player, lvl);
    }

    @Override
    public float getDestroySpeedCoef(Player player, BlockState state) {
        return this.isUsingWeapon(player) && state.m_60713_(Blocks.f_50033_) ? 100.0f : super.getDestroySpeedCoef(player, state);
    }
}

