/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HealingPlayableTransformer
extends PlayableTransformer {
    private long healTicks;
    private final AnimationState healAnimState = new AnimationState();

    public HealingPlayableTransformer(TransformerType type) {
        super(type);
    }

    public long getHealTicks() {
        return this.healTicks;
    }

    public void setHealTicks(long healTicks) {
        this.healTicks = healTicks;
        this.setDirty(true);
    }

    @Override
    public void useSpecial(Level lvl, @Nullable Player player) {
        if (this.isTransformed()) {
            super.useSpecial(lvl, player);
            return;
        }
        long ticksLeft = 6000L - (lvl.m_46467_() - this.getHealTicks());
        if (ticksLeft <= 0L) {
            this.setUsingWeapon(false);
            this.setHealTicks(lvl.m_46467_());
            if (player != null) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 288, 2));
                this.healAnimState.m_216977_(player.f_19797_);
            }
        } else if (!lvl.f_46443_ && player != null) {
            player.m_5661_((Component)Component.m_237110_((String)"tfp.special_ability_reloading", (Object[])new Object[]{ticksLeft / 1200L, ticksLeft % 1200L / 20L}), true);
        }
    }

    @Override
    public void readSavedData(CompoundTag tag) {
        super.readSavedData(tag);
        this.setHealTicks(tag.m_128454_("HealTicks"));
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128356_("HealTicks", this.getHealTicks());
    }

    public AnimationState getHealAnimState() {
        return this.healAnimState;
    }
}

