/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HologramPlayableTransformer
extends PlayableTransformer {
    private boolean hologram;
    private final AnimationState hologramAnimState = new AnimationState();
    private final AnimationState hologramFaintAnimState = new AnimationState();

    public HologramPlayableTransformer(TransformerType type) {
        super(type);
        this.hologramFaintAnimState.m_216977_(Integer.MIN_VALUE);
    }

    public boolean isHologramActive() {
        return this.hologram;
    }

    public void setHologramActive(boolean hologram) {
        if (this.hologram != hologram) {
            this.hologram = hologram;
            this.setDirty(true);
        }
    }

    @Override
    public void useSpecial(Level lvl, @Nullable Player player) {
        if (player != null) {
            if (this.isTransformed() && player.m_6047_() && !player.m_20160_()) {
                this.setHologramActive(!this.isHologramActive());
                if (this.isHologramActive()) {
                    this.hologramFaintAnimState.m_216973_();
                    this.hologramAnimState.m_216977_(player.f_19797_);
                } else {
                    this.hologramAnimState.m_216973_();
                    this.hologramFaintAnimState.m_216977_(player.f_19797_);
                }
            } else {
                super.useSpecial(lvl, player);
            }
        } else {
            super.useSpecial(lvl, null);
        }
    }

    @Override
    public void resetAnimStates(@Nullable Player player) {
        super.resetAnimStates(player);
        if (player != null && player.m_20160_() || this.isHologramActive()) {
            this.hologramFaintAnimState.m_216973_();
            this.hologramAnimState.m_216977_(Integer.MIN_VALUE);
        } else {
            this.hologramAnimState.m_216973_();
            this.hologramFaintAnimState.m_216977_(Integer.MIN_VALUE);
        }
    }

    @Override
    public byte saveFlags() {
        return this.hologram ? (byte)(super.saveFlags() - 128) : super.saveFlags();
    }

    @Override
    public void readFlags(byte flags) {
        super.readFlags(flags);
        this.hologram = (flags & 0xFFFFFF80) != 0;
    }

    public AnimationState getHologramAnimState() {
        return this.hologramAnimState;
    }

    public AnimationState getHologramFaintAnimState() {
        return this.hologramFaintAnimState;
    }
}

