/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.transformer.HealingPlayableTransformer;
import bnb.tfp.transformer.LongAttack;
import bnb.tfp.transformer.TransformerType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Knockout
extends HealingPlayableTransformer
implements LongAttack {
    private final AnimationState longAttackAnimState = new AnimationState();
    private final AnimationState finishLongAttackAnimState = new AnimationState();
    private int longAttackTicks = -1;

    public Knockout(TransformerType type) {
        super(type);
    }

    @Override
    public boolean canUseGun(Player player) {
        return this.canUseWeapon(player);
    }

    @Override
    public void equipGun(@Nullable Player player, boolean value) {
        super.equipGun(player, value);
        this.setLongAttacking(player, false);
    }

    @Override
    public void shoot(Player player, Level lvl) {
    }

    @Override
    public void tick(Player player) {
        super.tick(player);
        if (this.isGunLoaded()) {
            this.longAttackTick(player);
        }
    }

    @Override
    public void dealLongAttackDamage(Player player, Entity entity, int ticks) {
        if (entity.m_6469_(entity.m_269291_().m_269075_(player), Mth.m_14036_((float)((float)ticks * 0.2f), (float)0.0f, (float)4.0f))) {
            entity.f_19802_ = Math.min(entity.f_19802_, 15);
        }
    }

    @Override
    public void resetAnimStates(@Nullable Player player) {
        super.resetAnimStates(player);
        this.resetLongAttackAnimStates();
    }

    @Override
    public int getLongAttackTicks() {
        return this.longAttackTicks;
    }

    @Override
    public void setLongAttackTicks(int longAttackTicks) {
        this.longAttackTicks = longAttackTicks;
    }

    @Override
    public AnimationState getLongAttackAnimState() {
        return this.longAttackAnimState;
    }

    @Override
    public AnimationState getFinishLongAttackAnimState() {
        return this.finishLongAttackAnimState;
    }
}

