/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.TFPUtils;
import bnb.tfp.client.ClientUtils;
import bnb.tfp.entity.ModProjectiles;
import bnb.tfp.entity.TransformerAnimatable;
import bnb.tfp.item.TransformerArmorItem;
import bnb.tfp.network.ClientboundVampireTerrorconPacket;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.reg.ModSounds;
import bnb.tfp.reg.PlayableTransformers;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerSounds;
import bnb.tfp.transformer.TransformerType;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlayableTransformer
implements TransformerAnimatable {
    private final TransformerType type;
    private Faction faction;
    private final ArrayList<TransformerColorLayer> variant;
    private boolean transformed;
    private double transformedTick;
    private boolean gun;
    private boolean weapon;
    private boolean specialActive;
    private boolean vehicleSpecialActive;
    private boolean dirty;
    private int passengers;
    private byte passengersLimit;
    private boolean minerMode;
    private int darkEnergonExposure;
    private boolean vampire;
    private boolean f5Vehicle;
    public boolean settled;
    private boolean doAFlip;
    public boolean crouching;
    public boolean playFallAnim;
    public float attackAnimIndex;
    private final AnimationState transformAnimState = new AnimationState();
    private final AnimationState revertAnimState = new AnimationState();
    private final AnimationState settleAnimState = new AnimationState();
    private final AnimationState attackAnimState = new AnimationState();
    private final AnimationState idleAnimState = new AnimationState();
    private final AnimationState crouchAnimState = new AnimationState();
    private final AnimationState uncrouchAnimState = new AnimationState();
    private final AnimationState loadGunAnimState = new AnimationState();
    private final AnimationState hideGunAnimState = new AnimationState();
    private final AnimationState loadWeaponAnimState = new AnimationState();
    private final AnimationState hideWeaponAnimState = new AnimationState();
    private final AnimationState fallAnimState = new AnimationState();
    private final AnimationState landAnimState = new AnimationState();

    public PlayableTransformer(TransformerType type) {
        this.type = type;
        this.faction = type.getFaction();
        this.variant = new ArrayList<TransformerColorLayer>(type.getDefaultVariant());
        this.passengersLimit = type.getDefaultPassengers();
    }

    public final TransformerType getType() {
        return this.type;
    }

    public TransformerSounds getSounds() {
        return this.getType().getSounds();
    }

    public VehicleType getVehicleType() {
        return this.getType().getVehicleType();
    }

    public Component getNameComponent() {
        return Component.m_237115_((String)("transformer.tfp." + this.getType().getName())).m_130940_(this.getFaction().color);
    }

    public EntityDimensions makeDimensions(Player player, Pose pose) {
        EntityDimensions output = this.getType().getDimensions();
        if (this.transformed) {
            output = this.getType().getAltDimensions();
        } else {
            switch (pose) {
                case CROUCHING: {
                    output = EntityDimensions.m_20395_((float)output.f_20377_, (float)(output.f_20378_ * 0.75f));
                    break;
                }
                case SWIMMING: {
                    output = EntityDimensions.m_20395_((float)output.f_20377_, (float)output.f_20377_);
                }
            }
        }
        return output;
    }

    public float getEyeHeight(Player player, Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.85f;
    }

    public Faction getFaction() {
        return this.faction;
    }

    public void setFaction(Faction faction) {
        this.faction = faction;
    }

    public List<TransformerColorLayer> getVariant() {
        return List.copyOf(this.variant);
    }

    public List<HSBColor> getColors() {
        return this.getVariant().stream().map(TransformerColorLayer::getColor).toList();
    }

    public void setColor(int index, HSBColor value) {
        this.variant.get(index).setColor(value);
    }

    public float[] getGlowingColor(Player player) {
        return this.variant.isEmpty() ? (this.isVampire() ? TransformerColorLayer.VAMPIRE_RGB : (this.onDarkEnergon() ? TransformerColorLayer.DARK_ENERGON_RGB : (this.onSynthEn() ? TransformerColorLayer.SYNTH_EN_RGB : this.faction.defaultGlowRGB))) : this.variant.get(this.variant.size() - 1).getColor(player, this);
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public void setTransformed(boolean transformed) {
        this.transformed = transformed;
        this.setDirty(true);
    }

    public double getTransformedTick() {
        return this.transformedTick;
    }

    public void setTransformedTick(double transformedTick) {
        this.transformedTick = transformedTick;
    }

    public boolean transform(Level lvl, @Nullable Player player) {
        boolean output = !this.isTransformed();
        this.setTransformed(output);
        this.setTransformedTick(lvl.m_46467_());
        if (player != null) {
            player.m_6210_();
            player.m_20153_();
            if (lvl.f_46443_) {
                ClientUtils.playTransformerEngineSound(this, player);
            } else {
                this.getSounds().getSound(this.transformed ? TransformerSounds.Sound.TRANSFORM : TransformerSounds.Sound.REVERT).ifPresent(soundEvent -> lvl.m_6269_(null, (Entity)player, soundEvent, SoundSource.PLAYERS, 1.0f, 0.9f + player.m_217043_().m_188501_() * 0.2f));
            }
            if (this.isTransformed()) {
                this.revertAnimState.m_216973_();
                this.transformAnimState.m_216977_(player.f_19797_);
            } else {
                this.transformAnimState.m_216973_();
                this.revertAnimState.m_216977_(player.f_19797_);
                this.doAFlip = this.getVehicleType().shouldDoAFlip(player, this);
                this.settled = false;
                this.settleAnimState.m_216977_(Integer.MAX_VALUE);
            }
            this.hideGunAnimState.m_216977_(Integer.MIN_VALUE);
            this.hideWeaponAnimState.m_216977_(Integer.MIN_VALUE);
            this.landAnimState.m_216977_(Integer.MIN_VALUE);
        }
        return output;
    }

    public boolean canUseWeapon(Player player) {
        return this.getType().hasWeapon() && player.m_21205_().m_41619_() && !this.transformed;
    }

    public boolean isUsingWeapon() {
        return this.weapon;
    }

    public boolean isUsingWeapon(Player player) {
        return this.isUsingWeapon();
    }

    public void setUsingWeapon(boolean value) {
        if (this.weapon != value) {
            this.weapon = value;
            this.setDirty(true);
        }
    }

    public void equipWeapon(@Nullable Player player, boolean value) {
        int tickCount;
        int n = tickCount = player != null ? player.f_19797_ : Integer.MIN_VALUE;
        if (this.isGunLoaded()) {
            this.setGunLoaded(false);
            this.getLoadGunAnimState().m_216973_();
            this.getHideGunAnimState().m_216977_(tickCount);
        }
        if (value) {
            this.setUsingWeapon(true);
            this.getHideWeaponAnimState().m_216973_();
            this.getLoadWeaponAnimState().m_216977_(tickCount);
        } else {
            this.setUsingWeapon(false);
            this.getLoadWeaponAnimState().m_216973_();
            this.getHideWeaponAnimState().m_216977_(tickCount);
        }
    }

    public Map<Attribute, Double> getWeaponModifiers() {
        HashMap<Attribute, Double> hashMap = new HashMap<Attribute, Double>();
        if (this.getType().getWeaponDamage() != 0.0) {
            hashMap.put(Attributes.f_22281_, this.getType().getWeaponDamage());
        }
        if (this.getType().getWeaponSpeed() != 0.0) {
            hashMap.put(Attributes.f_22283_, this.getType().getWeaponSpeed());
        }
        return Map.copyOf(hashMap);
    }

    public boolean beforeHit(Player attacker, Entity target) {
        return false;
    }

    public void onHit(Player attacker, Entity target) {
        if (!this.isVampire() || !(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        PlayableTransformer transformer = TFPData.getTransformerStatic(player);
        if (transformer == null || transformer.isVampire()) {
            return;
        }
        attacker.m_36324_().m_38707_(20, 0.5f);
        if ((double)attacker.m_217043_().m_188501_() < 0.0625) {
            transformer.setVampire(true);
        }
    }

    public boolean canUseGun(Player player) {
        return !this.transformed && this.getType().hasGun() && player.m_21205_().m_41619_() && (player.m_150110_().f_35934_ || player.m_36324_().m_38702_() > 4);
    }

    @Override
    public boolean doAFlip() {
        return this.doAFlip;
    }

    public boolean isGunLoaded() {
        return this.gun;
    }

    public boolean isUsingGun(Player player) {
        return this.isGunLoaded() || this.isTransformed() && this.getType().hasGun() && player.m_21205_().m_41619_() && (player.m_150110_().f_35934_ || player.m_36324_().m_38702_() > 4);
    }

    public void setGunLoaded(boolean value) {
        if (this.gun != value) {
            this.gun = value;
            this.setDirty(true);
        }
    }

    public void equipGun(@Nullable Player player, boolean value) {
        int tickCount;
        int n = tickCount = player != null ? player.f_19797_ : Integer.MIN_VALUE;
        if (this.isUsingWeapon()) {
            this.setUsingWeapon(false);
            this.getLoadWeaponAnimState().m_216973_();
            this.getHideWeaponAnimState().m_216977_(tickCount);
        }
        if (value) {
            this.setGunLoaded(true);
            this.getHideGunAnimState().m_216973_();
            this.getLoadGunAnimState().m_216977_(tickCount);
        } else {
            this.setGunLoaded(false);
            this.getLoadGunAnimState().m_216973_();
            this.getHideGunAnimState().m_216977_(tickCount);
        }
    }

    public void swing(Player player) {
        Level lvl = player.m_9236_();
        if (lvl.f_46443_) {
            return;
        }
        if (player.m_36403_(0.5f) > 0.9f && this.isUsingGun(player)) {
            this.shoot(player, lvl);
        }
    }

    public void shoot(Player player, Level lvl) {
        Projectile projectile = TFPUtils.createAndShootProjectile(lvl, ModEntities.ION_BULLET.get(), player, 3.0f, 0.0f, false);
        if (projectile instanceof ModProjectiles.IonBullet) {
            ModProjectiles.IonBullet bullet = (ModProjectiles.IonBullet)projectile;
            bullet.setDamage(this.getType().getGunDamage());
            bullet.setColor(this.getGlowingColor(player));
        }
        lvl.m_7967_((Entity)projectile);
        if (!player.m_150110_().f_35934_ && player.m_217043_().m_188503_(4) == 0) {
            player.m_36324_().m_38707_(-1, 0.0f);
        }
        this.getSounds().getSound(TransformerSounds.Sound.SHOOT).ifPresent(soundEvent -> lvl.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f));
    }

    @Nullable
    public AttributeModifier getShootingSpeedModifier(Player player) {
        return this.getType().getGunSpeed() != 0.0 ? new AttributeModifier(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID, "Transformer gun modifier", this.getType().getGunSpeed(), AttributeModifier.Operation.ADDITION) : null;
    }

    public boolean getF5Vehicle() {
        return this.f5Vehicle;
    }

    public void setF5Vehicle(boolean Boolean2) {
        this.f5Vehicle = Boolean2;
        this.setDirty(true);
    }

    public double getBlockReach(Player player) {
        return 7.0;
    }

    public double getEntityReach(Player player) {
        return 5.0;
    }

    public boolean isSpecialActive() {
        return this.specialActive;
    }

    public boolean isVehicleSpecialActive() {
        return this.vehicleSpecialActive;
    }

    public void setSpecialActive(boolean specialActive) {
        this.specialActive = specialActive;
        this.setDirty(true);
    }

    public void setVehicleSpecialActive(boolean vehicleSpecialActive) {
        this.vehicleSpecialActive = vehicleSpecialActive;
        this.setDirty(true);
    }

    public boolean canUseSpecial(Player player) {
        return this.isTransformed() ? this.getType().canVehicleUseSpecial() : this.getType().canBotUseSpecial();
    }

    public void useSpecial(Level lvl, @Nullable Player player) {
        if (this.transformed) {
            this.setVehicleSpecialActive(!this.isVehicleSpecialActive());
            if (player != null) {
                lvl.m_6269_(null, (Entity)player, ModSounds.HEADLIGHTS.get(), SoundSource.PLAYERS, 1.0f, 0.8f + player.m_217043_().m_188501_() * 0.4f);
            }
        } else {
            this.setSpecialActive(!this.isSpecialActive());
        }
    }

    public boolean isMinerMode() {
        return this.minerMode;
    }

    public void setMinerMode(boolean minerMode) {
        this.minerMode = minerMode;
    }

    public int getDarkEnergonExposure() {
        return this.darkEnergonExposure;
    }

    public boolean onDarkEnergon() {
        return this.darkEnergonExposure > 0;
    }

    public boolean onSynthEn() {
        return this.darkEnergonExposure < 0;
    }

    public void addDarkEnergonExposure(int addDarkEnergon) {
        this.darkEnergonExposure += addDarkEnergon;
        this.setDirty(true);
    }

    public void setDarkEnergonExposure(int setDarkEnergon) {
        this.darkEnergonExposure = setDarkEnergon;
        this.setDirty(true);
    }

    public boolean isVampire() {
        return this.vampire;
    }

    public void setVampire(boolean vampire) {
        if (this.vampire != vampire) {
            this.vampire = vampire;
            this.setDirty(true);
        }
    }

    public byte getPassengersLimit() {
        return this.passengersLimit;
    }

    public void setPassengersLimit(int value) {
        this.passengersLimit = (byte)Mth.m_14045_((int)0, (int)value, (int)this.getType().getMaxPassengers());
    }

    public Map<Attribute, Double> getAttributeValues() {
        return Map.of(Attributes.f_22276_, this.getType().getHealth());
    }

    public float getMaxUpStep(Player player) {
        return 1.0f;
    }

    public float getJumpPowerCoef(Player player) {
        return 1.5f;
    }

    public float getDestroySpeedCoef(Player player, BlockState state) {
        return 1.0f;
    }

    public boolean canHarvest(Player player, BlockState state) {
        return false;
    }

    public void tick(Player player) {
        AttributeModifier modifier;
        Entity vehicle = player.m_20202_();
        if (vehicle instanceof Saddleable || vehicle instanceof Boat || vehicle instanceof Minecart) {
            player.m_142098_(player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
        }
        if (this.isUsingWeapon() && !this.canUseWeapon(player)) {
            this.equipWeapon(player, false);
        }
        if (this.isGunLoaded() && !this.canUseGun(player)) {
            this.equipGun(player, false);
        }
        if ((modifier = this.getShootingSpeedModifier(player)) != null) {
            AttributeInstance speed = Objects.requireNonNull(player.m_21051_(Attributes.f_22283_));
            boolean b0 = this.isUsingGun(player);
            boolean b1 = speed.m_22109_(modifier);
            if (b0 && !b1) {
                speed.m_22118_(modifier);
            } else if (!b0 && b1) {
                speed.m_22130_(modifier);
            }
        }
        boolean b2 = this.isUsingWeapon(player);
        Map<Attribute, Double> modifiers = this.getWeaponModifiers();
        modifiers.forEach((attribute, value) -> {
            AttributeInstance instance = Objects.requireNonNull(player.m_21051_(attribute));
            AttributeModifier modifier1 = new AttributeModifier(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID, "Transformer weapon modifier", value.doubleValue(), AttributeModifier.Operation.ADDITION);
            boolean b3 = instance.m_22109_(modifier1);
            if (b2 && !b3) {
                instance.m_22118_(modifier1);
            } else if (!b2 && b3) {
                instance.m_22130_(modifier1);
            }
        });
        if (player.m_9236_().f_46443_) {
            if (player.f_19797_ <= 1) {
                this.resetAnimStates(player);
            }
            this.setupAnimStates(player);
        }
    }

    public void tryUpdatePassengers(Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel lvl = (ServerLevel)level;
        int newPassengers = player.m_20197_().size();
        if (this.passengers == newPassengers) {
            return;
        }
        this.passengers = newPassengers;
        lvl.m_6907_().forEach(player1 -> player1.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)player)));
    }

    public void setupTransformer(ServerPlayer player) {
        if (this.isVampire()) {
            this.setVampire(false);
            ModNetworking.send(player, new ClientboundVampireTerrorconPacket(player.m_20148_(), false));
        }
        ModItems.TransformerArmor armor = this.getFaction().armor;
        ItemStack helmet = new ItemStack((ItemLike)armor.getHelmet());
        ItemStack chestplate = new ItemStack((ItemLike)armor.getChestplate());
        ItemStack leggings = new ItemStack((ItemLike)armor.getLeggings());
        ItemStack boots = new ItemStack((ItemLike)armor.getBoots());
        for (ItemStack i : new ItemStack[]{helmet, chestplate, leggings, boots}) {
            i.m_41663_(Enchantments.f_44975_, 1);
            i.m_41663_(Enchantments.f_44963_, 1);
            EquipmentSlot slot = Mob.m_147233_((ItemStack)i);
            ItemStack replaced = player.m_6844_(slot).m_278832_();
            player.m_8061_(slot, i);
            if (replaced.m_41720_() instanceof TransformerArmorItem) continue;
            player.m_36356_(replaced);
        }
        float oMaxHealth = player.m_21233_();
        Map<Attribute, Double> map = this.getAttributeValues();
        for (Attribute attr : BuiltInRegistries.f_256951_) {
            AttributeInstance instance = player.m_21051_(attr);
            if (instance == null) continue;
            instance.m_22120_(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
            instance.m_22120_(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID);
            instance.m_22120_(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
            if (!map.containsKey(attr)) continue;
            instance.m_22100_(map.get(attr).doubleValue());
        }
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
        player.m_5634_(player.m_21233_() - oMaxHealth);
        TFPUtils.setReach.accept((Object)player, (Object)this.getBlockReach((Player)player), (Object)this.getEntityReach((Player)player));
        player.m_6210_();
    }

    public void onTurnedIntoHuman(Player player) {
        player.m_6168_().forEach(stack -> stack.m_41764_(0));
        AttributeSupplier sup = DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_);
        for (Attribute attr : BuiltInRegistries.f_256951_) {
            AttributeInstance instance = player.m_21051_(attr);
            if (instance == null) continue;
            instance.m_22100_(sup.m_22253_(attr));
            instance.m_22120_(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
            instance.m_22120_(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID);
            instance.m_22120_(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
        }
        if (player.m_21223_() > player.m_21233_()) {
            player.m_21153_(player.m_21233_());
        }
        player.m_6210_();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void readSavedData(CompoundTag tag) {
        this.faction = Faction.byName(tag.m_128461_("Faction"));
        ListTag listTag = tag.m_128437_("Variant", 2);
        if (listTag.size() == this.variant.size()) {
            for (int i = 0; i < listTag.size(); ++i) {
                this.setColor(i, HSBColor.fromShort(listTag.m_128757_(i)));
            }
        }
        this.f5Vehicle = tag.m_128471_("F5Swap");
        this.passengersLimit = tag.m_128445_("PassengersLimit");
        this.darkEnergonExposure = tag.m_128451_("DarkEnergon");
        this.readFlags(tag.m_128445_("Flags"));
    }

    public void readFlags(byte flags) {
        this.transformed = (flags & 1) != 0;
        this.gun = (flags & 2) != 0;
        this.weapon = (flags & 4) != 0;
        this.specialActive = (flags & 8) != 0;
        this.vehicleSpecialActive = (flags & 0x10) != 0;
        this.minerMode = (flags & 0x20) != 0;
        this.vampire = (flags & 0x40) != 0;
    }

    public void save(CompoundTag tag) {
        tag.m_128359_("Type", this.getType().getName());
        tag.m_128359_("Faction", this.faction.m_7912_());
        ListTag listTag = new ListTag();
        for (TransformerColorLayer layer : this.variant) {
            listTag.add((Object)ShortTag.m_129258_((short)layer.getColor().toShort()));
        }
        tag.m_128365_("Variant", (Tag)listTag);
        if (this.passengersLimit > 0) {
            tag.m_128344_("PassengersLimit", this.passengersLimit);
        }
        tag.m_128344_("DarkEnergon", (byte)this.darkEnergonExposure);
        tag.m_128379_("F5Swap", this.f5Vehicle);
        tag.m_128344_("Flags", this.saveFlags());
    }

    public byte saveFlags() {
        byte output = 0;
        if (this.transformed) {
            output = (byte)(output + 1);
        }
        if (this.gun) {
            output = (byte)(output + 2);
        }
        if (this.weapon) {
            output = (byte)(output + 4);
        }
        if (this.specialActive) {
            output = (byte)(output + 8);
        }
        if (this.vehicleSpecialActive) {
            output = (byte)(output + 16);
        }
        if (this.minerMode) {
            output = (byte)(output + 32);
        }
        if (this.vampire) {
            output = (byte)(output + 64);
        }
        return output;
    }

    public void setupAnimStates(Player player) {
        if (this.playFallAnim == (player.f_19789_ < 4.0f || this.isTransformed() || this.revertAnimState.m_216984_())) {
            if (this.playFallAnim) {
                this.playFallAnim = false;
                this.fallAnimState.m_216973_();
                this.landAnimState.m_216977_(player.f_19797_);
            } else {
                this.playFallAnim = true;
                this.fallAnimState.m_216977_(player.f_19797_);
                this.landAnimState.m_216973_();
            }
        }
        if (!this.settled && player.f_19789_ <= 0.0f && !this.revertAnimState.m_216984_() && !this.landAnimState.m_216984_()) {
            this.settleAnimState.m_216977_(player.f_19797_);
            this.settled = true;
        }
        if (this.crouching != player.m_6047_()) {
            if (this.crouching) {
                this.crouching = false;
                this.crouchAnimState.m_216973_();
                this.uncrouchAnimState.m_216982_(player.f_19797_);
            } else {
                this.crouching = true;
                this.uncrouchAnimState.m_216973_();
                this.crouchAnimState.m_216982_(player.f_19797_);
            }
        }
        if (!this.attackAnimState.m_216984_() && (player.f_20921_ > 0.0f || this.attackAnimState.m_216984_())) {
            this.attackAnimIndex = player.m_217043_().m_188501_();
            this.attackAnimState.m_216977_(player.f_19797_);
            if (this.isUsingWeapon(player)) {
                this.getSounds().getSound(TransformerSounds.Sound.SWING_WEAPON).ifPresent(sound -> player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_217043_().m_188501_() * 0.4f, false));
            }
        }
    }

    public void resetAnimStates(@Nullable Player player) {
        this.idleAnimState.m_216977_(0);
        this.getRevertAnimState().m_216973_();
        if (this.isTransformed()) {
            this.transformAnimState.m_216977_(Integer.MIN_VALUE);
        } else {
            this.transformAnimState.m_216973_();
        }
        this.settled = false;
        this.settleAnimState.m_216977_(Integer.MAX_VALUE);
        if (this.isGunLoaded()) {
            this.hideGunAnimState.m_216973_();
            this.loadGunAnimState.m_216977_(Integer.MIN_VALUE);
        } else {
            this.loadGunAnimState.m_216973_();
            this.hideGunAnimState.m_216977_(Integer.MIN_VALUE);
        }
        if (this.isUsingWeapon()) {
            this.hideWeaponAnimState.m_216973_();
            this.loadWeaponAnimState.m_216977_(Integer.MIN_VALUE);
        } else {
            this.loadWeaponAnimState.m_216973_();
            this.hideWeaponAnimState.m_216977_(Integer.MIN_VALUE);
        }
    }

    public boolean shouldDiscardViewBobbing() {
        return this.isTransformed();
    }

    @Override
    public AnimationState getTransformAnimState() {
        return this.transformAnimState;
    }

    @Override
    public AnimationState getRevertAnimState() {
        return this.revertAnimState;
    }

    @Override
    public AnimationState getSettleAnimState() {
        return this.settleAnimState;
    }

    @Override
    public AnimationState getAttackAnimState() {
        return this.attackAnimState;
    }

    @Override
    public AnimationState getIdleAnimState() {
        return this.idleAnimState;
    }

    @Override
    public AnimationState getCrouchAnimState() {
        return this.crouchAnimState;
    }

    @Override
    public AnimationState getUncrouchAnimState() {
        return this.uncrouchAnimState;
    }

    @Override
    public AnimationState getLoadGunAnimState() {
        return this.loadGunAnimState;
    }

    @Override
    public AnimationState getHideGunAnimState() {
        return this.hideGunAnimState;
    }

    @Override
    public AnimationState getLoadWeaponAnimState() {
        return this.loadWeaponAnimState;
    }

    @Override
    public AnimationState getHideWeaponAnimState() {
        return this.hideWeaponAnimState;
    }

    @Override
    public AnimationState getFallAnimState() {
        return this.fallAnimState;
    }

    @Override
    public AnimationState getLandAnimState() {
        return this.landAnimState;
    }

    @Override
    public float attackAnimIndex() {
        return this.attackAnimIndex;
    }

    public static PlayableTransformer fromNbt(CompoundTag tag) {
        PlayableTransformer transformer = PlayableTransformers.get(tag.m_128461_("Type")).get();
        transformer.readSavedData(tag);
        return transformer;
    }

    public static enum Faction implements StringRepresentable
    {
        AUTOBOTS("autobots", ModItems.AUTOBOT_ARMOR, 0.34f, 0.8f, 1.0f, ChatFormatting.DARK_RED),
        DECEPTICONS("decepticons", ModItems.DECEPTICON_ARMOR, 0.9f, 0.17f, 0.17f, ChatFormatting.DARK_PURPLE);

        private final String name;
        public final ModItems.TransformerArmor armor;
        public final float[] defaultGlowRGB;
        public final ChatFormatting color;

        private Faction(String name, ModItems.TransformerArmor armor, float defaultGlowRed, float defaultGlowGreen, float defaultGlowBlue, ChatFormatting color) {
            this.name = name;
            this.armor = armor;
            this.defaultGlowRGB = new float[]{defaultGlowRed, defaultGlowGreen, defaultGlowBlue};
            this.color = color;
        }

        public String m_7912_() {
            return this.name;
        }

        public Component getComponent() {
            return Component.m_237115_((String)("faction.tfp." + this.m_7912_())).m_130940_(this.color);
        }

        public static Faction byName(String name) {
            for (Faction faction1 : Faction.values()) {
                if (!faction1.m_7912_().equals(name)) continue;
                return faction1;
            }
            return AUTOBOTS;
        }
    }
}

