/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPUtils;
import bnb.tfp.entity.ModProjectiles;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.transformer.FlippingPlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Starscream
extends FlippingPlayableTransformer {
    private final AnimationState blasterAnimState = new AnimationState();
    private final AnimationState hideBlasterAnimState = new AnimationState();

    public Starscream(TransformerType type) {
        super(type);
    }

    @Override
    public void shoot(Player player, Level lvl) {
        if (this.isSpecialActive()) {
            super.shoot(player, lvl);
            return;
        }
        Projectile projectile = TFPUtils.createAndShootProjectile(lvl, ModEntities.HOMING_MISSILE.get(), player, 1.5f, 0.0f, false);
        if (projectile instanceof ModProjectiles.HomingMissile) {
            ModProjectiles.HomingMissile missile = (ModProjectiles.HomingMissile)projectile;
            missile.calculateTarget();
        }
        lvl.m_7967_((Entity)projectile);
        if (!player.m_150110_().f_35934_ && player.m_217043_().m_188503_(4) == 0) {
            player.m_36324_().m_38707_(-1, 0.0f);
        }
    }

    @Override
    public void useSpecial(Level lvl, @Nullable Player player) {
        super.useSpecial(lvl, player);
        this.updateBlasterAnimStates(player);
    }

    @Override
    public void equipGun(@Nullable Player player, boolean value) {
        super.equipGun(player, value);
        this.updateBlasterAnimStates(player);
    }

    @Override
    public void resetAnimStates(@Nullable Player player) {
        super.resetAnimStates(player);
        this.updateBlasterAnimStates(player);
    }

    public AnimationState getBlasterAnimState() {
        return this.blasterAnimState;
    }

    public AnimationState getHideBlasterAnimState() {
        return this.hideBlasterAnimState;
    }

    private void updateBlasterAnimStates(@Nullable Player player) {
        int tickCount;
        int n = tickCount = player != null ? player.f_19797_ : Integer.MIN_VALUE;
        if (this.isSpecialActive()) {
            if (this.isGunLoaded()) {
                this.getHideBlasterAnimState().m_216973_();
                this.getBlasterAnimState().m_216982_(tickCount);
            } else {
                this.getBlasterAnimState().m_216973_();
                this.getHideBlasterAnimState().m_216982_(tickCount);
            }
            this.getLoadGunAnimState().m_216973_();
            this.getHideGunAnimState().m_216982_(tickCount);
        } else {
            if (this.isGunLoaded()) {
                this.getHideGunAnimState().m_216973_();
                this.getLoadGunAnimState().m_216982_(tickCount);
            } else {
                this.getLoadGunAnimState().m_216973_();
                this.getHideGunAnimState().m_216982_(tickCount);
            }
            this.getBlasterAnimState().m_216973_();
            this.getHideBlasterAnimState().m_216982_(tickCount);
        }
    }
}

