/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerSounds;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Player;

public class TransformerType
implements Supplier<PlayableTransformer> {
    private final String name;
    private final PlayableTransformer.Faction faction;
    private final VehicleType vehicleType;
    private TransformerColorLayer[] defaultVariant = new TransformerColorLayer[0];
    private CanUseVariantPredicate canUseVariant = (tfpData, type, variant, uuid) -> !tfpData.contains((uuid1, transformer) -> transformer.getType() == type && !uuid1.equals(uuid) && variant.equals(transformer.getColors()));
    private double health;
    private double weaponDamage;
    private double weaponSpeed;
    private float gunDamage;
    private double gunSpeed;
    private double altSpeed;
    private double runSpeed;
    private boolean hasWeapon = true;
    private boolean hasGun = true;
    private boolean botSpecial;
    private boolean vehicleSpecial = true;
    private byte maxPassengers;
    private byte defaultPassengers;
    private EntityDimensions dimensions = Player.f_36088_;
    private EntityDimensions altDimensions = Player.f_36088_;
    private TransformerSounds sounds;
    private Function<TransformerType, PlayableTransformer> constructor = PlayableTransformer::new;

    private TransformerType(String name, PlayableTransformer.Faction faction, VehicleType vehicleType) {
        this.name = name;
        this.faction = faction;
        this.vehicleType = vehicleType;
        this.sounds = TransformerSounds.builder().put(TransformerSounds.Sound.ENGINE, vehicleType.defaultEngineSound()).build();
    }

    @Override
    public PlayableTransformer get() {
        return this.constructor.apply(this);
    }

    public String getName() {
        return this.name;
    }

    public List<TransformerColorLayer> getDefaultVariant() {
        return Arrays.stream(this.defaultVariant).map(TransformerColorLayer::clone).toList();
    }

    public boolean canUseVariant(TFPData tfpData, List<HSBColor> variant, @Nullable UUID uuid) {
        return this.canUseVariant.test(tfpData, this, variant, uuid);
    }

    public float getGunDamage() {
        return this.gunDamage;
    }

    public double getHealth() {
        return this.health;
    }

    public double getWeaponSpeed() {
        return this.weaponSpeed;
    }

    public double getWeaponDamage() {
        return this.weaponDamage;
    }

    public double getRunSpeed() {
        return this.runSpeed;
    }

    public double getGunSpeed() {
        return this.gunSpeed;
    }

    public double getAltSpeed() {
        return this.altSpeed;
    }

    public PlayableTransformer.Faction getFaction() {
        return this.faction;
    }

    public VehicleType getVehicleType() {
        return this.vehicleType;
    }

    public boolean hasWeapon() {
        return this.hasWeapon;
    }

    public boolean hasGun() {
        return this.hasGun;
    }

    public boolean canBotUseSpecial() {
        return this.botSpecial;
    }

    public boolean canVehicleUseSpecial() {
        return this.vehicleSpecial;
    }

    public byte getMaxPassengers() {
        return this.maxPassengers;
    }

    public byte getDefaultPassengers() {
        return this.defaultPassengers;
    }

    public EntityDimensions getDimensions() {
        return this.dimensions;
    }

    public EntityDimensions getAltDimensions() {
        return this.altDimensions;
    }

    public TransformerSounds getSounds() {
        return this.sounds;
    }

    public Function<TransformerType, PlayableTransformer> getConstructor() {
        return this.constructor;
    }

    @FunctionalInterface
    public static interface CanUseVariantPredicate {
        public boolean test(TFPData var1, TransformerType var2, List<HSBColor> var3, @Nullable UUID var4);
    }

    public static class Builder {
        private final TransformerType type;

        public Builder(String name, PlayableTransformer.Faction faction, VehicleType vehicleType) {
            this.type = new TransformerType(name, faction, vehicleType);
        }

        public Builder defaultVariant(TransformerColorLayer ... colors) {
            this.type.defaultVariant = colors;
            return this;
        }

        public Builder canUseVariant(CanUseVariantPredicate predicate) {
            this.type.canUseVariant = predicate;
            return this;
        }

        public Builder noVariantRestrictions() {
            return this.canUseVariant((tfpData, type, layers, uuid) -> true);
        }

        public Builder hasGunAndWeapon(boolean gun, boolean weapon) {
            this.type.hasGun = gun;
            this.type.hasWeapon = weapon;
            return this;
        }

        public Builder health(int health) {
            this.type.health = health;
            return this;
        }

        public Builder weaponDamage(double attackDamage) {
            this.type.weaponDamage = attackDamage;
            return this;
        }

        public Builder weaponSpeed(double attackSpeed) {
            this.type.weaponSpeed = attackSpeed;
            return this;
        }

        public Builder weaponCooldown(double attackSpeed) {
            return this.weaponSpeed(1.0 / attackSpeed - 4.0);
        }

        public Builder gunDamage(float damage) {
            this.type.gunDamage = damage;
            return this;
        }

        public Builder gunSpeed(double gunSpeed) {
            this.type.gunSpeed = gunSpeed;
            return this;
        }

        public Builder gunCooldown(double gunCooldown) {
            return this.gunSpeed(1.0 / gunCooldown - 4.0);
        }

        public Builder runSpeed(double runSpeed) {
            this.type.runSpeed = runSpeed;
            return this;
        }

        public Builder altSpeed(float altSpeed) {
            this.type.altSpeed = altSpeed;
            return this;
        }

        public Builder canUseSpecialInMode(boolean bot, boolean alt) {
            this.type.botSpecial = bot;
            this.type.vehicleSpecial = alt;
            return this;
        }

        public Builder passengersLimit(int max, int defaultLimit) {
            if (max < 0 || max > 127) {
                throw new IllegalArgumentException("max passengers limit expected to be between 0 and 127, got " + max);
            }
            if (defaultLimit < 0 || defaultLimit > 127) {
                throw new IllegalArgumentException("default passengers limit expected to be between 0 and 127, get " + defaultLimit);
            }
            this.type.maxPassengers = (byte)max;
            this.type.defaultPassengers = (byte)defaultLimit;
            return this;
        }

        public Builder passengersLimit(int value) {
            return this.passengersLimit(value, value);
        }

        public Builder sized(float width, float height, float altWidth, float altHeight) {
            this.type.dimensions = EntityDimensions.m_20395_((float)width, (float)height);
            this.type.altDimensions = EntityDimensions.m_20395_((float)altWidth, (float)altHeight);
            return this;
        }

        public Builder sounds(TransformerSounds sounds) {
            this.type.sounds = sounds;
            return this;
        }

        public Builder constructor(Function<TransformerType, PlayableTransformer> function) {
            this.type.constructor = function;
            return this;
        }

        public TransformerType build() {
            return this.type;
        }
    }
}

