/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.transformer.HologramPlayableTransformer;
import bnb.tfp.transformer.LongAttack;
import bnb.tfp.transformer.TransformerType;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VehiconMiner
extends HologramPlayableTransformer
implements LongAttack {
    private final AnimationState longAttackAnimState = new AnimationState();
    private final AnimationState finishLongAttackAnimState = new AnimationState();
    private int longAttackTicks = -1;

    public VehiconMiner(TransformerType type) {
        super(type);
    }

    @Override
    public void tick(Player player) {
        super.tick(player);
        if (this.isTransformed() || this.isUsingWeapon()) {
            this.longAttackTick(player);
        }
    }

    @Override
    public void dealLongAttackDamage(Player player, Entity entity, int ticks) {
        if (entity.m_6469_(entity.m_269291_().m_269075_(player), this.isTransformed() ? Mth.m_14036_((float)((float)ticks * 0.08f), (float)0.0f, (float)4.0f) : Mth.m_14036_((float)((float)ticks * 0.2f), (float)0.0f, (float)2.0f))) {
            entity.f_19802_ = Math.min(entity.f_19802_, 15);
        }
    }

    @Override
    public boolean transform(Level lvl, @Nullable Player player) {
        this.setLongAttacking(player, false);
        return super.transform(lvl, player);
    }

    @Override
    public boolean isUsingGun(Player player) {
        return this.isGunLoaded();
    }

    @Override
    public void equipWeapon(@Nullable Player player, boolean value) {
        super.equipWeapon(player, value);
        this.setLongAttacking(player, false);
    }

    @Override
    public float getDestroySpeedCoef(Player player, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) ? (this.isTransformed() ? 1.0f + (float)Math.min(this.getLongAttackTicks(), 50) * 0.3133f : (this.isUsingWeapon() ? 10.0f : 1.0f)) : 1.0f;
    }

    @Override
    public boolean canHarvest(Player player, BlockState state) {
        return this.isUsingWeapon() && !state.m_204336_(BlockTags.f_144284_) || this.isTransformed() && state.m_204336_(BlockTags.f_144282_);
    }

    @Override
    public void resetAnimStates(@Nullable Player player) {
        super.resetAnimStates(player);
        this.resetLongAttackAnimStates();
    }

    @Override
    public int getLongAttackTicks() {
        return this.longAttackTicks;
    }

    @Override
    public void setLongAttackTicks(int longAttackTicks) {
        this.longAttackTicks = longAttackTicks;
    }

    @Override
    public AnimationState getLongAttackAnimState() {
        return this.longAttackAnimState;
    }

    @Override
    public AnimationState getFinishLongAttackAnimState() {
        return this.finishLongAttackAnimState;
    }
}

