/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer.vehicletypes;

import bnb.tfp.reg.ModSounds;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerSounds;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record Tank(double speedLimit, double maxSpeed, double power, double acceleration) implements VehicleType
{
    public double getSpeedLimit(Player player) {
        return (double)player.m_6113_() * (player.m_20142_() ? this.maxSpeed / 0.13 : this.speedLimit / 0.1);
    }

    @Override
    public void travel(PlayableTransformer transformer, Player player, Vec3 input, BlockPos below) {
        Level lvl = player.m_9236_();
        Vec3 dm = player.m_20184_();
        boolean falling = dm.f_82480_ <= 0.0;
        double gravity = falling && player.m_21023_(MobEffects.f_19591_) ? 0.01 : 0.08;
        player.m_6478_(MoverType.SELF, dm);
        if (lvl.m_6425_(player.m_20183_()).m_76178_()) {
            double speedLimit;
            float friction = lvl.m_8055_(below).m_60734_().m_49958_();
            player.m_19920_((float)((double)player.m_6113_() * this.power() + dm.m_165924_() * this.acceleration()) / (friction * friction * friction * friction), input);
            dm = player.m_20184_();
            double yMovement = dm.f_82480_;
            if (player.m_21023_(MobEffects.f_19620_)) {
                yMovement += (0.05 * (double)(player.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - yMovement) * 0.2;
            } else if (player.m_9236_().f_46443_ && !player.m_9236_().m_46805_(below)) {
                yMovement = player.m_20186_() > (double)player.m_9236_().m_141937_() ? -0.1 : 0.0;
            } else if (!player.m_20068_()) {
                yMovement -= gravity;
            }
            dm = new Vec3(dm.f_82479_, yMovement, dm.f_82481_);
            if (!player.m_147223_()) {
                double coef = Mth.m_14116_((float)friction);
                dm = dm.m_82542_(coef, 0.98, coef);
            }
            if ((speedLimit = this.getSpeedLimit(player) / dm.m_165924_()) < 1.0) {
                dm = dm.m_82542_(speedLimit, 1.0, speedLimit);
            }
            player.m_20256_(dm);
            if (player.m_20142_()) {
                AABB aabb = player.m_20191_().m_82377_(1.0, 0.0, 1.0);
                for (int x = Mth.m_14107_((double)aabb.f_82288_); x <= Mth.m_14165_((double)aabb.f_82291_); ++x) {
                    for (int y = Mth.m_14107_((double)aabb.f_82289_); y <= Mth.m_14165_((double)aabb.f_82292_); ++y) {
                        for (int z = Mth.m_14107_((double)aabb.f_82290_); z <= Mth.m_14165_((double)aabb.f_82293_); ++z) {
                            BlockPos pos = new BlockPos(x, y, z);
                            if (!lvl.m_8055_(pos).m_204336_(BlockTags.f_13035_)) continue;
                            lvl.m_46953_(pos, true, (Entity)player);
                        }
                    }
                }
            }
        } else {
            player.m_20256_(dm.m_82490_(0.8).m_82520_(0.0, -gravity * 0.5, 0.0));
        }
    }

    @Override
    public boolean shouldTravelNormally(PlayableTransformer transformer, Player player) {
        return VehicleType.super.shouldTravelNormally(transformer, player) || !player.m_20096_() && player.m_9236_().m_6425_(player.m_20183_()).m_76178_() || !((double)player.m_9236_().m_46467_() - transformer.getTransformedTick() > 20.0);
    }

    @Override
    public void checkMovementStatistics(PlayableTransformer transformer, Player player, double x, double y, double z) {
        if (player.m_6069_()) {
            return;
        }
        VehicleType.super.checkMovementStatistics(transformer, player, x, y, z);
    }

    @Override
    public Supplier<SoundEvent> defaultEngineSound() {
        return ModSounds.BULKHEAD.getSound(TransformerSounds.Sound.ENGINE)::orElseThrow;
    }

    @Override
    public boolean shouldDoAFlip(Player player, PlayableTransformer transformer) {
        return player.m_20184_().m_82553_() - this.speedLimit >= 0.025;
    }

    @Override
    public double speedometerValue(Player player, PlayableTransformer transformer, Vec3 deltaMovement) {
        return deltaMovement.m_165924_() / this.maxSpeed;
    }
}

