/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer.vehicletypes;

import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.vehicletypes.Aircraft;
import bnb.tfp.transformer.vehicletypes.Car;
import bnb.tfp.transformer.vehicletypes.Helicopter;
import bnb.tfp.transformer.vehicletypes.Tank;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public interface VehicleType {
    public static final VehicleType AIRCRAFT = new Aircraft(1.0, 2.5, 0.85);
    public static final VehicleType CAR = new Car(1.0, 2.0, 0.05, 0.04);
    public static final VehicleType HELICOPTER = new Helicopter(1.2, 0.75);
    public static final VehicleType TANK = new Tank(0.75, 1.5, 0.05, 0.035);

    public double maxSpeed();

    public void travel(PlayableTransformer var1, Player var2, Vec3 var3, BlockPos var4);

    default public boolean shouldTravelNormally(PlayableTransformer transformer, Player player) {
        return !transformer.isTransformed();
    }

    default public void checkMovementStatistics(PlayableTransformer transformer, Player player, double x, double y, double z) {
        player.m_36378_(x, y, z);
    }

    default public float tickHeadTurn(Player player, PlayableTransformer transformer, float yRot, float movement) {
        boolean b;
        float headRot = Mth.m_14177_((float)(yRot - player.f_20883_));
        player.f_20883_ += headRot * 0.3f;
        float headRot1 = Mth.m_14177_((float)(player.m_146908_() - player.f_20883_));
        if (Math.abs(headRot1) > 50.0f) {
            player.f_20883_ += headRot1 - (float)(Mth.m_14205_((double)headRot1) * 50);
        }
        boolean bl = b = headRot1 < -90.0f || headRot1 >= 90.0f;
        if (b) {
            movement *= -1.0f;
        }
        return movement;
    }

    @Nullable
    default public Supplier<SoundEvent> defaultEngineSound() {
        return null;
    }

    default public Quaternionf getRenderRot(Player player, PlayableTransformer transformer, float netHeadYaw, float headPitch, float partialTick, float transformation) {
        float swimAmount = player.m_20998_(partialTick);
        if (swimAmount > 0.0f) {
            float maxXRot = player.m_20069_() ? -90.0f - player.m_146909_() : -90.0f;
            float xRot = Mth.m_14179_((float)swimAmount, (float)0.0f, (float)maxXRot);
            return Axis.f_252529_.m_252977_(xRot);
        }
        return new Quaternionf();
    }

    default public boolean shouldDoAFlip(Player player, PlayableTransformer transformer) {
        return this.maxSpeed() - player.m_20184_().m_82553_() <= 0.025;
    }

    default public boolean shouldShowSpeedometer(Player player, PlayableTransformer transformer) {
        return transformer.isTransformed();
    }

    default public double speedometerValue(Player player, PlayableTransformer transformer, Vec3 deltaMovement) {
        return deltaMovement.m_82553_() / this.maxSpeed();
    }
}

