/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.DualSpitterModel;
import com.Harbinger.Spore.Client.Models.SniperSpitterModel;
import com.Harbinger.Spore.Client.Models.SpitterModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Spitter;
import com.Harbinger.Spore.Sentities.Variants.SpitterVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpitterRenderer<Type extends Spitter>
extends BaseInfectedRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel = this.m_7200_();
    private final EntityModel<Type> dualModel;
    private final EntityModel<Type> sniperModel;
    public static final Map<SpitterVariants, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(SpitterVariants.class), p_114874_ -> {
        p_114874_.put(SpitterVariants.DEFAULT, new ResourceLocation("spore", "textures/entity/spitter.png"));
        p_114874_.put(SpitterVariants.EXPLOSIVE, new ResourceLocation("spore", "textures/entity/exploding_spitter.png"));
        p_114874_.put(SpitterVariants.BILE, new ResourceLocation("spore", "textures/entity/spitter_bile.png"));
        p_114874_.put(SpitterVariants.DUAL, new ResourceLocation("spore", "textures/entity/spitter_dual.png"));
        p_114874_.put(SpitterVariants.SNIPER, new ResourceLocation("spore", "textures/entity/sniper_spitter.png"));
    });
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/spitter.png");

    public SpitterRenderer(EntityRendererProvider.Context context) {
        super(context, new SpitterModel(context.m_174023_(SpitterModel.LAYER_LOCATION)), 0.5f);
        this.dualModel = new DualSpitterModel<Type>(context.m_174023_(DualSpitterModel.LAYER_LOCATION));
        this.sniperModel = new SniperSpitterModel<Type>(context.m_174023_(SniperSpitterModel.LAYER_LOCATION));
    }

    protected EntityModel<Type> entityModel(int val) {
        return switch (val) {
            case 3 -> this.dualModel;
            case 4 -> this.sniperModel;
            default -> this.defaultModel;
        };
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Spitter)entity).getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.f_115290_ = this.entityModel(((Spitter)type).getTypeVariant());
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }
}

