/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.BurstUsurperModel;
import com.Harbinger.Spore.Client.Models.SprayUsurperModel;
import com.Harbinger.Spore.Client.Models.UsurperModel;
import com.Harbinger.Spore.Client.Renderers.OrganoidMobRenderer;
import com.Harbinger.Spore.Sentities.Organoids.Usurper;
import com.Harbinger.Spore.Sentities.Variants.UsurperVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UsurperRenderer<Type extends Usurper>
extends OrganoidMobRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> base = this.m_7200_();
    private final EntityModel<Type> burst;
    private final EntityModel<Type> spray;
    public static final Map<UsurperVariants, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(UsurperVariants.class), p_114874_ -> {
        p_114874_.put(UsurperVariants.DEFAULT, new ResourceLocation("spore", "textures/entity/usurper.png"));
        p_114874_.put(UsurperVariants.BURST, new ResourceLocation("spore", "textures/entity/burst_usurper.png"));
        p_114874_.put(UsurperVariants.SPRAY, new ResourceLocation("spore", "textures/entity/spray_usurper.png"));
    });

    public UsurperRenderer(EntityRendererProvider.Context context) {
        super(context, new UsurperModel(context.m_174023_(UsurperModel.LAYER_LOCATION)), 1.0f);
        this.burst = new BurstUsurperModel<Type>(context.m_174023_(BurstUsurperModel.LAYER_LOCATION));
        this.spray = new SprayUsurperModel<Type>(context.m_174023_(SprayUsurperModel.LAYER_LOCATION));
    }

    protected EntityModel<Type> getUsurperModel(Type entity) {
        switch (((Usurper)entity).getVariant()) {
            case BURST: {
                return this.burst;
            }
            case SPRAY: {
                return this.spray;
            }
        }
        return this.base;
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Usurper)entity).getVariant());
    }

    @Override
    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int value3) {
        this.f_115290_ = this.getUsurperModel(type);
        super.render(type, value1, value2, stack, bufferSource, value3);
    }
}

