/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class SporeSavedData
extends SavedData {
    public static final Map<String, ChunkLoadRequest> activeRequests = new HashMap<String, ChunkLoadRequest>();
    public static final String NAME = "spore_world_data";
    private static final List<Protector> protectorList = new ArrayList<Protector>();
    private static final List<Proto> protos = new ArrayList<Proto>();

    public static void addProtector(Protector protector) {
        protectorList.add(protector);
    }

    public static void removeProtector(Protector protector) {
        protectorList.remove(protector);
    }

    public static List<Protector> protectorList() {
        return protectorList;
    }

    public static void addProto(Proto protector) {
        protos.add(protector);
    }

    public static void removeProto(Proto protector) {
        protos.remove(protector);
    }

    public static List<Proto> getHiveminds() {
        return protos;
    }

    public int getAmountOfHiveminds() {
        return protos.size();
    }

    public static SporeSavedData getDataLocation(ServerLevel level) {
        return (SporeSavedData)level.m_8895_().m_164858_(SporeSavedData::load, NAME);
    }

    public static SporeSavedData get(ServerLevel level) {
        return (SporeSavedData)level.m_8895_().m_164861_(SporeSavedData::load, SporeSavedData::new, NAME);
    }

    public void addRequest(ChunkLoadRequest request) {
        activeRequests.put(request.getRequestID(), request);
        this.m_77762_();
    }

    public void removeRequest(String id) {
        activeRequests.remove(id);
        this.m_77762_();
    }

    public Collection<ChunkLoadRequest> getRequests() {
        return activeRequests.values();
    }

    public static SporeSavedData load(CompoundTag tag) {
        SporeSavedData data = new SporeSavedData();
        if (tag.m_128425_("ChunkRequests", 9)) {
            ListTag list = tag.m_128437_("ChunkRequests", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                ChunkLoadRequest request = ChunkLoadRequest.deserializeNBT(entry);
                activeRequests.put(request.getRequestID(), request);
            }
        }
        return data;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (ChunkLoadRequest request : activeRequests.values()) {
            listTag.add((Object)request.serializeNBT());
        }
        tag.m_128365_("ChunkRequests", (Tag)listTag);
        return tag;
    }
}

