/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.Recipes.GraftingRecipe;
import com.Harbinger.Spore.Screens.GraftingRecipeMenu;
import com.Harbinger.Spore.Screens.TutorialMenuMethods;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;

public class GraftingRecipeScreen
extends AbstractContainerScreen<GraftingRecipeMenu>
implements TutorialMenuMethods {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/grafting_recipe_gui.png");
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private final List<GraftingRecipe> recipes;
    public static final ResourceLocation UID = new ResourceLocation("spore", "grafting");

    public GraftingRecipeScreen(GraftingRecipeMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 84;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.recipes = level == null ? new ArrayList<GraftingRecipe>() : level.m_7465_().m_44013_((RecipeType)GraftingRecipe.GraftingRecipeType.INSTANCE);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        int buttonY = this.f_97736_ - 20;
        int buttonX = this.f_97735_ + 88;
        this.leftButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.changeRecipe(-1)).m_252987_(buttonX - 10, buttonY, 20, 20).m_253136_());
        this.rightButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.changeRecipe(1)).m_252987_(buttonX + 10, buttonY, 20, 20).m_253136_());
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        GraftingRecipe recipe = this.recipes.get(this.currentItemIndex);
        if (recipe == null) {
            return;
        }
        this.renderFakeItem(this.f_96547_, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.m_7527_().get(21)), this.f_97735_ + 25, this.f_97736_ + 8);
        this.renderFakeItem(this.f_96547_, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.m_7527_().get(22)), this.f_97735_ + 25, this.f_97736_ + 35);
        this.renderFakeItem(this.f_96547_, guiGraphics, this.getItemStackFromIngredient((Ingredient)recipe.m_7527_().get(23)), this.f_97735_ + 25, this.f_97736_ + 62);
        ItemStack stack = recipe.m_8043_(null);
        this.renderFakeItem(this.f_96547_, guiGraphics, stack, this.f_97735_ + 88, this.f_97736_ + 35);
    }

    private ItemStack getItemStackFromIngredient(Ingredient ingredient) {
        ItemStack[] itemStacks = ingredient.m_43908_();
        return itemStacks.length > 0 ? itemStacks[0] : ItemStack.f_41583_;
    }
}

