/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.HurtTargetGoal;
import com.Harbinger.Spore.Sentities.AI.InfectedConsumeFromRemains;
import com.Harbinger.Spore.Sentities.AI.InfectedPanicGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.FollowOthersGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.LocalTargettingGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.SearchAreaGoal;
import com.Harbinger.Spore.Sentities.ArmedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Experiment;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class Infected
extends Monster {
    public static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EVOLUTION_POINTS = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EVOLUTION = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PERSISTENT = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ORIGIN = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    private BlockPos searchPos;
    @Nullable
    private LivingEntity partner;
    public Predicate<LivingEntity> TARGET_SELECTOR = entity -> Utilities.TARGET_SELECTOR.Test((LivingEntity)entity);

    public Infected(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.f_21364_ = 5;
    }

    public List<? extends String> getDropList() {
        return null;
    }

    @Nullable
    public BlockPos getSearchPos() {
        return this.searchPos;
    }

    public void setSearchPos(@Nullable BlockPos searchPos) {
        this.searchPos = searchPos;
    }

    public void m_7023_(Vec3 p_32858_) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, p_32858_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_32858_);
        }
    }

    public void setFollowPartner(@Nullable LivingEntity followPartner) {
        this.partner = followPartner;
    }

    public LivingEntity getFollowPartner() {
        return this.partner;
    }

    public int m_6062_() {
        return 1200;
    }

    protected int m_7305_(int p_28389_) {
        return this.m_6062_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_7327_(Entity entity) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entity instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(this.getCustomDamage((LivingEntity)this), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 0), (Entity)this);
                livingEntity.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
        }
        return flag;
    }

    public void m_21424_(Player p_21425_, ItemStack p_21426_, ItemStack p_21427_) {
        if (!p_21426_.m_41619_() && !p_21427_.m_41619_() && p_21426_.m_41720_() instanceof AxeItem && p_21427_.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_21425_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_21425_, (byte)30);
            }
        }
    }

    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage1(entity);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage2(entity);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.infected_damage3(entity);
        }
        return this.m_269291_().m_269333_((LivingEntity)this);
    }

    protected void addTargettingGoals() {
        this.f_21345_.m_25352_(2, (Goal)new HurtTargetGoal((PathfinderMob)this, livingEntity -> this.TARGET_SELECTOR.test((LivingEntity)livingEntity), Infected.class).setAlertOthers(Infected.class));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> livingEntity instanceof Player || ((List)SConfig.SERVER.whitelist.get()).contains(livingEntity.m_20078_())));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> (Boolean)SConfig.SERVER.at_mob.get() != false && this.TARGET_SELECTOR.test((LivingEntity)livingEntity)));
    }

    protected void addRegularGoals() {
        this.f_21345_.m_25352_(3, (Goal)new LocalTargettingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BufferAI(this));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true){

            public boolean m_8036_() {
                return super.m_8036_() && Infected.this.getLinked() && (Boolean)SConfig.SERVER.higher_thinking.get() != false;
            }

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SearchAreaGoal(this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new InfectedPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new InfectedConsumeFromRemains(this));
        this.f_21345_.m_25352_(10, (Goal)new FollowOthersGoal(this, Infected.class, (com.google.common.base.Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> true)));
        this.f_21345_.m_25352_(10, (Goal)new FollowOthersGoal(this, Calamity.class, (com.google.common.base.Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> this instanceof EvolvingInfected)));
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        this.addRegularGoals();
    }

    public boolean canStarve() {
        return (Boolean)SConfig.SERVER.should_starve.get() != false && (Integer)this.f_19804_.m_135370_(EVOLUTION_POINTS) <= 0;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 20 == 0) {
            this.applyColdWeaknessEffects();
            this.handleStarvationProgress();
            if ((this.f_19862_ || this.additionalBreakingTriggers()) && this.canGrief()) {
                this.breakNearbyBlocks();
            }
            if (this.f_19862_ && this.m_20069_()) {
                this.jumpInFluid((FluidType)ForgeMod.WATER_TYPE.get());
            }
        }
    }

    public boolean additionalBreakingTriggers() {
        return false;
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        return (blockstate.m_60734_() instanceof AbstractGlassBlock || blockstate.m_60734_() instanceof LeavesBlock) && blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) >= 0.0f && blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < 2.0f;
    }

    private void handleStarvationProgress() {
        int hungerIncrement;
        if (!this.canStarve()) {
            return;
        }
        int currentHunger = this.getHunger();
        int hungerThreshold = (Integer)SConfig.SERVER.hunger.get();
        boolean freezingPenalty = this.f_146808_ || this.isFreazing();
        int n = hungerIncrement = freezingPenalty ? 2 : 1;
        if (currentHunger < hungerThreshold) {
            this.setHunger(currentHunger + hungerIncrement);
        } else if (!this.m_21023_((MobEffect)Seffects.STARVATION.get())) {
            this.m_7292_(new MobEffectInstance((MobEffect)Seffects.STARVATION.get(), 100, 0));
        }
    }

    private void applyColdWeaknessEffects() {
        if (!((Boolean)SConfig.SERVER.weaktocold.get()).booleanValue()) {
            return;
        }
        if (!this.f_146808_ && !this.isFreazing()) {
            return;
        }
        this.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, false), (Entity)this);
        this.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 100, 0, false, false), (Entity)this);
    }

    private boolean canGrief() {
        return ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this);
    }

    private void breakNearbyBlocks() {
        boolean brokeAny = false;
        AABB aabb = this.m_20191_().m_82400_(0.2).m_82386_(0.0, 0.5, 0.0);
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!this.blockBreakingParameter(state, pos)) continue;
            brokeAny |= this.interactBlock(pos, this.m_9236_());
        }
        if (!brokeAny && this.m_20096_()) {
            this.m_6135_();
        }
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.m_8055_(blockPos);
        if (Utilities.biomass().contains(state)) {
            return level.m_7731_(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3);
        }
        return level.m_46953_(blockPos, false, (Entity)this);
    }

    public boolean isStarving() {
        return (Integer)this.f_19804_.m_135370_(HUNGER) >= (Integer)SConfig.SERVER.hunger.get() || this.m_21023_((MobEffect)Seffects.STARVATION.get());
    }

    public boolean m_6785_(double p_21542_) {
        if (this.getEvoPoints() >= (Integer)SConfig.SERVER.min_kills.get() && this instanceof EvolvingInfected) {
            return false;
        }
        return super.m_6785_(p_21542_);
    }

    public boolean isFreazing() {
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        Biome biome = (Biome)this.m_9236_().m_204166_(blockpos).m_203334_();
        return (Boolean)SConfig.SERVER.weaktocold.get() != false && this.f_19796_.m_188503_(20) == 0 && (double)biome.m_47554_() <= 0.2;
    }

    public void m_5993_(Entity entity, int i, DamageSource damageSource) {
        this.f_19804_.m_135381_(KILLS, (Object)((Integer)this.f_19804_.m_135370_(KILLS) + 1));
        this.f_19804_.m_135381_(EVOLUTION_POINTS, (Object)((Integer)this.f_19804_.m_135370_(EVOLUTION_POINTS) + 1));
        this.setHunger(0);
        super.m_5993_(entity, i, damageSource);
    }

    public void setHunger(Integer count) {
        this.f_19804_.m_135381_(HUNGER, (Object)count);
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setKills(Integer count) {
        this.f_19804_.m_135381_(KILLS, (Object)count);
    }

    public int getKills() {
        return (Integer)this.f_19804_.m_135370_(KILLS);
    }

    public void setEvoPoints(Integer count) {
        this.f_19804_.m_135381_(EVOLUTION_POINTS, (Object)count);
    }

    public int getEvoPoints() {
        return (Integer)this.f_19804_.m_135370_(EVOLUTION_POINTS);
    }

    public void setLinked(Boolean count) {
        this.f_19804_.m_135381_(LINKED, (Object)count);
    }

    public boolean getLinked() {
        return (Boolean)this.f_19804_.m_135370_(LINKED);
    }

    public int getEvolutionCoolDown() {
        return (Integer)this.f_19804_.m_135370_(EVOLUTION);
    }

    public void setEvolution(int u) {
        this.f_19804_.m_135381_(EVOLUTION, (Object)u);
    }

    public void setPersistent(Boolean count) {
        this.f_19804_.m_135381_(PERSISTENT, (Object)count);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("hunger", ((Integer)this.f_19804_.m_135370_(HUNGER)).intValue());
        tag.m_128405_("kills", ((Integer)this.f_19804_.m_135370_(KILLS)).intValue());
        tag.m_128405_("evo_points", ((Integer)this.f_19804_.m_135370_(EVOLUTION_POINTS)).intValue());
        tag.m_128405_("evolution", ((Integer)this.f_19804_.m_135370_(EVOLUTION)).intValue());
        tag.m_128379_("linked", ((Boolean)this.f_19804_.m_135370_(LINKED)).booleanValue());
        tag.m_128379_("persistent", ((Boolean)this.f_19804_.m_135370_(PERSISTENT)).booleanValue());
        tag.m_128359_("origin", (String)this.f_19804_.m_135370_(ORIGIN));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(HUNGER, (Object)tag.m_128451_("hunger"));
        this.f_19804_.m_135381_(KILLS, (Object)tag.m_128451_("kills"));
        this.f_19804_.m_135381_(EVOLUTION, (Object)tag.m_128451_("evolution"));
        this.f_19804_.m_135381_(EVOLUTION_POINTS, (Object)tag.m_128451_("evo_points"));
        this.f_19804_.m_135381_(LINKED, (Object)tag.m_128471_("linked"));
        this.f_19804_.m_135381_(PERSISTENT, (Object)tag.m_128471_("persistent"));
        this.f_19804_.m_135381_(ORIGIN, (Object)tag.m_128461_("origin"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(KILLS, (Object)0);
        this.f_19804_.m_135372_(EVOLUTION_POINTS, (Object)0);
        this.f_19804_.m_135372_(LINKED, (Object)false);
        this.f_19804_.m_135372_(PERSISTENT, (Object)false);
        this.f_19804_.m_135372_(EVOLUTION, (Object)0);
        this.f_19804_.m_135372_(ORIGIN, (Object)this.origin());
    }

    public String origin() {
        return "";
    }

    public void setOrigin(String string) {
        this.f_19804_.m_135381_(ORIGIN, (Object)string);
    }

    public String getOrigin() {
        return (String)this.f_19804_.m_135370_(ORIGIN);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Level level;
        if (this.m_21023_((MobEffect)Seffects.STARVATION.get()) && source == this.m_269291_().m_269264_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 0.25 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 0.1;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.SPORE_PARTICLE.get()), x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        if (source.m_7640_() instanceof AcidBall || source.m_7640_() instanceof Vomit) {
            return false;
        }
        if (source.m_7640_() != null) {
            this.setSearchPos(new BlockPos((int)source.m_7640_().m_20185_(), (int)source.m_7640_().m_20186_(), (int)source.m_7640_().m_20189_()));
        }
        return super.m_6469_(source, amount);
    }

    public static boolean checkMonsterInfectedRules(EntityType<? extends Infected> p_219014_, ServerLevelAccessor levelAccessor, MobSpawnType type, BlockPos pos, RandomSource source) {
        if (levelAccessor.m_46791_() != Difficulty.PEACEFUL) {
            return Infected.furtherSpawnParameters(p_219014_, levelAccessor, type, pos, source);
        }
        return false;
    }

    private static boolean furtherSpawnParameters(EntityType<? extends Infected> p_219014_, ServerLevelAccessor levelAccessor, MobSpawnType type, BlockPos pos, RandomSource source) {
        MinecraftServer server = levelAccessor.m_7654_();
        if (server != null && server.m_6846_().m_11314_().isEmpty()) {
            return false;
        }
        return Infected.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && Infected.m_217057_(p_219014_, (LevelAccessor)levelAccessor, (MobSpawnType)type, (BlockPos)pos, (RandomSource)source);
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @org.jetbrains.annotations.Nullable Entity entity) {
        if ((Integer)this.f_19804_.m_135370_(HUNGER) >= (Integer)SConfig.SERVER.hunger.get() && (effectInstance.m_19544_() == MobEffects.f_19601_ || effectInstance.m_19544_() == MobEffects.f_19605_)) {
            this.setHunger(0);
        }
        return super.m_147207_(effectInstance, entity);
    }

    public void m_6667_(DamageSource source) {
        this.placeRemains(source);
        this.placeFrozenRemains();
        if (((Boolean)this.f_19804_.m_135370_(PERSISTENT)).booleanValue()) {
            for (int i = 0; i < this.f_19796_.m_216339_(1, 4); ++i) {
                super.m_6667_(source);
            }
        } else {
            super.m_6667_(source);
        }
    }

    private void placeRemains(DamageSource source) {
        if (this.m_21023_((MobEffect)Seffects.STARVATION.get()) && source == this.m_269291_().m_269264_()) {
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockState = this.m_9236_().m_8055_(blockpos);
                BlockState above = this.m_9236_().m_8055_(blockpos.m_7494_());
                if (this.m_9236_().m_5776_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), blockpos) || !above.m_60795_()) continue;
                if (Math.random() < 0.9) {
                    if (Math.random() < 0.5) {
                        this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.GROWTHS_BIG.get()).m_49966_(), 3);
                    } else {
                        this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.GROWTHS_SMALL.get()).m_49966_(), 3);
                    }
                }
                if (!(Math.random() < 0.3)) continue;
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.REMAINS.get()).m_49966_(), 3);
                break;
            }
        }
    }

    private void placeFrozenRemains() {
        if ((this.isFreazing() || this.m_146888_() > 0) && Math.random() < 0.3) {
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockState = this.m_9236_().m_8055_(blockpos);
                BlockState above = this.m_9236_().m_8055_(blockpos.m_7494_());
                if (this.m_9236_().m_5776_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), blockpos) || !above.m_60795_() || !(Math.random() < 0.3)) continue;
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)Sblocks.FROZEN_REMAINS.get()).m_49966_(), 3);
                break;
            }
        }
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_21435_, MobSpawnType p_21436_, @org.jetbrains.annotations.Nullable SpawnGroupData p_21437_, @org.jetbrains.annotations.Nullable CompoundTag p_21438_) {
        this.setDefaultLinkage(serverLevelAccessor);
        this.spawnWithPoints();
        if (!(this instanceof Experiment) && ((Boolean)SConfig.SERVER.daytime_spawn.get()).booleanValue() && p_21436_ == MobSpawnType.NATURAL) {
            this.teleportToSurface(this.m_9236_(), (Mob)this);
        }
        return super.m_6518_(serverLevelAccessor, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setDefaultLinkage(ServerLevelAccessor level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            Infected infected;
            this.setLinked(true);
            if (Math.random() < 0.3 && (infected = this) instanceof EvolvingInfected) {
                EvolvingInfected evolvingInfected = (EvolvingInfected)((Object)infected);
                if (evolvingInfected instanceof EvolvedInfected) {
                    this.setEvoPoints(this.getEvoPoints() + (Integer)SConfig.SERVER.min_kills_hyper.get());
                } else {
                    this.setEvoPoints(this.getEvoPoints() + (Integer)SConfig.SERVER.min_kills.get());
                }
                this.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get());
            }
            this.enchantEquipment((LivingEntity)this);
        }
    }

    public void spawnWithPoints() {
        if (!((Boolean)SConfig.SERVER.at_mob.get()).booleanValue() && Math.random() < 0.3 && this instanceof EvolvingInfected) {
            this.setEvoPoints((Integer)SConfig.SERVER.min_kills.get());
        }
    }

    public void teleportToSurface(Level level, Mob entity) {
        if (level.m_45527_(entity.m_20183_())) {
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.m_14107_((double)entity.m_20185_()), level.m_151558_(), Mth.m_14107_((double)entity.m_20189_()));
        while (pos.m_123342_() > level.m_141937_()) {
            pos.m_122173_(Direction.DOWN);
            BlockState state = level.m_8055_((BlockPos)pos);
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            if (!state.m_60804_((BlockGetter)level, (BlockPos)pos) || !stateAbove.m_60795_()) continue;
            entity.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.01, (double)pos.m_123343_() + 0.5);
            return;
        }
    }

    public void enchantEquipment(LivingEntity living) {
        if (living instanceof ArmedInfected) {
            ArmedInfected armedInfected = (ArmedInfected)living;
            armedInfected.enchantItems(living);
        }
    }

    public boolean m_142582_(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)Seffects.MARKER.get())) {
            return true;
        }
        return super.m_142582_(entity);
    }

    protected void m_7472_(DamageSource source, int val, boolean bool) {
        super.m_7472_(source, val, bool);
        if (this.getDropList() == null) {
            return;
        }
        if (!this.getDropList().isEmpty()) {
            for (String string : this.getDropList()) {
                String[] string2 = string.split("\\|");
                ItemStack itemStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string2[0]))));
                int m = 1;
                if (Integer.parseUnsignedInt(string2[2]) == Integer.parseUnsignedInt(string2[3])) {
                    int o = Integer.parseUnsignedInt(string2[3]);
                    m = val > 0 ? this.f_19796_.m_216339_(o, o + val) : o;
                } else if (Integer.parseUnsignedInt(string2[2]) >= 1 && Integer.parseUnsignedInt(string2[2]) >= 1) {
                    int v1 = Integer.parseUnsignedInt(string2[2]);
                    int v2 = Integer.parseUnsignedInt(string2[3]);
                    float e = (float)m * (0.15f * (float)val);
                    int i = e > (float)val ? (int)e : val;
                    m = this.f_19796_.m_216339_(v1, v2 + i);
                }
                int value = Integer.parseUnsignedInt(string2[1]) + val * 10;
                if (!(Math.random() < (double)((float)value / 100.0f))) continue;
                itemStack.m_41764_(m);
                ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
                item.m_32010_(10);
                this.m_9236_().m_7967_((Entity)item);
            }
        }
    }

    public String getMutation() {
        return null;
    }
}

