/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.IkLegWithHitbox;
import com.Harbinger.Spore.Sentities.Organoids.TentaclePart;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class Tentacle
extends UtilityEntity {
    private final TentaclePart[] completeArray;
    private final IkLegWithHitbox rightFrontHitbox;
    private final IkLegWithHitbox leftFrontHitbox;
    private final IkLegWithHitbox rightBackHitbox;
    private final IkLegWithHitbox leftBackHitbox;
    private final IkLegWithHitbox[] IkLegs;

    public Tentacle(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        TentaclePart part0 = new TentaclePart(this, "segment0", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part1 = new TentaclePart(this, "segment1", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part2 = new TentaclePart(this, "segment2", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part3 = new TentaclePart(this, "segment3", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part4 = new TentaclePart(this, "segment4", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part5 = new TentaclePart(this, "segment5", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part6 = new TentaclePart(this, "segment6", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part7 = new TentaclePart(this, "segment7", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part8 = new TentaclePart(this, "segment8", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part9 = new TentaclePart(this, "segment9", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part10 = new TentaclePart(this, "segment10", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        TentaclePart part11 = new TentaclePart(this, "segment11", new EntityDimensions(0.5f, 0.5f, false), 1.0f);
        this.completeArray = new TentaclePart[]{part0, part1, part2, part3, part4, part5, part6, part7, part8, part9, part10, part11};
        this.rightFrontHitbox = new IkLegWithHitbox((Entity)this, new TentaclePart[]{part0, part1, part2}, LEGS.RIGHT_FRONT.getBodySet(), LEGS.RIGHT_FRONT.getOffset(), 8.0f, 1.0f, 2.0f, 0.5f);
        this.leftFrontHitbox = new IkLegWithHitbox((Entity)this, new TentaclePart[]{part3, part4, part5}, LEGS.LEFT_FRONT.getBodySet(), LEGS.LEFT_FRONT.getOffset(), 8.0f, 1.0f, 2.0f, 0.5f);
        this.rightBackHitbox = new IkLegWithHitbox((Entity)this, new TentaclePart[]{part6, part7, part8}, LEGS.RIGHT_BACK.getBodySet(), LEGS.RIGHT_BACK.getOffset(), 8.0f, 1.0f, 2.0f, 0.5f);
        this.leftBackHitbox = new IkLegWithHitbox((Entity)this, new TentaclePart[]{part9, part10, part11}, LEGS.LEFT_BACK.getBodySet(), LEGS.LEFT_BACK.getOffset(), 8.0f, 1.0f, 2.0f, 0.5f);
        this.IkLegs = new IkLegWithHitbox[]{this.rightFrontHitbox, this.leftFrontHitbox, this.rightBackHitbox, this.leftBackHitbox};
        int baseId = f_19843_.getAndAdd(this.completeArray.length + 1);
        this.m_20234_(baseId);
        this.m_274367_(1.0f);
    }

    public void m_20234_(int entityId) {
        super.m_20234_(entityId);
        for (int i = 0; i < this.completeArray.length; ++i) {
            this.completeArray[i].m_20234_(entityId + i + 1);
        }
    }

    public PartEntity<?>[] getRightSegments() {
        return this.rightFrontHitbox.getEntities();
    }

    public PartEntity<?>[] getLeftSegments() {
        return this.leftFrontHitbox.getEntities();
    }

    public PartEntity<?>[] getRightBackSegments() {
        return this.rightBackHitbox.getEntities();
    }

    public PartEntity<?>[] getLeftBackSegments() {
        return this.leftBackHitbox.getEntities();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.mound_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.mound_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        for (int i = 0; i < this.completeArray.length; ++i) {
            this.completeArray[i].m_20234_(i + clientboundAddEntityPacket.m_131496_());
        }
    }

    public PartEntity<?>[] getParts() {
        return this.completeArray;
    }

    protected void m_8099_() {
        this.addTargettingGoals();
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19797_ % 20 == 0) {
            for (IkLegWithHitbox leg : this.IkLegs) {
                leg.refreshLegStandingPoint();
            }
        }
        for (IkLegWithHitbox leg : this.IkLegs) {
            leg.applyIK();
            this.spawnParticlesInPlaces(leg.getSitPosition(), leg, false);
            this.spawnParticlesInPlaces(leg.getSitPosition(), leg, true);
        }
    }

    private void spawnParticlesInPlaces(Vec3 vec3, IkLegWithHitbox legs, boolean fire) {
        if (fire) {
            Vec3 positionOnBody = legs.getDefaultBodyOffset();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, positionOnBody.f_82479_, positionOnBody.f_82480_, positionOnBody.f_82481_, 0.0, 0.2, 0.0);
        } else if (vec3 != null) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.2, 0.0);
        }
    }

    public boolean hurt(TentaclePart tentaclePart, DamageSource source, float amount) {
        return this.m_6469_(source, amount * 0.25f);
    }

    public static enum LEGS {
        RIGHT_FRONT(new Vec3(0.5, 1.5, -0.5), new Vec3(3.0, -0.5, -3.0)),
        LEFT_FRONT(new Vec3(0.5, 1.5, 0.5), new Vec3(3.0, -0.5, 3.0)),
        RIGHT_BACK(new Vec3(-0.5, 1.5, -0.5), new Vec3(-3.0, -0.5, -3.0)),
        LEFT_BACK(new Vec3(-0.5, 1.5, 0.5), new Vec3(-3.0, -0.5, 3.0));

        private final Vec3 bodySet;
        private final Vec3 offset;

        private LEGS(Vec3 bodySet, Vec3 offset) {
            this.bodySet = bodySet;
            this.offset = offset;
        }

        public Vec3 getOffset() {
            return this.offset;
        }

        public Vec3 getBodySet() {
            return this.bodySet;
        }
    }
}

