/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HevokerModel;
import com.Harbinger.Spore.Client.Models.HevokerModelDead;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.Hyper.Hevoker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HevokerRenderer
extends BaseInfectedRenderer<Hevoker, EntityModel<Hevoker>> {
    private final EntityModel<Hevoker> normalBraio = this.m_7200_();
    private final EntityModel<Hevoker> deadHevoker;
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/hyper_evoker.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/hyper_evoker.png");

    public HevokerRenderer(EntityRendererProvider.Context context) {
        super(context, new HevokerModel(context.m_174023_(HevokerModel.LAYER_LOCATION)), 1.0f);
        this.deadHevoker = new HevokerModelDead<Hevoker>(context.m_174023_(HevokerModelDead.LAYER_LOCATION));
        this.m_115326_(new TotemLayer(this, context.m_234598_()));
        this.m_115326_(new VolatileGlowingLayers(this));
    }

    public ResourceLocation getTextureLocation(Hevoker hevoker) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    @Override
    protected boolean isShaking(Hevoker type) {
        return super.isShaking(type) || type.isFakeDead();
    }

    public void render(Hevoker hevoker, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        this.f_115290_ = hevoker.isFakeDead() ? this.deadHevoker : this.normalBraio;
        super.m_7392_(hevoker, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    private static class TotemLayer<T extends Hevoker, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final ItemInHandRenderer itemInHandRenderer;

        public TotemLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
            super(parent);
            this.itemInHandRenderer = itemInHandRenderer;
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float v3, float v4, float v5) {
            if (((Hevoker)((Object)t)).isFakeDead()) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42747_);
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 1.0, (double)0.3f);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(30.0f));
                this.itemInHandRenderer.m_109322_(t, stack, ItemTransforms.TransformType.FIXED, true, poseStack, multiBufferSource, i);
                poseStack.m_85849_();
            }
        }
    }

    static class VolatileGlowingLayers<T extends Hevoker, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/hyper_evoker_glow.png");

        public VolatileGlowingLayers(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_() && !((Hevoker)((Object)entity)).isFakeDead()) {
                float alpha = 0.5f + 0.5f * Mth.m_14031_((float)(ageInTicks * 0.1f));
                VertexConsumer vertexConsumer = buffer.m_6299_(SporeRenderTypes.glowingTranslucent(TEXTURE));
                this.m_117386_().m_7695_(matrixStack, vertexConsumer, packedLight, 0xF00000, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }
}

