/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.DrownedScamperModel;
import com.Harbinger.Spore.Client.Models.ScamperModel;
import com.Harbinger.Spore.Client.Models.ScamperVillagerModel;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.Variants.ScamperVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScamperHumanRenderer
extends MobRenderer<Scamper, EntityModel<Scamper>> {
    private final EntityModel<Scamper> defaultModel = this.m_7200_();
    private final EntityModel<Scamper> villagerModel;
    private final EntityModel<Scamper> drownedModel;
    public static final Map<ScamperVariants, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(ScamperVariants.class), p_114874_ -> {
        p_114874_.put(ScamperVariants.DEFAULT, new ResourceLocation("spore", "textures/entity/scamper.png"));
        p_114874_.put(ScamperVariants.VILLAGER, new ResourceLocation("spore", "textures/entity/villager_scamper.png"));
        p_114874_.put(ScamperVariants.DROWNED, new ResourceLocation("spore", "textures/entity/drowned_scamper.png"));
    });

    public ScamperHumanRenderer(EntityRendererProvider.Context context) {
        super(context, new ScamperModel(context.m_174023_(ScamperModel.LAYER_LOCATION)), 0.5f);
        this.villagerModel = new ScamperVillagerModel<Scamper>(context.m_174023_(ScamperVillagerModel.LAYER_LOCATION));
        this.drownedModel = new DrownedScamperModel<Scamper>(context.m_174023_(DrownedScamperModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Scamper scamper) {
        return TEXTURE.get((Object)scamper.getVariant());
    }

    public void render(Scamper scamper, float value1, float value2, PoseStack stack, MultiBufferSource source, int value3) {
        this.f_115290_ = scamper.getVariant() == ScamperVariants.VILLAGER ? this.villagerModel : (scamper.getVariant() == ScamperVariants.DROWNED ? this.drownedModel : this.defaultModel);
        super.m_7392_((Mob)scamper, value1, value2, stack, source, value3);
    }
}

