/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.ZoaholicModel;
import com.Harbinger.Spore.Client.Special.BaseBlockEntityRenderer;
import com.Harbinger.Spore.SBlockEntities.ZoaholicBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ZoaholicRenderer
extends BaseBlockEntityRenderer<ZoaholicBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/block/zoaholic/zoaholic.png");
    private static final ResourceLocation GLASS = new ResourceLocation("spore", "textures/block/zoaholic/zoaholic_glass.png");
    private static final ResourceLocation BUTTONS = new ResourceLocation("spore", "textures/block/zoaholic/zoaholic_buttons.png");

    public ZoaholicRenderer() {
        super(new ZoaholicModel());
    }

    @Override
    public ResourceLocation getTexture(ZoaholicBlockEntity entity) {
        return TEXTURE;
    }

    public void render(@NotNull ZoaholicBlockEntity blockEntity, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        super.m_6922_(blockEntity, partialTicks, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        if (this.unRenderBlock(blockEntity)) {
            this.renderGlassTransparency(blockEntity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            this.renderActiveButtons(blockEntity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderGlassTransparency(ZoaholicBlockEntity blockEntity, PoseStack stack, MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)GLASS));
        this.setModelScale(stack, blockEntity);
        this.getModel().m_7695_(stack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderActiveButtons(ZoaholicBlockEntity zoaholicBlockEntity, PoseStack stack, MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(zoaholicBlockEntity.isActive() ? RenderType.m_110488_((ResourceLocation)BUTTONS) : RenderType.m_110452_((ResourceLocation)BUTTONS));
        this.getModel().m_7695_(stack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void setModelScale(PoseStack pPoseStack, ZoaholicBlockEntity block) {
        int e = block.getSide();
        this.setModelScale(pPoseStack, block, e);
    }
}

